/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GChannelViewer;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GPChannelStack
extends GPluginFrame {
    private JScrollPane scrollPane;
    private JPanel pScroll;
    private JButton newButton;
    private JButton upButton;
    private JButton downButton;
    private JButton copyButton;
    private JButton pasteButton;
    private JButton duplicateButton;
    private JButton deleteButton;
    private JButton mergeButton;
    private JButton mergeAllButton;
    private EventDispatcher eventDispatcher;
    private UiControlText samples;
    private static AChannel clipBoardChannel;

    public GPChannelStack(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
        this.frame.setResizable(true);
    }

    @Override
    public String getName() {
        return "channelStack";
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void reload() {
        super.reload();
        if (this.frame.isVisible() && this.getFocussedClip() != null) {
            this.onClipChange();
        }
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.pScroll = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.add((Component)jPanel2, "North");
        this.scrollPane = new JScrollPane(this.pScroll, 22, 31);
        this.scrollPane.setPreferredSize(new Dimension(200, 200));
        jPanel.add((Component)this.scrollPane, "Center");
        this.newButton = new JButton(this.loadIcon("new"));
        this.newButton.setToolTipText(GLanguage.translate("newChannel"));
        this.newButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.newButton);
        this.upButton = new JButton(this.loadIcon("up"));
        this.upButton.setToolTipText(GLanguage.translate("moveChannelUp"));
        this.upButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.upButton);
        this.downButton = new JButton(this.loadIcon("down"));
        this.downButton.setToolTipText(GLanguage.translate("moveChannelDown"));
        this.downButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.downButton);
        this.copyButton = new JButton(this.loadIcon("copy"));
        this.copyButton.setToolTipText(GLanguage.translate("copyChannel"));
        this.copyButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.copyButton);
        this.pasteButton = new JButton(this.loadIcon("paste"));
        this.pasteButton.setToolTipText(GLanguage.translate("pasteChannel"));
        this.pasteButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.pasteButton);
        this.duplicateButton = new JButton(this.loadIcon("duplicate"));
        this.duplicateButton.setToolTipText(GLanguage.translate("duplicateChannel"));
        this.duplicateButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.duplicateButton);
        this.deleteButton = new JButton(this.loadIcon("delete"));
        this.deleteButton.setToolTipText(GLanguage.translate("deleteChannel"));
        this.deleteButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.deleteButton);
        this.mergeButton = new JButton(this.loadIcon("mergeUpChannel"));
        this.mergeButton.setToolTipText(GLanguage.translate("mergeUpChannel"));
        this.mergeButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.mergeButton);
        this.mergeAllButton = new JButton(this.loadIcon("mergeAllChannels"));
        this.mergeAllButton.setToolTipText(GLanguage.translate("mergeAllChannels"));
        this.mergeAllButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.mergeAllButton);
        jPanel.add((Component)jPanel3, "South");
        this.frame.getContentPane().add(jPanel);
        this.frame.setSize(new Dimension(360, 260));
        this.eventDispatcher = new EventDispatcher();
        this.newButton.addActionListener(this.eventDispatcher);
        this.upButton.addActionListener(this.eventDispatcher);
        this.downButton.addActionListener(this.eventDispatcher);
        this.copyButton.addActionListener(this.eventDispatcher);
        this.pasteButton.addActionListener(this.eventDispatcher);
        this.duplicateButton.addActionListener(this.eventDispatcher);
        this.deleteButton.addActionListener(this.eventDispatcher);
        this.mergeButton.addActionListener(this.eventDispatcher);
        this.mergeAllButton.addActionListener(this.eventDispatcher);
    }

    private void updateThisAndFocussedClip() {
        this.frame.validate();
        this.frame.repaint();
        this.repaintFocussedClipEditor();
    }

    private JPanel createNewChannelDialogContent(int n) {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 1);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("samples")), 0, 0, 4, 1);
        this.samples = new GControlTextX(Laoe.getInstance(), 10, true, true);
        this.samples.setDataRange(1.0, 1.0E9);
        this.samples.setData(n);
        uiCartesianLayout.add(this.samples, 4, 0, 6, 1);
        return jPanel;
    }

    private void onNewButton() {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        if (GDialog.showCustomOkCancelDialog(this.frame, this.createNewChannelDialogContent(aLayer.getMaxSampleLength()), GLanguage.translate("newChannelNoHtml"))) {
            aLayer.insert(new AChannel((int)this.samples.getData()), aLayer.getSelectedIndex());
            this.onClipChange();
            this.autoScaleFocussedClip();
            this.reloadFocussedClipEditor();
            this.updateHistory(GLanguage.translate("newChannel"));
        }
    }

    private void onDownButton() {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        aLayer.moveUp(aLayer.getSelectedIndex());
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClipEditor();
        this.updateHistory(GLanguage.translate("moveChannelDown"));
    }

    private void onUpButton() {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        aLayer.moveDown(aLayer.getSelectedIndex());
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClipEditor();
        this.updateHistory(GLanguage.translate("moveChannelUp"));
    }

    private void onCopyButton() {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        clipBoardChannel = new AChannel(aLayer.getSelectedChannel());
    }

    private void onPasteButton() {
        if (clipBoardChannel != null) {
            ALayer aLayer = this.getFocussedClip().getSelectedLayer();
            aLayer.insert(new AChannel(clipBoardChannel), aLayer.getSelectedIndex());
            this.onClipChange();
            this.autoScaleFocussedClip();
            this.reloadFocussedClipEditor();
            this.updateHistory(GLanguage.translate("copyChannel"));
        }
    }

    private void onDuplicateButton() {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        aLayer.insert(new AChannel(aLayer.getSelectedChannel()), aLayer.getSelectedIndex());
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClipEditor();
        this.updateHistory(GLanguage.translate("duplicateChannel"));
    }

    private void onDeleteButton() {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        aLayer.remove(aLayer.getSelectedIndex());
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClipEditor();
        this.updateHistory(GLanguage.translate("deleteChannel"));
    }

    private void onMergeButton() {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        aLayer.mergeDownChannel(aLayer.getSelectedIndex());
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClipEditor();
        this.updateHistory(GLanguage.translate("mergeUpChannel"));
    }

    private void onMergeAllButton() {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        aLayer.mergeAllChannels();
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClipEditor();
        this.updateHistory(GLanguage.translate("mergeAllChannels"));
    }

    private void onClipChange() {
        AClip aClip = this.getFocussedClip();
        this.pScroll.removeAll();
        this.pScroll.setPreferredSize(new Dimension(300, 60 * this.getFocussedClip().getSelectedLayer().getNumberOfChannels()));
        for (int i = 0; i < aClip.getSelectedLayer().getNumberOfChannels(); ++i) {
            this.pScroll.add(new ChannelPanel(this, aClip, i));
        }
        this.updateThisAndFocussedClip();
    }

    private class ChannelPanel
    extends JPanel
    implements ActionListener,
    MouseListener {
        private JCheckBox audible;
        private GChannelViewer channelView;
        private JTextField channelName;
        private boolean selected;
        private GPChannelStack channelStack;
        private ALayer layer;
        private AChannel channel;
        private int channelIndex;

        public ChannelPanel(GPChannelStack gPChannelStack2, AClip aClip, int n) {
            this.setLayout(new BoxLayout(this, 0));
            this.channelStack = gPChannelStack2;
            this.layer = aClip.getSelectedLayer();
            this.channelIndex = n;
            this.channel = this.layer.getChannel(n);
            this.audible = new JCheckBox();
            this.audible.setSelectedIcon(GToolkit.loadIcon(this, "audibleSelectedCheckBox"));
            this.audible.setIcon(GToolkit.loadIcon(this, "audibleUnselectedCheckBox"));
            this.audible.setToolTipText(GLanguage.translate("audible"));
            this.audible.setSelected(this.channel.isAudible());
            this.audible.addActionListener(this);
            this.add(this.audible);
            this.channelView = new GChannelViewer(GPChannelStack.this.getFocussedClip(), aClip.getSelectedIndex(), n);
            this.channelView.setPreferredSize(new Dimension(100, 30));
            this.channelView.addMouseListener(this);
            this.add(this.channelView);
            this.channelName = new JTextField(30);
            this.channelName.setToolTipText(GLanguage.translate("channelName"));
            this.channelName.setText(this.channel.getName());
            this.channelName.addActionListener(this);
            this.add(this.channelName);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setSelected(this.layer.getSelected() == this.channel);
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(340, 40));
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            Color color = new Color(4746398);
            if (this.selected) {
                this.setBackground(color);
                this.audible.setBackground(color);
                this.channelName.setBackground(color);
            }
            this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == this.channelName) {
                    Debug.println(1, "plugin " + this.channelStack.getName() + " name [enter] clicked");
                    this.channel.setName(this.channelName.getText());
                } else if (actionEvent.getSource() == this.audible) {
                    Debug.println(1, "plugin " + this.channelStack.getName() + " [audible] clicked");
                    this.channel.setAudible(this.audible.isSelected());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Debug.println(1, "plugin " + this.getName() + " [select channel] mouse-click");
            this.layer.setSelectedIndex(this.channelIndex);
            this.channelStack.onClipChange();
            this.channelStack.reloadFocussedClipEditor();
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LProgressViewer.getInstance().entrySubProgress(GPChannelStack.this.getName());
                if (actionEvent.getSource() == GPChannelStack.this.newButton) {
                    Debug.println(1, "plugin " + GPChannelStack.this.getName() + " [new] clicked");
                    GPChannelStack.this.onNewButton();
                } else if (actionEvent.getSource() == GPChannelStack.this.upButton) {
                    Debug.println(1, "plugin " + GPChannelStack.this.getName() + " [up] clicked");
                    GPChannelStack.this.onUpButton();
                } else if (actionEvent.getSource() == GPChannelStack.this.downButton) {
                    Debug.println(1, "plugin " + GPChannelStack.this.getName() + " [down] clicked");
                    GPChannelStack.this.onDownButton();
                } else if (actionEvent.getSource() == GPChannelStack.this.copyButton) {
                    Debug.println(1, "plugin " + GPChannelStack.this.getName() + " [copy] clicked");
                    GPChannelStack.this.onCopyButton();
                } else if (actionEvent.getSource() == GPChannelStack.this.pasteButton) {
                    Debug.println(1, "plugin " + GPChannelStack.this.getName() + " [paste] clicked");
                    GPChannelStack.this.onPasteButton();
                } else if (actionEvent.getSource() == GPChannelStack.this.duplicateButton) {
                    Debug.println(1, "plugin " + GPChannelStack.this.getName() + " [duplicate] clicked");
                    GPChannelStack.this.onDuplicateButton();
                } else if (actionEvent.getSource() == GPChannelStack.this.deleteButton) {
                    Debug.println(1, "plugin " + GPChannelStack.this.getName() + " [delete] clicked");
                    GPChannelStack.this.onDeleteButton();
                } else if (actionEvent.getSource() == GPChannelStack.this.mergeButton) {
                    Debug.println(1, "plugin " + GPChannelStack.this.getName() + " [merge] clicked");
                    GPChannelStack.this.onMergeButton();
                } else if (actionEvent.getSource() == GPChannelStack.this.mergeAllButton) {
                    Debug.println(1, "plugin " + GPChannelStack.this.getName() + " [merge all] clicked");
                    GPChannelStack.this.onMergeAllButton();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            LProgressViewer.getInstance().exitSubProgress();
        }
    }
}

