/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.LProgressViewer;

public class AOResample
extends AOperation {
    private double sampleRateFactor = 1.0;
    private int order = 2;

    public AOResample() {
    }

    public AOResample(float f, int n) {
        this();
        this.sampleRateFactor = f;
        this.order = n;
    }

    public AOResample(int n) {
        this();
        this.order = n;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        int n3 = (int)((double)n2 / this.sampleRateFactor);
        aChannelSelection.getChannel().markChange();
        MMArray mMArray2 = new MMArray(mMArray.getLength() - n2 + n3, 0.0f);
        mMArray2.copy(mMArray, 0, 0, n);
        double d = n;
        LProgressViewer.getInstance().entrySubProgress(0.7);
        for (int i = n; i < n + n3; ++i) {
            if (LProgressViewer.getInstance().setProgress((double)(i + 1 - n) * 1.0 / (double)n3)) {
                return;
            }
            if ((int)d + 1 >= mMArray.getLength()) break;
            switch (this.order) {
                case 0: {
                    mMArray2.set(i, AOToolkit.interpolate0(mMArray, (float)d));
                    break;
                }
                case 1: {
                    mMArray2.set(i, AOToolkit.interpolate1(mMArray, (float)d));
                    break;
                }
                case 2: {
                    mMArray2.set(i, AOToolkit.interpolate2(mMArray, (float)d));
                    break;
                }
                case 3: {
                    mMArray2.set(i, AOToolkit.interpolate3(mMArray, (float)d));
                }
            }
            d += this.sampleRateFactor;
        }
        LProgressViewer.getInstance().exitSubProgress();
        mMArray2.copy(mMArray, n + n2, n + n3, mMArray2.getLength() - n - n3);
        aChannelSelection.getChannel().setSamples(mMArray2);
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        MMArray mMArray2 = aChannelSelection2.getChannel().getSamples();
        aChannelSelection.getChannel().markChange();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            try {
                d += (double)(1.0f / mMArray2.get(n + i));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                d += 1.0;
            }
        }
        MMArray mMArray3 = new MMArray(mMArray.getLength() - n2 + (int)d, 0.0f);
        mMArray3.copy(mMArray, 0, 0, n);
        double d2 = n;
        LProgressViewer.getInstance().entrySubProgress(0.7);
        int n3 = n;
        while ((double)n3 < (double)n + d) {
            if (LProgressViewer.getInstance().setProgress((double)(n3 + 1 - n) * 1.0 / (double)((int)d))) {
                return;
            }
            if ((int)d2 + 1 >= mMArray.getLength()) break;
            switch (this.order) {
                case 0: {
                    mMArray3.set(n3, AOToolkit.interpolate0(mMArray, (float)d2));
                    break;
                }
                case 1: {
                    mMArray3.set(n3, AOToolkit.interpolate1(mMArray, (float)d2));
                    break;
                }
                case 2: {
                    mMArray3.set(n3, AOToolkit.interpolate2(mMArray, (float)d2));
                    break;
                }
                case 3: {
                    mMArray3.set(n3, AOToolkit.interpolate3(mMArray, (float)d2));
                }
            }
            try {
                d2 = mMArray2.get((int)d2) > 0.0f ? (d2 += (double)mMArray2.get((int)d2)) : (d2 += 1.0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                d2 += 1.0;
            }
            ++n3;
        }
        LProgressViewer.getInstance().exitSubProgress();
        mMArray3.copy(mMArray, n + n2, n + (int)d, mMArray3.getLength() - n - (int)d);
        aChannelSelection.getChannel().setSamples(mMArray3);
    }
}

