/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOperation;

public class AONoiseGenerator
extends AOperation {
    private float amplitude;
    private float offset;
    private int noiseType;
    public static final int WHITE = 1;
    public static final int TRIANGLE = 2;
    public static final int GAUSSIAN = 3;
    private boolean add;

    public AONoiseGenerator(float f, float f2, int n, boolean bl) {
        this.amplitude = f;
        this.offset = f2;
        this.noiseType = n;
        this.add = bl;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        for (int i = n; i < n + n2; ++i) {
            float f = 0.0f;
            switch (this.noiseType) {
                case 1: {
                    f = (float)((double)this.offset + (2.0 * Math.random() - 1.0) * (double)this.amplitude);
                    break;
                }
                case 2: {
                    f = (float)((double)this.offset + (Math.random() + Math.random() - 1.0) * (double)this.amplitude);
                    break;
                }
                case 3: {
                    f = (float)((double)this.offset + Math.sqrt(-2.0 * Math.log(Math.random())) * Math.cos(Math.PI * 2 * Math.random()) * (double)this.amplitude);
                }
            }
            if (this.add) {
                mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), mMArray.get(i) + f));
                continue;
            }
            mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), f));
        }
    }
}

