/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;

public class AOMath
extends AOperation {
    private int operation;
    public static final int ADD = 1;
    public static final int SUBTRACT = 2;
    public static final int MULTIPLY = 3;
    public static final int DIVIDE = 4;
    public static final int INVERS = 5;
    public static final int NEG = 6;
    public static final int POW = 7;
    public static final int SQRT = 8;
    public static final int DERIVATE = 9;
    public static final int INTEGRATE = 10;
    public static final int EXP = 11;
    public static final int LOG = 12;
    public static final int TO_dB = 13;
    public static final int FROM_dB = 14;
    public static final int MEAN = 15;
    public static final int RMS = 16;
    private float[] operands;

    public AOMath(int n, float[] fArray) {
        this(n);
        this.operands = fArray;
    }

    public AOMath(int n) {
        this.operation = n;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        switch (this.operation) {
            case 1: {
                AOToolkit.add(mMArray, n, n2, this.operands[0]);
                break;
            }
            case 2: {
                AOToolkit.subtract(mMArray, n, n2, this.operands[0]);
                break;
            }
            case 3: {
                AOToolkit.multiply(mMArray, n, n2, this.operands[0]);
                break;
            }
            case 4: {
                AOToolkit.divide(mMArray, n, n2, this.operands[0]);
                break;
            }
            case 9: {
                AOToolkit.derivate(mMArray, n, n2);
                break;
            }
            case 10: {
                AOToolkit.integrate(mMArray, n, n2);
                break;
            }
            case 5: {
                AOToolkit.invers(mMArray, n, n2);
                break;
            }
            case 6: {
                AOToolkit.neg(mMArray, n, n2);
                break;
            }
            case 7: {
                AOToolkit.pow(mMArray, n, n2, this.operands[0]);
                break;
            }
            case 8: {
                AOToolkit.sqrt(mMArray, n, n2);
                break;
            }
            case 11: {
                AOToolkit.exp(mMArray, n, n2);
                break;
            }
            case 12: {
                AOToolkit.log(mMArray, n, n2);
                break;
            }
            case 13: {
                AOToolkit.todB(mMArray, n, n2);
                break;
            }
            case 14: {
                AOToolkit.fromdB(mMArray, n, n2);
                break;
            }
            case 15: {
                AOToolkit.smooth(mMArray, n, n2, (int)this.operands[0]);
                break;
            }
            case 16: {
                AOToolkit.smoothRms(mMArray, n, n2, (int)this.operands[0]);
            }
        }
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        MMArray mMArray2 = aChannelSelection2.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        switch (this.operation) {
            case 1: {
                AOToolkit.add(mMArray, mMArray2, n, n2);
                break;
            }
            case 2: {
                AOToolkit.subtract(mMArray, mMArray2, n, n2);
                break;
            }
            case 3: {
                AOToolkit.multiply(mMArray, mMArray2, n, n2);
                break;
            }
            case 4: {
                AOToolkit.divide(mMArray, mMArray2, n, n2);
            }
        }
    }
}

