/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;

public class AOBandPass
extends AOperation {
    private float dry;
    private float wet;
    private float freq;
    private float q;

    public AOBandPass(float f, float f2, float f3, float f4) {
        this.dry = f;
        this.wet = f2;
        this.freq = f3;
        this.q = f4;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        float f = AOToolkit.rmsAverage(mMArray, n, n2);
        MMArray mMArray2 = new MMArray(n2, 0.0f);
        aChannelSelection.getChannel().markChange();
        AOToolkit.addIirBandPass(mMArray, mMArray2, n, n2, this.freq, this.q, this.wet);
        float f2 = AOToolkit.rmsAverage(mMArray2, 0, n2);
        AOToolkit.multiply(mMArray2, 0, n2, f / f2);
        for (int i = 0; i < n2; ++i) {
            mMArray.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray.get(i + n), mMArray.get(i + n) * this.dry + mMArray2.get(i)));
        }
        AOToolkit.applyZeroCross(mMArray, n);
        AOToolkit.applyZeroCross(mMArray, n + n2);
    }
}

