/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.LProgressViewer;

public class AOAutoVolume
extends AOperation {
    private float dry;
    private float wet;
    private int tAttack;
    private int tRelease;
    private boolean backward;
    private float meanAmplitude;

    public AOAutoVolume(int n, float f, float f2, int n2, int n3, boolean bl) {
        this.dry = f;
        this.wet = f2;
        this.tAttack = n2;
        this.tRelease = n3;
        this.backward = bl;
    }

    private void updateAmplitude(float f) {
        this.meanAmplitude = (f = Math.abs(f)) > this.meanAmplitude ? AOToolkit.movingRmsAverage(this.meanAmplitude, f, this.tAttack) : AOToolkit.movingRmsAverage(this.meanAmplitude, f, this.tRelease);
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        int n;
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n2 = aChannelSelection.getOffset();
        int n3 = aChannelSelection.getLength();
        float f = AOToolkit.rmsAverage(mMArray, n2, n3);
        aChannelSelection.getChannel().markChange();
        this.meanAmplitude = 1.0f;
        if (this.backward) {
            for (n = n3 - 1; n >= Math.max(0, n3 - this.tAttack - this.tRelease); --n) {
                this.updateAmplitude(mMArray.get(n + n2));
            }
        } else {
            for (n = 0; n < Math.min(n3, this.tAttack + this.tRelease); ++n) {
                this.updateAmplitude(mMArray.get(n + n2));
            }
        }
        try {
            LProgressViewer.getInstance().entrySubProgress(0.7);
            if (this.backward) {
                for (n = n3 - 1; n >= 0; --n) {
                    if (LProgressViewer.getInstance().setProgress((double)(n3 - n) * 1.0 / (double)n3)) {
                        return;
                    }
                    this.updateAmplitude(mMArray.get(n + n2));
                    mMArray.set(n + n2, aChannelSelection.mixIntensity(n + n2, mMArray.get(n + n2), 1000.0f / this.meanAmplitude * mMArray.get(n + n2) * this.wet + mMArray.get(n + n2) * this.dry));
                }
            } else {
                for (n = 0; n < n3; ++n) {
                    if (LProgressViewer.getInstance().setProgress((double)(n + 1) * 1.0 / (double)n3)) {
                        return;
                    }
                    this.updateAmplitude(mMArray.get(n + n2));
                    mMArray.set(n + n2, aChannelSelection.mixIntensity(n + n2, mMArray.get(n + n2), 1000.0f / this.meanAmplitude * mMArray.get(n + n2) * this.wet + mMArray.get(n + n2) * this.dry));
                }
            }
            float f2 = AOToolkit.rmsAverage(mMArray, n2, n3);
            AOToolkit.multiply(mMArray, n2, n3, f / f2);
            LProgressViewer.getInstance().exitSubProgress();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

