/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.ui.Debug;

public class MMArray1 {
    private float[] samples;
    private int length;
    private final float initialValue;

    public MMArray1(int n, float f) {
        if (n < 0) {
            n = 0;
        }
        this.samples = new float[n];
        this.length = n;
        this.initialValue = f;
        if (f != 0.0f) {
            for (int i = 0; i < this.samples.length; ++i) {
                this.samples[i] = f;
            }
        }
    }

    public MMArray1(MMArray1 mMArray1) {
        this(mMArray1.getLength(), 0.0f);
        System.arraycopy(mMArray1.samples, 0, this.samples, 0, mMArray1.getLength());
    }

    public final void destroy() {
        this.set(new float[0]);
    }

    public final void cleanup() {
        int n;
        for (n = this.samples.length - 1; n >= 0 && this.samples[n] == this.initialValue; --n) {
        }
        if (n <= this.samples.length / 2) {
            System.out.println("MMArray1 shrink: length=" + this.getLength() + " memory-usage=" + n);
            float[] fArray = new float[n];
            System.arraycopy(this.samples, 0, fArray, 0, fArray.length);
            this.samples = fArray;
            this.length = Math.min(this.length, this.samples.length);
        }
    }

    public final int getLength() {
        return this.length;
    }

    public final int getMemoryUsage() {
        return this.samples.length;
    }

    public final boolean isInRange(int n) {
        return n >= 0 && n < this.length;
    }

    public final float get(int n) {
        if (this.isInRange(n)) {
            return this.samples[n];
        }
        return this.initialValue;
    }

    public final void set(int n, float f) {
        if (n < 0) {
            return;
        }
        if (n >= this.samples.length) {
            this.grow(n);
        }
        if (n >= this.length) {
            this.length = n + 1;
        }
        this.samples[n] = f;
    }

    public final void set(float[] fArray) {
        this.samples = fArray;
        this.length = fArray.length;
    }

    public final void copy(MMArray1 mMArray1, int n, int n2, int n3) {
        if (mMArray1.isInRange(n) && mMArray1.isInRange(n + n3 - 1) && this.isInRange(n2) && this.isInRange(n2 + n3 - 1)) {
            System.arraycopy(mMArray1.samples, n, this.samples, n2, n3);
            this.length = Math.max(n2 + n3, this.length);
        } else {
            for (int i = 0; i < n3; ++i) {
                this.set(n2 + i, mMArray1.get(n + i));
            }
        }
    }

    private final void grow(int n) {
        long l = System.currentTimeMillis();
        int n2 = Math.min(this.samples.length, 8000000);
        float[] fArray = new float[Math.max(this.samples.length + n2, n + 1)];
        System.arraycopy(this.samples, 0, fArray, 0, this.samples.length);
        if (this.initialValue != 0.0f) {
            for (int i = this.samples.length; i < fArray.length; ++i) {
                fArray[i] = this.initialValue;
            }
        }
        this.samples = fArray;
        this.length = n + 1;
        Debug.println(6, "MMArray1 grow: length=" + this.getLength() + " memory-usage=" + this.getMemoryUsage());
        System.out.println("MMArray1 grow: length=" + this.getLength() + " memory-usage=" + this.getMemoryUsage() + " grow-time=" + (System.currentTimeMillis() - l));
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        System.out.println("test array with initial value of zero...");
        MMArray1 mMArray1 = new MMArray1(100, 0.0f);
        if (mMArray1.getLength() != 100) {
            System.out.println("failed 1");
        }
        if (!mMArray1.isInRange(0)) {
            System.out.println("failed 2");
        }
        if (mMArray1.isInRange(-1)) {
            System.out.println("failed 3");
        }
        if (!mMArray1.isInRange(66)) {
            System.out.println("failed 4");
        }
        if (!mMArray1.isInRange(99)) {
            System.out.println("failed 5");
        }
        if (mMArray1.isInRange(100)) {
            System.out.println("failed 6");
        }
        if (mMArray1.get(0) != 0.0f) {
            System.out.println("failed 7");
        }
        if (mMArray1.get(55) != 0.0f) {
            System.out.println("failed 8");
        }
        if (mMArray1.get(99) != 0.0f) {
            System.out.println("failed 9");
        }
        if (mMArray1.get(333) != 0.0f) {
            System.out.println("failed 10");
        }
        mMArray1.set(77, 4.0f);
        if (mMArray1.get(77) != 4.0f) {
            System.out.println("failed 11");
        }
        if (mMArray1.getLength() != 100) {
            System.out.println("failed 12");
        }
        mMArray1.set(111, 7.0f);
        if (mMArray1.get(77) != 4.0f) {
            System.out.println("failed 21");
        }
        if (mMArray1.get(110) != 0.0f) {
            System.out.println("failed 22");
        }
        if (mMArray1.get(111) != 7.0f) {
            System.out.println("failed 23");
        }
        if (mMArray1.getLength() != 112) {
            System.out.println("failed 24");
        }
        mMArray1.set(1111, 7777.0f);
        if (mMArray1.get(77) != 4.0f) {
            System.out.println("failed 31");
        }
        if (mMArray1.get(111) != 7.0f) {
            System.out.println("failed 32");
        }
        if (mMArray1.get(1110) != 0.0f) {
            System.out.println("failed 34");
        }
        if (mMArray1.get(1111) != 7777.0f) {
            System.out.println("failed 35");
        }
        if (mMArray1.getLength() != 1112) {
            System.out.println("failed 36");
        }
        if (!mMArray1.isInRange(0)) {
            System.out.println("failed 36a");
        }
        if (mMArray1.isInRange(-1)) {
            System.out.println("failed 36b");
        }
        if (!mMArray1.isInRange(66)) {
            System.out.println("failed 36c");
        }
        if (!mMArray1.isInRange(99)) {
            System.out.println("failed 36d");
        }
        if (!mMArray1.isInRange(100)) {
            System.out.println("failed 36e");
        }
        if (!mMArray1.isInRange(1111)) {
            System.out.println("failed 36f");
        }
        if (mMArray1.isInRange(1112)) {
            System.out.println("failed 36g");
        }
        if (mMArray1.isInRange(999999)) {
            System.out.println("failed 36h");
        }
        System.out.println("test copied array...");
        MMArray1 mMArray12 = new MMArray1(mMArray1);
        if (mMArray12.get(77) != 4.0f) {
            System.out.println("failed 41");
        }
        if (mMArray12.get(111) != 7.0f) {
            System.out.println("failed 42");
        }
        if (mMArray12.get(1110) != 0.0f) {
            System.out.println("failed 44");
        }
        if (mMArray12.get(1111) != 7777.0f) {
            System.out.println("failed 45");
        }
        if (mMArray12.getLength() != 1112) {
            System.out.println("failed 46");
        }
        mMArray12.set(1234, 2345.0f);
        if (mMArray12.get(1234) != 2345.0f) {
            System.out.println("failed 47");
        }
        if (mMArray12.getLength() != 1235) {
            System.out.println("failed 48");
        }
        if (mMArray1.get(1234) != 0.0f) {
            System.out.println("failed 49");
        }
        if (mMArray1.getLength() != 1112) {
            System.out.println("failed 49b");
        }
        System.out.println("test array with initial value other than zero...");
        MMArray1 mMArray13 = new MMArray1(100, 69.0f);
        if (mMArray13.getLength() != 100) {
            System.out.println("failed 51");
        }
        if (mMArray13.get(0) != 69.0f) {
            System.out.println("failed 52");
        }
        if (mMArray13.get(55) != 69.0f) {
            System.out.println("failed 53");
        }
        if (mMArray13.get(99) != 69.0f) {
            System.out.println("failed 54");
        }
        if (mMArray13.get(333) != 69.0f) {
            System.out.println("failed 55");
        }
        mMArray13.set(77, 4.0f);
        if (mMArray13.get(77) != 4.0f) {
            System.out.println("failed 61");
        }
        if (mMArray13.getLength() != 100) {
            System.out.println("failed 62");
        }
        mMArray13.set(111, 7.0f);
        if (mMArray13.get(77) != 4.0f) {
            System.out.println("failed 71");
        }
        if (mMArray13.get(110) != 69.0f) {
            System.out.println("failed 72");
        }
        if (mMArray13.get(111) != 7.0f) {
            System.out.println("failed 73");
        }
        if (mMArray13.getLength() != 112) {
            System.out.println("failed 74");
        }
        mMArray13.set(1111, 7777.0f);
        if (mMArray13.get(77) != 4.0f) {
            System.out.println("failed 81");
        }
        if (mMArray13.get(111) != 7.0f) {
            System.out.println("failed 82");
        }
        if (mMArray13.get(1110) != 69.0f) {
            System.out.println("failed 84");
        }
        if (mMArray13.get(1111) != 7777.0f) {
            System.out.println("failed 85");
        }
        if (mMArray13.getLength() != 1112) {
            System.out.println("failed 86");
        }
        System.out.println("test array replaced...");
        mMArray13.set(new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        if (mMArray13.getLength() != 4) {
            System.out.println("failed 91");
        }
        if (mMArray13.get(0) != 1.0f) {
            System.out.println("failed 92");
        }
        if (mMArray13.get(2) != 3.0f) {
            System.out.println("failed 93");
        }
        if (mMArray13.get(3) != 4.0f) {
            System.out.println("failed 94");
        }
        if (mMArray13.get(4) != 69.0f) {
            System.out.println("failed 95");
        }
        System.out.println("test array copy in range...");
        MMArray1 mMArray14 = new MMArray1(100, 44.0f);
        MMArray1 mMArray15 = new MMArray1(100, 44.0f);
        for (n3 = 0; n3 < mMArray14.getLength(); ++n3) {
            mMArray14.set(n3, n3);
        }
        mMArray15.copy(mMArray14, 40, 0, 10);
        for (n3 = 0; n3 < 10; ++n3) {
            if (mMArray15.get(n3) == (float)(40 + n3)) continue;
            System.out.println("failed " + (100 + n3));
        }
        if (mMArray15.get(39) != 44.0f) {
            System.out.println("failed 111");
        }
        if (mMArray15.get(50) != 44.0f) {
            System.out.println("failed 112");
        }
        System.out.println("test array copy extra range...");
        mMArray14 = new MMArray1(70, 22.0f);
        mMArray15 = new MMArray1(600, 44.0f);
        for (n3 = 0; n3 < mMArray14.getLength(); ++n3) {
            mMArray14.set(n3, n3);
        }
        mMArray15.copy(mMArray14, 40, 0, 300);
        for (n3 = 0; n3 < 20; ++n3) {
            if (mMArray15.get(n3) == (float)(40 + n3)) continue;
            System.out.println("failed " + (200 + n3));
        }
        if (mMArray15.get(299) != 22.0f) {
            System.out.println("failed 221");
        }
        if (mMArray15.get(300) != 44.0f) {
            System.out.println("failed 222");
        }
        System.out.println("test array growing...");
        mMArray14 = new MMArray1(5, 0.0f);
        mMArray14.set(5000000, 99.0f);
        if (mMArray14.get(5000000) != 99.0f) {
            System.out.println("failed 921");
        }
        if (mMArray14.get(4999990) != 0.0f) {
            System.out.println("failed 922");
        }
        if (mMArray14.get(5000010) != 0.0f) {
            System.out.println("failed 923");
        }
        mMArray14.set(10000000, 66.0f);
        if (mMArray14.get(10000000) != 66.0f) {
            System.out.println("failed 924");
        }
        mMArray14.set(20000000, 77.0f);
        if (mMArray14.get(20000000) != 77.0f) {
            System.out.println("failed 925");
        }
        mMArray14.set(40000000, 77.0f);
        if (mMArray14.get(40000000) != 77.0f) {
            System.out.println("failed 926");
        }
        mMArray14.set(80000000, 77.0f);
        if (mMArray14.get(80000000) != 77.0f) {
            System.out.println("failed 927");
        }
        System.out.print("profiling calibration...            ");
        mMArray14 = new MMArray1(2000000, 0.0f);
        long l = System.currentTimeMillis();
        int n4 = mMArray14.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray14.getLength() + " ps/element");
        System.out.print("profiling get()...                  ");
        mMArray14 = new MMArray1(2000000, 0.0f);
        l = System.currentTimeMillis();
        n4 = mMArray14.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
                mMArray14.get(n);
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray14.getLength() + " ps/element");
        System.out.print("profiling set()...                  ");
        mMArray14 = new MMArray1(2000000, 0.0f);
        l = System.currentTimeMillis();
        n4 = mMArray14.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
                mMArray14.set(n, n);
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray14.getLength() + " ps/element");
        System.out.print("profiling manual get() and set()... ");
        mMArray14 = new MMArray1(2000000, 0.0f);
        l = System.currentTimeMillis();
        n4 = mMArray14.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
                mMArray14.set(n, mMArray14.get(n + 2));
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray14.getLength() + " ps/element");
        System.out.print("profiling copy() in range...        ");
        mMArray14 = new MMArray1(2000000, 44.0f);
        MMArray1 mMArray16 = new MMArray1(2000001, 22.0f);
        long l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 100; ++n2) {
            mMArray16.copy(mMArray14, 0, 0, mMArray14.getLength());
        }
        System.out.println("" + (System.currentTimeMillis() - l2) * 10000000L / (long)mMArray14.getLength() + " ps/element");
        System.out.print("profiling copy() extra range...     ");
        mMArray14 = new MMArray1(2000000, 44.0f);
        mMArray16 = new MMArray1(2000001, 22.0f);
        l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 100; ++n2) {
            mMArray16.copy(mMArray14, 0, 0, mMArray16.getLength());
        }
        System.out.println("" + (System.currentTimeMillis() - l2) * 10000000L / (long)mMArray16.getLength() + " ps/element");
        System.out.println("if not failed then passed...!");
    }
}

