/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.audio.Audio;
import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelMarker;
import ch.laoe.clip.AChannelMask;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.AObject;
import ch.laoe.clip.MMArray;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GEditableSegments;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.LProgressViewer;
import ch.oli4.io.XmlInputStream;
import ch.oli4.io.XmlOutputStream;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.sound.sampled.AudioFormat;

public class AClipStorage {
    private static final boolean channelCompressionEnable = GPersistence.createPersistance().getBoolean("history.compression");

    public static boolean supports(File file) throws IOException {
        return file.getPath().endsWith(".laoe");
    }

    public static boolean load(AClip aClip, File file) throws IOException {
        ALayer aLayer = null;
        AChannel aChannel = null;
        AChannelSelection aChannelSelection = null;
        AChannelMask aChannelMask = null;
        AChannelMarker aChannelMarker = null;
        int n = 0;
        int n2 = 0;
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
            XmlInputStream xmlInputStream = new XmlInputStream(gZIPInputStream);
            boolean bl = true;
            boolean bl2 = true;
            while (bl) {
                int n3 = xmlInputStream.read();
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        if (xmlInputStream.getTagName().equals("laoe")) {
                            if (xmlInputStream.getAttribute("samples").equals("below")) {
                                bl2 = true;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("clip")) {
                            aClip.removeAll();
                            aClip.setName(xmlInputStream.getAttribute("name"));
                            aClip.setSampleRate(Float.parseFloat(xmlInputStream.getAttribute("samplerate")));
                            aClip.setSampleWidth(Integer.parseInt(xmlInputStream.getAttribute("samplewidth")));
                            aClip.setComments(xmlInputStream.getAttribute("comment"));
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("layer")) {
                            aLayer = new ALayer();
                            aLayer.setName(xmlInputStream.getAttribute("name"));
                            String string = xmlInputStream.getAttribute("type");
                            if (string.equals("audioLayer")) {
                                aLayer.setType(1);
                            } else if (string.equals("parameterLayer")) {
                                aLayer.setType(2);
                            }
                            String string2 = xmlInputStream.getAttribute("plotType");
                            if (string2 != null) {
                                if (string2.equals("sampleCurve")) {
                                    aLayer.setPlotType(1);
                                } else if (string2.equals("spectrogram")) {
                                    aLayer.setPlotType(2);
                                }
                            }
                            aClip.add(aLayer);
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("channel")) {
                            aChannel = new AChannel();
                            if (!bl2) {
                                aChannel.setChangeId(xmlInputStream.getAttribute("id"));
                            }
                            aChannel.setName(xmlInputStream.getAttribute("name"));
                            aChannel.setAudible(xmlInputStream.getAttribute("audible").equals("true"));
                            aLayer.add(aChannel);
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("selection")) {
                            aChannelSelection = new AChannelSelection();
                            aChannel.setSelection(aChannelSelection);
                            aChannelSelection.setChannel(aChannel);
                            aChannelSelection.setName(xmlInputStream.getAttribute("name"));
                            aChannelSelection.setOffset(Integer.parseInt(xmlInputStream.getAttribute("offset")));
                            aChannelSelection.setLength(Integer.parseInt(xmlInputStream.getAttribute("length")));
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("mask")) {
                            aChannelMask = aChannel.getMask();
                            aChannelMask.setName(xmlInputStream.getAttribute("name"));
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("markers")) {
                            aChannelMarker = aChannel.getMarker();
                            aChannelMarker.setName(xmlInputStream.getAttribute("name"));
                            break;
                        }
                        if (!xmlInputStream.getTagName().equals("graphicObjects")) break;
                        aChannel.getGraphicObjects().fromXmlElement(xmlInputStream);
                        break;
                    }
                    case 4: {
                        if (!xmlInputStream.getTagName().equals("laoe")) break;
                        bl = false;
                        break;
                    }
                    case 5: {
                        if (xmlInputStream.getTagName().equals("selection")) {
                            aChannelSelection = new AChannelSelection();
                            aChannel.setSelection(aChannelSelection);
                            aChannelSelection.setChannel(aChannel);
                            aChannelSelection.setName(xmlInputStream.getAttribute("name"));
                            aChannelSelection.setOffset(Integer.parseInt(xmlInputStream.getAttribute("offset")));
                            aChannelSelection.setLength(Integer.parseInt(xmlInputStream.getAttribute("length")));
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("plotter")) {
                            aChannel.getPlotter().setXRange(Float.parseFloat(xmlInputStream.getAttribute("xOffset")), Float.parseFloat(xmlInputStream.getAttribute("xLength")));
                            aChannel.getPlotter().setYRange(Float.parseFloat(xmlInputStream.getAttribute("yOffset")), Float.parseFloat(xmlInputStream.getAttribute("yLength")));
                            if (!xmlInputStream.containsAttribute("color")) break;
                            aLayer.getPlotter().setColor(new Color(Integer.parseInt(xmlInputStream.getAttribute("color"), 16)));
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("clipPlotter")) {
                            if (xmlInputStream.containsAttribute("bgColor")) {
                                aClip.getPlotter().setBgColor(new Color(Integer.parseInt(xmlInputStream.getAttribute("bgColor"), 16)));
                            }
                            if (!xmlInputStream.containsAttribute("gridColor")) break;
                            aClip.getPlotter().setGridColor(new Color(Integer.parseInt(xmlInputStream.getAttribute("gridColor"), 16)));
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("audio")) {
                            n2 = Integer.parseInt(xmlInputStream.getAttribute("loopEndPointer"));
                            n = Integer.parseInt(xmlInputStream.getAttribute("loopStartPointer"));
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("samples")) {
                            aChannel.setSamples(new MMArray(Integer.parseInt(xmlInputStream.getAttribute("length")), 0.0f));
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("intensity")) {
                            float f = Float.parseFloat(xmlInputStream.getAttribute("x"));
                            float f2 = Float.parseFloat(xmlInputStream.getAttribute("y"));
                            aChannelSelection.addIntensityPoint(f, f2);
                            break;
                        }
                        if (xmlInputStream.getTagName().equals("volumePoint")) {
                            float f = Float.parseFloat(xmlInputStream.getAttribute("x"));
                            float f3 = Float.parseFloat(xmlInputStream.getAttribute("y"));
                            aChannelMask.getSegments().addPoint(f, f3);
                            break;
                        }
                        if (!xmlInputStream.getTagName().equals("markerPoint")) break;
                        int n4 = Integer.parseInt(xmlInputStream.getAttribute("x"));
                        aChannelMarker.addMarker(n4);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case -1: {
                        bl = false;
                    }
                }
            }
            aClip.getAudio().setLoopEndPointer(n2);
            aClip.getAudio().setLoopStartPointer(n);
            aClip.getAudio().setEncoding(AudioFormat.Encoding.PCM_SIGNED);
            aClip.getAudio().setFileType(Audio.fileTypeLaoe);
            if (bl2) {
                ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
                LProgressViewer.getInstance().entrySubProgress(0.9, "clip " + file.getName());
                for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
                    if (LProgressViewer.getInstance().setProgress(1.0 * (double)(i + 1) / (double)aClip.getNumberOfLayers())) {
                        return false;
                    }
                    aLayer = aClip.getLayer(i);
                    LProgressViewer.getInstance().entrySubProgress(0.3, "layer " + i);
                    for (int j = 0; j < aLayer.getNumberOfChannels(); ++j) {
                        if (LProgressViewer.getInstance().setProgress(1.0 * (double)(j + 1) / (double)aLayer.getNumberOfChannels())) {
                            return false;
                        }
                        aChannel = aLayer.getChannel(j);
                        LProgressViewer.getInstance().entrySubProgress(0.3, "channel " + j);
                        aChannel.setSamples(AClipStorage.loadSamples(objectInputStream));
                        LProgressViewer.getInstance().exitSubProgress();
                    }
                    LProgressViewer.getInstance().exitSubProgress();
                }
                LProgressViewer.getInstance().exitSubProgress();
                objectInputStream.close();
            } else {
                xmlInputStream.close();
            }
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
        }
        return true;
    }

    public static void save(AClip aClip, File file) throws IOException {
        AClipStorage.save(aClip, file, true);
    }

    public static void saveWithoutSamples(AClip aClip, File file) throws IOException {
        AClipStorage.save(aClip, file, false);
    }

    private static void save(AClip aClip, File file, boolean bl) throws IOException {
        try {
            AObject aObject;
            AClipPlotter aClipPlotter;
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            XmlOutputStream xmlOutputStream = new XmlOutputStream(gZIPOutputStream);
            xmlOutputStream.appendSystemTag();
            xmlOutputStream.appendCR();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("version", "0.7.06");
            hashMap.put("fileformat", "one");
            if (bl) {
                hashMap.put("samples", "below");
            } else {
                hashMap.put("samples", "extern");
            }
            xmlOutputStream.appendBeginTag("laoe", hashMap);
            xmlOutputStream.appendCR();
            hashMap.clear();
            hashMap.put("name", aClip.getName());
            hashMap.put("samplerate", Float.toString(aClip.getSampleRate()));
            hashMap.put("samplewidth", Integer.toString(aClip.getSampleWidth()));
            hashMap.put("comment", aClip.getComments());
            xmlOutputStream.appendTab(1);
            xmlOutputStream.appendBeginTag("clip", hashMap);
            xmlOutputStream.appendCR();
            Audio audio = aClip.getAudio();
            if (audio != null) {
                hashMap.clear();
                hashMap.put("loopStartPointer", Integer.toString(audio.getLoopStartPointer()));
                hashMap.put("loopEndPointer", Integer.toString(audio.getLoopEndPointer()));
                xmlOutputStream.appendTab(2);
                xmlOutputStream.appendBeginEndTag("audio", hashMap);
                xmlOutputStream.appendCR();
            }
            if ((aClipPlotter = aClip.getPlotter()) != null) {
                hashMap.clear();
                hashMap.put("bgColor", Integer.toString(aClip.getPlotter().getBgColor().getRGB(), 16));
                hashMap.put("gridColor", Integer.toString(aClip.getPlotter().getGridColor().getRGB(), 16));
                xmlOutputStream.appendTab(2);
                xmlOutputStream.appendBeginEndTag("clipPlotter", hashMap);
                xmlOutputStream.appendCR();
            }
            for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
                ALayer aLayer = aClip.getLayer(i);
                hashMap.clear();
                hashMap.put("index", Integer.toString(i));
                hashMap.put("name", aLayer.getName());
                switch (aLayer.getType()) {
                    case 2: {
                        hashMap.put("type", "parameterLayer");
                        break;
                    }
                    default: {
                        hashMap.put("type", "audioLayer");
                    }
                }
                switch (aLayer.getPlotType()) {
                    case 1: {
                        hashMap.put("plotType", "sampleCurve");
                        break;
                    }
                    case 2: {
                        hashMap.put("plotType", "spectrogram");
                    }
                }
                xmlOutputStream.appendTab(2);
                xmlOutputStream.appendBeginTag("layer", hashMap);
                xmlOutputStream.appendCR();
                for (int j = 0; j < aLayer.getNumberOfChannels(); ++j) {
                    AChannelPlotter aChannelPlotter;
                    int n;
                    Object object;
                    AChannel aChannel = aLayer.getChannel(j);
                    hashMap.clear();
                    hashMap.put("index", Integer.toString(j));
                    hashMap.put("name", aChannel.getName());
                    hashMap.put("id", aChannel.getChangeId());
                    hashMap.put("audible", String.valueOf(aChannel.isAudible()));
                    xmlOutputStream.appendTab(3);
                    xmlOutputStream.appendBeginTag("channel", hashMap);
                    xmlOutputStream.appendCR();
                    hashMap.clear();
                    hashMap.put("length", Integer.toString(aChannel.getSampleLength()));
                    if (!bl) {
                        hashMap.put("location", aChannel.getChangeId());
                    }
                    xmlOutputStream.appendTab(4);
                    xmlOutputStream.appendBeginEndTag("samples", hashMap);
                    xmlOutputStream.appendCR();
                    aObject = aChannel.getSelection();
                    if (aObject != null) {
                        hashMap.clear();
                        hashMap.put("name", aObject.getName());
                        hashMap.put("offset", Integer.toString(((AChannelSelection)aObject).getOffset()));
                        hashMap.put("length", Integer.toString(((AChannelSelection)aObject).getLength()));
                        xmlOutputStream.appendTab(4);
                        xmlOutputStream.appendBeginTag("selection", hashMap);
                        xmlOutputStream.appendCR();
                        object = ((AChannelSelection)aObject).getIntensityPoints();
                        for (int k = 0; k < ((ArrayList)object).size(); ++k) {
                            hashMap.clear();
                            hashMap.put("x", Float.toString((float)((AChannelSelection.Point)((ArrayList)object).get((int)k)).x));
                            hashMap.put("y", Float.toString((float)((AChannelSelection.Point)((ArrayList)object).get((int)k)).y));
                            xmlOutputStream.appendTab(5);
                            xmlOutputStream.appendBeginEndTag("intensity", hashMap);
                            xmlOutputStream.appendCR();
                        }
                        xmlOutputStream.appendTab(4);
                        xmlOutputStream.appendEndTag("intensity");
                        xmlOutputStream.appendCR();
                    }
                    if ((object = aChannel.getMask()) != null) {
                        hashMap.clear();
                        hashMap.put("name", ((AObject)object).getName());
                        xmlOutputStream.appendTab(4);
                        xmlOutputStream.appendBeginTag("mask", hashMap);
                        xmlOutputStream.appendCR();
                        GEditableSegments gEditableSegments = ((AChannelMask)object).getSegments();
                        for (n = 0; n < gEditableSegments.getNumberOfPoints(); ++n) {
                            hashMap.clear();
                            hashMap.put("x", Float.toString((float)gEditableSegments.getPointX(n)));
                            hashMap.put("y", Float.toString((float)gEditableSegments.getPointY(n)));
                            xmlOutputStream.appendTab(5);
                            xmlOutputStream.appendBeginEndTag("volumePoint", hashMap);
                            xmlOutputStream.appendCR();
                        }
                        xmlOutputStream.appendTab(4);
                        xmlOutputStream.appendEndTag("mask");
                        xmlOutputStream.appendCR();
                    }
                    AChannelMarker aChannelMarker = aChannel.getMarker();
                    if (object != null) {
                        hashMap.clear();
                        hashMap.put("name", aChannelMarker.getName());
                        xmlOutputStream.appendTab(4);
                        xmlOutputStream.appendBeginTag("markers", hashMap);
                        xmlOutputStream.appendCR();
                        for (n = 0; n < aChannelMarker.getNumberOfMarkers(); ++n) {
                            hashMap.clear();
                            hashMap.put("x", Integer.toString(aChannelMarker.getMarkerX(n)));
                            xmlOutputStream.appendTab(5);
                            xmlOutputStream.appendBeginEndTag("markerPoint", hashMap);
                            xmlOutputStream.appendCR();
                        }
                        xmlOutputStream.appendTab(4);
                        xmlOutputStream.appendEndTag("markers");
                        xmlOutputStream.appendCR();
                    }
                    if ((aChannelPlotter = aChannel.getPlotter()) != null) {
                        hashMap.clear();
                        hashMap.put("xOffset", Float.toString((float)aChannelPlotter.getXOffset()));
                        hashMap.put("xLength", Float.toString((float)aChannelPlotter.getXLength()));
                        hashMap.put("yOffset", Float.toString(aChannelPlotter.getYOffset()));
                        hashMap.put("yLength", Float.toString(aChannelPlotter.getYLength()));
                        hashMap.put("color", Integer.toString(aLayer.getPlotter().getColor().getRGB(), 16));
                        xmlOutputStream.appendTab(4);
                        xmlOutputStream.appendBeginEndTag("plotter", hashMap);
                        xmlOutputStream.appendCR();
                    }
                    if (aChannel.getGraphicObjects() != null) {
                        aChannel.getGraphicObjects().toXmlElement(xmlOutputStream);
                    }
                    xmlOutputStream.appendTab(3);
                    xmlOutputStream.appendEndTag("channel");
                    xmlOutputStream.appendCR();
                }
                xmlOutputStream.appendTab(2);
                xmlOutputStream.appendEndTag("layer");
                xmlOutputStream.appendCR();
            }
            xmlOutputStream.appendTab(1);
            xmlOutputStream.appendEndTag("clip");
            xmlOutputStream.appendCR();
            xmlOutputStream.appendEndTag("laoe");
            if (bl) {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
                LProgressViewer.getInstance().entrySubProgress(0.3, "clip " + file.getName());
                for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
                    if (LProgressViewer.getInstance().setProgress(1.0 * (double)(i + 1) / (double)aClip.getNumberOfLayers())) {
                        return;
                    }
                    ALayer aLayer = aClip.getLayer(i);
                    LProgressViewer.getInstance().entrySubProgress(0.3, "layer " + i);
                    for (int j = 0; j < aLayer.getNumberOfChannels(); ++j) {
                        if (LProgressViewer.getInstance().setProgress(1.0 * (double)(j + 1) / (double)aLayer.getNumberOfChannels())) {
                            return;
                        }
                        aObject = aLayer.getChannel(j);
                        LProgressViewer.getInstance().entrySubProgress(0.3, "channel " + j);
                        AClipStorage.saveSamples((AChannel)aObject, objectOutputStream);
                        LProgressViewer.getInstance().exitSubProgress();
                    }
                    LProgressViewer.getInstance().exitSubProgress();
                }
                objectOutputStream.close();
                LProgressViewer.getInstance().exitSubProgress();
            } else {
                xmlOutputStream.appendCR();
                xmlOutputStream.close();
            }
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
        }
    }

    private static MMArray loadSamples(ObjectInputStream objectInputStream) throws IOException {
        try {
            LProgressViewer.getInstance().entrySubProgress(0.9);
            int n = objectInputStream.readInt();
            MMArray mMArray = new MMArray(n, 0.0f);
            for (int i = 0; i < mMArray.getLength(); ++i) {
                mMArray.set(i, objectInputStream.readFloat());
                if ((i & 0x3FF) != 0 || !LProgressViewer.getInstance().setProgress(1.0 * (double)(i + 1) / (double)mMArray.getLength())) continue;
                return mMArray;
            }
            LProgressViewer.getInstance().exitSubProgress();
            return mMArray;
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
            return null;
        }
    }

    private static void saveSamples(AChannel aChannel, ObjectOutputStream objectOutputStream) throws IOException {
        try {
            LProgressViewer.getInstance().entrySubProgress(0.9);
            objectOutputStream.writeInt(aChannel.getSampleLength());
            for (int i = 0; i < aChannel.getSampleLength(); ++i) {
                objectOutputStream.writeFloat(aChannel.getSample(i));
                if ((i & 0x3FF) != 0 || !LProgressViewer.getInstance().setProgress(1.0 * (double)(i + 1) / (double)aChannel.getSampleLength())) continue;
                return;
            }
            objectOutputStream.flush();
            LProgressViewer.getInstance().exitSubProgress();
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
        }
    }

    public static void saveSamples(AChannel aChannel, File file) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = channelCompressionEnable ? new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file)))) : new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            AClipStorage.saveSamples(aChannel, objectOutputStream);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
        }
    }

    public static MMArray loadSamples(File file) throws IOException {
        try {
            ObjectInputStream objectInputStream = channelCompressionEnable ? new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)))) : new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            MMArray mMArray = AClipStorage.loadSamples(objectInputStream);
            objectInputStream.close();
            return mMArray;
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
            return null;
        }
    }
}

