/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AModel;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;

public class AChannelPlotterSpectrogram
extends AChannelPlotter {
    private static int fftLength = 1024;
    private static int windowType = 3;
    private MMArray re = null;
    private MMArray im = null;
    private String oldId = "";
    private int oldWindowType = 0;
    private int oldFftLength = 0;
    private MMArray cacheMag = null;
    private float magMin;
    private float magMax;
    private float magRange;
    private float magMean;
    private int[] gy;
    private int[] sy;

    public AChannelPlotterSpectrogram(AModel aModel, AChannelPlotter aChannelPlotter) {
        super(aModel, aChannelPlotter);
    }

    @Override
    public double getAutoscaleXOffset() {
        return 0.0;
    }

    @Override
    public double getAutoscaleXLength() {
        return this.getChannelModel().getSampleLength();
    }

    @Override
    public float getAutoscaleYOffset(int n, int n2) {
        return 0.0f;
    }

    @Override
    public float getAutoscaleYLength(int n, int n2) {
        return ((AClip)this.getChannelModel().getParent().getParent()).getSampleRate() / 2.0f;
    }

    @Override
    protected float getValidYOffset() {
        return 0.0f;
    }

    @Override
    protected float getValidYLength() {
        return ((AClip)this.getChannelModel().getParent().getParent()).getSampleRate() / 2.0f;
    }

    public static void setFftLength(int n) {
        fftLength = n;
    }

    public static int getFftLength() {
        return fftLength;
    }

    public static void setWindowType(int n) {
        windowType = n;
    }

    public static int getWindowType() {
        return windowType;
    }

    private final void reloadCache() {
        AChannel aChannel = this.getChannelModel();
        if (!this.oldId.equals(aChannel.getChangeId()) || this.oldWindowType != windowType || this.oldFftLength != fftLength) {
            int n = 0;
            LProgressViewer.getInstance().entrySubProgress(GLanguage.translate("reloadCache") + " " + this.model.getName());
            LProgressViewer.getInstance().entrySubProgress(0.9);
            this.oldId = aChannel.getChangeId();
            this.oldWindowType = windowType;
            this.oldFftLength = fftLength;
            Debug.println(7, "reload cache of channel spectrogram plotter name=" + aChannel.getName() + " id=" + aChannel.getChangeId());
            MMArray mMArray = this.getChannelModel().getSamples();
            int n2 = mMArray.getLength() / fftLength;
            if (this.cacheMag == null) {
                this.cacheMag = new MMArray(mMArray.getLength() / 2, 0.0f);
            }
            if (this.cacheMag.getLength() != mMArray.getLength() / 2) {
                this.cacheMag.setLength(mMArray.getLength() / 2);
            }
            this.magMin = Float.MAX_VALUE;
            this.magMax = Float.MIN_VALUE;
            if (this.re == null) {
                this.re = new MMArray(fftLength, 0.0f);
            }
            if (this.re.getLength() != fftLength) {
                this.re.setLength(fftLength);
            }
            if (this.im == null) {
                this.im = new MMArray(fftLength, 0.0f);
            }
            if (this.im.getLength() != fftLength) {
                this.im.setLength(fftLength);
            }
            for (int i = 0; i < n2 + 1; ++i) {
                LProgressViewer.getInstance().setProgress((i + 1) / n2 + 1);
                int n3 = i * fftLength / 2;
                this.re.copy(mMArray, n3 * 2, 0, fftLength);
                this.im.clear();
                AOToolkit.applyFFTWindow(windowType, this.re, fftLength);
                AOToolkit.complexFft(this.re, this.im);
                for (int j = 0; j < fftLength / 2; ++j) {
                    float f = AOToolkit.cartesianToMagnitude(this.re.get(j), this.im.get(j));
                    this.cacheMag.set(n3 + j, f);
                    this.magMin = Math.min(this.magMin, f);
                    this.magMax = Math.max(this.magMax, f);
                    this.magMean += f;
                    ++n;
                }
            }
            this.magRange = Math.max(this.magMax - this.magMin, 1.0E-7f);
            this.magMean /= (float)n;
            this.magMean = (this.magMean - this.magMin) / this.magRange;
            LProgressViewer.getInstance().exitSubProgress();
            LProgressViewer.getInstance().exitSubProgress();
        }
    }

    @Override
    public void paintSamples(Graphics2D graphics2D, Color color, float f) {
        try {
            int n;
            int n2 = 0;
            long l = System.currentTimeMillis();
            this.reloadCache();
            AChannel aChannel = this.getChannelModel();
            AClip aClip = (AClip)aChannel.getParent().getParent();
            int n3 = 1 << aClip.getSampleWidth() - 1;
            float f2 = aClip.getSampleRate();
            int n4 = fftLength / 2;
            float f3 = f2 / 2.0f;
            int n5 = Math.max(2, this.sampleToGraphX(fftLength) - this.sampleToGraphX(0.0));
            int n6 = Math.max(2, this.sampleToGraphY(f2 / (float)fftLength) - this.sampleToGraphY(0.0f));
            int n7 = this.rectangle.width / n5;
            int n8 = this.rectangle.height / n6;
            graphics2D.setClip(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
            graphics2D.setColor(color);
            if (this.gy == null || this.gy.length != n8) {
                this.gy = new int[n8];
            }
            if (this.sy == null || this.sy.length != n8) {
                this.sy = new int[n8];
            }
            for (n = 0; n < n8; ++n) {
                this.gy[n] = this.rectangle.y + n * n6;
                this.sy[n] = (int)this.graphToSampleY(this.gy[n]);
            }
            block3: for (n = 0; n < n7; ++n) {
                int n9 = this.rectangle.x + n * n5;
                int n10 = (int)this.graphToSampleX(n9);
                if (n10 < 0 || n10 > aChannel.getSampleLength()) continue;
                for (int i = 0; i < n8; ++i) {
                    int n11 = this.sy[i];
                    int n12 = this.gy[i];
                    if (n11 < 0) continue block3;
                    if ((float)n11 > f3) continue;
                    float f4 = this.cacheMag.get((int)((float)(n10 / fftLength * n4) + (float)(n11 * n4) / f3));
                    f4 = (f4 - this.magMin) / this.magRange;
                    float f5 = (float)Math.exp(Math.log(f4) * (double)f);
                    float f6 = (float)(1.0 / (1.0 + Math.exp((this.magMean * f - f4) * 1000.0f / f)));
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f6 *= f5));
                    graphics2D.fillRect(n9, n12, n5, n6);
                }
            }
            System.out.println("paint spectrogram time = " + (System.currentTimeMillis() - l) + "ms cnt=" + n2 + " fftLength=" + fftLength);
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }
}

