/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.clip.AModel;
import ch.laoe.clip.APlotter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;

public abstract class AChannelPlotter
extends APlotter {
    private double xOffset;
    private double xLength = 1.0;
    private float yOffset;
    private float yLength = 1.0f;
    protected Rectangle rectangle = new Rectangle(1, 1);

    public AChannelPlotter(AModel aModel) {
        super(aModel);
    }

    public AChannelPlotter(AModel aModel, AChannelPlotter aChannelPlotter) {
        this(aModel);
        if (aChannelPlotter != null) {
            this.xOffset = aChannelPlotter.xOffset;
            this.xLength = aChannelPlotter.xLength;
            this.yOffset = aChannelPlotter.yOffset;
            this.yLength = aChannelPlotter.yLength;
        }
    }

    public AChannel getChannelModel() {
        return (AChannel)this.model;
    }

    @Override
    public void setDefaultName() {
        this.name = "";
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getXLength() {
        return this.xLength;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public float getYLength() {
        return this.yLength;
    }

    public abstract double getAutoscaleXOffset();

    public abstract double getAutoscaleXLength();

    public abstract float getAutoscaleYOffset(int var1, int var2);

    public abstract float getAutoscaleYLength(int var1, int var2);

    protected abstract float getValidYOffset();

    protected abstract float getValidYLength();

    public void setXRange(double d, double d2) {
        this.xOffset = d;
        this.xLength = d2;
        this.limitXRange();
    }

    public void setYRange(float f, float f2) {
        this.yOffset = f;
        this.yLength = f2;
        this.limitYRange();
    }

    public void translateXOffset(double d) {
        this.xOffset += d;
        this.limitXRange();
    }

    public void translateYOffset(float f) {
        this.yOffset += f;
        this.limitYRange();
    }

    private void limitXRange() {
        if (this.xOffset < -1.073741824E9) {
            this.xOffset = -1.073741824E9;
        } else if (this.xOffset > 1.073741823E9) {
            this.xOffset = 1.073741823E9;
        }
        if (this.xLength > 2.147483647E9) {
            this.xLength = 2.147483647E9;
        } else if (this.xLength < (double)0.1f) {
            this.xLength = 0.1f;
        }
    }

    private void limitYRange() {
        if (this.yOffset > 2.1474836E9f) {
            this.yOffset = 2.1474836E9f;
        } else if (this.yOffset < -2.1474836E9f) {
            this.yOffset = -2.1474836E9f;
        }
        if (this.yLength > 2.1474836E9f) {
            this.yLength = 2.1474836E9f;
        }
        if ((double)Math.abs(this.yLength) < 1.0E-12) {
            this.yLength = 1.0E-12f;
        }
    }

    public void zoomX(double d) {
        this.xOffset += this.xLength * (1.0 - 1.0 / d) / 2.0;
        this.xLength /= d;
        this.limitXRange();
    }

    public void zoomX(double d, double d2) {
        double d3 = d2 - this.xOffset;
        double d4 = d3 / d;
        this.xOffset += d3 - d4;
        this.xLength /= d;
        this.limitXRange();
    }

    public void zoomY(double d) {
        this.yOffset = (float)((double)this.yOffset + (double)this.yLength * (1.0 - 1.0 / d) / 2.0);
        this.yLength = (float)((double)this.yLength / d);
        this.limitYRange();
    }

    public void zoomY(double d, double d2) {
        double d3 = d2 - (double)this.yOffset;
        double d4 = d3 / d;
        this.yOffset = (float)((double)this.yOffset + (d3 - d4));
        this.yLength = (float)((double)this.yLength / d);
        this.limitYRange();
    }

    public int sampleToGraphX(double d) {
        return (int)((d - this.xOffset) * (double)this.rectangle.width / this.xLength) + this.rectangle.x;
    }

    public int sampleToGraphY(float f) {
        return (int)((this.yLength - f + this.yOffset) * (float)this.rectangle.height / this.yLength) + this.rectangle.y;
    }

    public int percentToGraphY(float f) {
        return (int)((1.0f - f) * (float)this.rectangle.height) + this.rectangle.y;
    }

    public double graphToSampleX(int n) {
        return this.xOffset + (double)(n - this.rectangle.x) * this.xLength / (double)this.rectangle.width;
    }

    public float graphToSampleY(int n) {
        return this.yOffset + (float)(this.rectangle.height - n + this.rectangle.y) * this.yLength / (float)this.rectangle.height;
    }

    public float graphToPercentY(float f) {
        return ((float)this.rectangle.height - f + (float)this.rectangle.y) / (float)this.rectangle.height;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public boolean isInsideChannel(Point point) {
        return point.y >= this.rectangle.y && point.y <= this.rectangle.y + this.rectangle.height && point.x >= this.rectangle.x && point.y <= this.rectangle.x + this.rectangle.width;
    }

    public void paintFrame(Graphics2D graphics2D) {
        int n = this.rectangle.width;
        int n2 = this.rectangle.height;
        int n3 = this.rectangle.x;
        int n4 = this.rectangle.y;
        int n5 = this.sampleToGraphY(0.0f);
        int n6 = this.sampleToGraphY(this.getValidYOffset());
        int n7 = this.sampleToGraphY(this.getValidYOffset() + this.getValidYLength());
        graphics2D.setClip(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
        graphics2D.setColor(new Color(0x7F3F3F3F, true));
        graphics2D.drawLine(n3, n5, n3 + n - 1, n5);
        graphics2D.setColor(new Color(0x7F555555, true));
        graphics2D.drawLine(n3, n7, n3 + n - 1, n7);
        graphics2D.drawLine(n3, n6, n3 + n - 1, n6);
        graphics2D.setColor(Color.gray);
        graphics2D.drawRect(n3, n4, n - 2, n2 - 2);
        graphics2D.setColor(Color.white);
        graphics2D.drawRect(n3 + 1, n4 + 1, n - 2, n2 - 2);
    }

    public void paintBackground(Graphics2D graphics2D, Color color) {
        graphics2D.setClip(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
        GradientPaint gradientPaint = new GradientPaint(this.rectangle.x, this.rectangle.y, color.brighter().brighter(), this.rectangle.x, this.rectangle.y + this.rectangle.height, color, false);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
    }

    public abstract void paintSamples(Graphics2D var1, Color var2, float var3);

    public void paintMask(Graphics2D graphics2D) {
        this.getChannelModel().getMask().paintOntoClip(graphics2D, this.rectangle);
    }

    public void paintMarker(Graphics2D graphics2D, Rectangle rectangle) {
        this.getChannelModel().getMarker().paintOntoClip(graphics2D, rectangle);
    }

    public void paintSelection(Graphics2D graphics2D, Color color, Color color2) {
        AChannelSelection aChannelSelection = this.getChannelModel().getSelection();
        AClipPlotter aClipPlotter = ((AClip)this.model.getParent().getParent()).getPlotter();
        if (aChannelSelection.isSelected()) {
            int n;
            int n2;
            int n3 = this.sampleToGraphX(aChannelSelection.getOffset());
            int n4 = this.rectangle.y + 2;
            int n5 = this.sampleToGraphX(aChannelSelection.getOffset() + aChannelSelection.getLength());
            int n6 = this.rectangle.height - 5;
            if (n3 < 0) {
                n3 = -50;
            } else if (n3 > this.rectangle.width) {
                return;
            }
            if (n5 > this.rectangle.width) {
                n5 = this.rectangle.width + 50;
            } else if (n5 < 0) {
                return;
            }
            graphics2D.setColor(color);
            graphics2D.setClip(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.18f));
            graphics2D.fillRect(n3, n4, n5 - n3, n6);
            float[] fArray = new float[]{4.0f, 4.0f};
            graphics2D.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, fArray, 0.0f));
            graphics2D.setColor(color2);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.drawRect(n3, n4, n5 - n3, n6);
            graphics2D.setStroke(new BasicStroke());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            int n7 = 0;
            int n8 = 0;
            for (n2 = n3; n2 < n5; n2 += 2) {
                int n9 = n2;
                float f = aChannelSelection.getIntensity((int)this.graphToSampleX(n2));
                n = (int)((1.0f - f) * (float)n6) + n4;
                graphics2D.setColor(color2);
                if (n2 != n3) {
                    graphics2D.drawLine(n7, n8, n9, n);
                }
                n7 = n9;
                n8 = n;
            }
            for (n2 = 0; n2 < aChannelSelection.getIntensityPoints().size(); ++n2) {
                AChannelSelection.Point point = aChannelSelection.getIntensityPoints().get(n2);
                int n10 = this.sampleToGraphX((double)aChannelSelection.getOffset() + (double)aChannelSelection.getLength() * point.x);
                n = (int)((1.0 - point.y) * (double)n6) + n4;
                if (aChannelSelection.getActiveIntensityPointIndex() == n2) {
                    graphics2D.setColor(Color.red);
                    graphics2D.drawRect(n10 - 4, n - 4, 8, 8);
                } else {
                    graphics2D.setColor(color2);
                }
                graphics2D.fillRect(n10 - 2, n - 2, 5, 5);
                float f = (float)point.y;
                String string = "" + f;
                string = string.substring(0, Math.min(string.length(), 5));
                graphics2D.setColor(color2);
                AChannelPlotter.paintText(graphics2D, string, 10, n10, (double)f > 0.5 ? n + 10 : n - 10, false);
            }
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setGroupingUsed(false);
            graphics2D.setColor(color2);
            graphics2D.setFont(new Font("Courrier", 0, 12));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String string = "" + numberFormat.format(aClipPlotter.toPlotterXUnit(aChannelSelection.getOffset())) + aClipPlotter.getPlotterXUnitName();
            String string2 = "" + numberFormat.format(aClipPlotter.toPlotterXUnit(aChannelSelection.getLength())) + aClipPlotter.getPlotterXUnitName();
            int n11 = (n5 + n3) / 2;
            int n12 = n4 + n6 / 2;
            graphics2D.drawString(string, n11 - fontMetrics.stringWidth(string) / 2, n12 - fontMetrics.getHeight() / 2);
            graphics2D.drawString(string2, n11 - fontMetrics.stringWidth(string2) / 2, n12 + fontMetrics.getHeight() / 2);
        }
    }

    public static void paintText(Graphics2D graphics2D, String string, int n, int n2, int n3, boolean bl) {
        if (bl) {
            graphics2D.setFont(new Font("Courrier", 0, n));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n4 = fontMetrics.stringWidth(string) * 2;
            BufferedImage bufferedImage = new BufferedImage(n4, n4, 6);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
            graphics2D2.setColor(graphics2D.getColor());
            graphics2D2.setFont(new Font("Courrier", 0, n));
            graphics2D2.drawString(string, n4 / 2, n4 / 2 + fontMetrics.getAscent() - fontMetrics.getHeight() / 2);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(-1.5707963267948966, n4 / 2, n4 / 2);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
            bufferedImage = affineTransformOp.filter(bufferedImage, null);
            graphics2D.drawImage((Image)bufferedImage, n2 - n4 / 2, n3 - n4 / 2, null);
        } else {
            graphics2D.setFont(new Font("Courrier", 0, n));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(string, n2 - fontMetrics.stringWidth(string) / 2, n3 + fontMetrics.getAscent() - fontMetrics.getHeight() / 2);
        }
    }

    private static String doubleToString(double d) {
        String string = "";
        if (Math.abs(d) >= 1.0E9) {
            d /= 1.0E9;
            string = "G";
        } else if (Math.abs(d) >= 1000000.0) {
            d /= 1000000.0;
            string = "M";
        } else if (Math.abs(d) >= 1000.0) {
            d /= 1000.0;
            string = "k";
        } else if (Math.abs(d) >= 1.0) {
            string = "";
        } else if (Math.abs(d) >= 0.001) {
            d /= 0.001;
            string = "m";
        } else if (Math.abs(d) >= 1.0E-6) {
            d /= 1.0E-6;
            string = "u";
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(d) + string;
    }

    public void paintXSkala(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        if (this.getXLength() < 0.1) {
            return;
        }
        graphics2D.setClip(rectangle.x, rectangle.y - 200, rectangle.width, rectangle.height + 200);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        AChannel aChannel = this.getChannelModel();
        int n = Math.max(0, this.sampleToGraphX(0.0));
        int n2 = Math.min(rectangle.x + rectangle.width, this.sampleToGraphX(aChannel.getSampleLength()));
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, rectangle.y, n2 - n, rectangle.height);
        AClipPlotter aClipPlotter = ((AClip)this.model.getParent().getParent()).getPlotter();
        double d = aClipPlotter.toPlotterXUnit(this.graphToSampleX(rectangle.x));
        int n3 = -1000;
        int n4 = 20;
        int n5 = 7;
        int n6 = (int)((double)rectangle.height * 0.3);
        int n7 = (int)((double)rectangle.height * 0.5);
        int n8 = (int)((double)rectangle.height * 0.8);
        for (int i = 0; i < rectangle.width; ++i) {
            double d2;
            double d3;
            double d4;
            double d5 = aClipPlotter.toPlotterXUnit(this.graphToSampleX(rectangle.x + i));
            if ((int)(d5 / (d4 = Math.pow(10.0, Math.round(Math.log10(Math.abs(d3 = d5 - aClipPlotter.toPlotterXUnit(this.graphToSampleX(rectangle.x + i + n5))))))) / 10.0) != (int)(d / d4 / 10.0) || Math.signum(d5) != Math.signum(d)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + i, rectangle.y, rectangle.x + i, rectangle.y + n8);
                if (AClipPlotter.isSkalaValuesVisible()) {
                    n3 = i;
                    d2 = (double)Math.round(d5 / d4) * d4;
                    graphics2D.setColor(color);
                    AChannelPlotter.paintText(graphics2D, AChannelPlotter.doubleToString(d2) + aClipPlotter.getPlotterXUnitName(), 10, rectangle.x + i, rectangle.y - 6, true);
                }
            } else if ((int)(d5 / d4 / 5.0) != (int)(d / d4 / 5.0) || Math.signum(d5) != Math.signum(d)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + i, rectangle.y, rectangle.x + i, rectangle.y + n7);
                if (i > n3 + n4 && AClipPlotter.isSkalaValuesVisible()) {
                    d2 = (double)Math.round(d5 / d4) * d4;
                    graphics2D.setColor(color);
                    AChannelPlotter.paintText(graphics2D, AChannelPlotter.doubleToString(d2) + aClipPlotter.getPlotterXUnitName(), 10, rectangle.x + i, rectangle.y - 6, true);
                }
            } else if ((int)(d5 / d4) != (int)(d / d4) || Math.signum(d5) != Math.signum(d)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + i, rectangle.y, rectangle.x + i, rectangle.y + n6);
            }
            d = d5;
        }
    }

    public void paintYSkala(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        if ((double)this.getYLength() < 0.1) {
            return;
        }
        graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width + 100, rectangle.height);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        int n = Math.max(0, this.sampleToGraphY(this.getValidYOffset() + this.getValidYLength()));
        int n2 = Math.min(rectangle.y + rectangle.height, this.sampleToGraphY(this.getValidYOffset()));
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(rectangle.x, n, rectangle.width, n2 - n);
        AClipPlotter aClipPlotter = ((AClip)this.model.getParent().getParent()).getPlotter();
        float f = aClipPlotter.toPlotterYUnit(this.graphToSampleY(rectangle.y));
        int n3 = -1000;
        int n4 = 20;
        int n5 = 5;
        int n6 = (int)((double)rectangle.width * 0.3);
        int n7 = (int)((double)rectangle.width * 0.5);
        int n8 = (int)((double)rectangle.width * 0.8);
        for (int i = 0; i < rectangle.height; ++i) {
            float f2;
            float f3;
            double d;
            float f4 = aClipPlotter.toPlotterYUnit(this.graphToSampleY(rectangle.y + i));
            if ((int)((double)f4 / (d = Math.pow(10.0, Math.round(Math.log10(Math.abs(f3 = f4 - aClipPlotter.toPlotterYUnit(this.graphToSampleY(rectangle.y + i + n5))))))) / 10.0) != (int)((double)f / d / 10.0) || Math.signum(f4) != Math.signum(f)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + rectangle.width - n8, rectangle.y + i, rectangle.x + rectangle.width, rectangle.y + i);
                if (AClipPlotter.isSkalaValuesVisible()) {
                    n3 = i;
                    f2 = (float)((double)Math.round((double)f4 / d) * d);
                    graphics2D.setColor(color);
                    AChannelPlotter.paintText(graphics2D, AChannelPlotter.doubleToString(f2) + aClipPlotter.getPlotterYUnitName(), 10, rectangle.x + 30, rectangle.y + i, false);
                }
            } else if ((int)((double)f4 / d / 5.0) != (int)((double)f / d / 5.0) || Math.signum(f4) != Math.signum(f)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + rectangle.width - n7, rectangle.y + i, rectangle.x + rectangle.width, rectangle.y + i);
                if (i > n3 + n4 && AClipPlotter.isSkalaValuesVisible()) {
                    f2 = (float)((double)Math.round((double)f4 / d) * d);
                    graphics2D.setColor(color);
                    AChannelPlotter.paintText(graphics2D, AChannelPlotter.doubleToString(f2) + aClipPlotter.getPlotterYUnitName(), 10, rectangle.x + 30, rectangle.y + i, false);
                }
            } else if ((int)((double)f4 / d) != (int)((double)f / d) || Math.signum(f4) != Math.signum(f)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + rectangle.width - n6, rectangle.y + i, rectangle.x + rectangle.width, rectangle.y + i);
            }
            f = f4;
        }
    }

    public void paintGrid(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        double d;
        int n;
        if (this.getXLength() < 0.1) {
            return;
        }
        graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
        graphics2D.setColor(color);
        AClipPlotter aClipPlotter = ((AClip)this.model.getParent().getParent()).getPlotter();
        double d2 = aClipPlotter.toPlotterXUnit(this.graphToSampleX(rectangle.x));
        int n2 = 20;
        for (n = 0; n < rectangle.width; ++n) {
            double d3;
            double d4 = aClipPlotter.toPlotterXUnit(this.graphToSampleX(rectangle.x + n));
            if ((int)(d4 / (d3 = Math.pow(10.0, Math.round(Math.log10(Math.abs(d = d4 - aClipPlotter.toPlotterXUnit(this.graphToSampleX(rectangle.x + n + n2)))))))) != (int)(d2 / d3) || Math.signum(d4) != Math.signum(d2)) {
                graphics2D.drawLine(rectangle.x + n, rectangle.y, rectangle.x + n, rectangle.y + rectangle.height);
            }
            d2 = d4;
        }
        d2 = aClipPlotter.toPlotterYUnit(this.graphToSampleY(rectangle.y));
        for (n = 0; n < rectangle.height; ++n) {
            float f;
            float f2 = aClipPlotter.toPlotterYUnit(this.graphToSampleY(rectangle.y + n));
            if ((int)((double)f2 / (d = Math.pow(10.0, Math.round(Math.log10(Math.abs(f = f2 - aClipPlotter.toPlotterYUnit(this.graphToSampleY(rectangle.y + n + n2)))))))) != (int)(d2 / d) || (double)Math.signum(f2) != Math.signum(d2)) {
                graphics2D.drawLine(rectangle.x, rectangle.y + n, rectangle.x + rectangle.width, rectangle.y + n);
            }
            d2 = f2;
        }
    }
}

