/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.save;

import ch.laoe.audio.save.ASave;
import javax.sound.sampled.AudioFormat;

public class ASavePcmUnsigned16BitLittleEndian
extends ASave {
    private int samplePtr = 0;
    private int channelPtr = 0;
    private int bytePtr = 0;
    private float sample;

    @Override
    public ASave duplicate() {
        return new ASavePcmUnsigned16BitLittleEndian();
    }

    @Override
    public boolean supports(AudioFormat audioFormat) {
        return audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && audioFormat.getSampleSizeInBits() == 16 && !audioFormat.isBigEndian();
    }

    @Override
    public int read() {
        int n = 0;
        switch (this.bytePtr) {
            case 0: {
                this.sample = this.getSample(this.channelPtr, this.samplePtr);
                n = (int)this.sample & 0xFF;
                break;
            }
            case 1: {
                n = (int)this.sample >> 8 & 0xFF;
            }
        }
        ++this.bytePtr;
        this.bytePtr %= 2;
        if (this.bytePtr == 0) {
            ++this.channelPtr;
            this.channelPtr %= this.channels;
            if (this.channelPtr == 0) {
                ++this.samplePtr;
            }
        }
        if (this.samplePtr >= this.clip.getMaxSampleLength()) {
            return -1;
        }
        return n;
    }
}

