/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jogg;

public class Page {
    private static int[] crc_lookup = new int[256];
    public byte[] header_base;
    public int header;
    public int header_len;
    public byte[] body_base;
    public int body;
    public int body_len;

    private static int crc_entry(int n) {
        int n2 = n << 24;
        int n3 = 0;
        while (n3 < 8) {
            n2 = (n2 & Integer.MIN_VALUE) != 0 ? n2 << 1 ^ 0x4C11DB7 : (n2 <<= 1);
            ++n3;
        }
        return n2 & 0xFFFFFFFF;
    }

    int version() {
        return this.header_base[this.header + 4] & 0xFF;
    }

    int continued() {
        return this.header_base[this.header + 5] & 1;
    }

    public int bos() {
        return this.header_base[this.header + 5] & 2;
    }

    public int eos() {
        return this.header_base[this.header + 5] & 4;
    }

    public long granulepos() {
        long l = this.header_base[this.header + 13] & 0xFF;
        l = l << 8 | (long)(this.header_base[this.header + 12] & 0xFF);
        l = l << 8 | (long)(this.header_base[this.header + 11] & 0xFF);
        l = l << 8 | (long)(this.header_base[this.header + 10] & 0xFF);
        l = l << 8 | (long)(this.header_base[this.header + 9] & 0xFF);
        l = l << 8 | (long)(this.header_base[this.header + 8] & 0xFF);
        l = l << 8 | (long)(this.header_base[this.header + 7] & 0xFF);
        l = l << 8 | (long)(this.header_base[this.header + 6] & 0xFF);
        return l;
    }

    public int serialno() {
        return this.header_base[this.header + 14] & 0xFF | (this.header_base[this.header + 15] & 0xFF) << 8 | (this.header_base[this.header + 16] & 0xFF) << 16 | (this.header_base[this.header + 17] & 0xFF) << 24;
    }

    int pageno() {
        return this.header_base[this.header + 18] & 0xFF | (this.header_base[this.header + 19] & 0xFF) << 8 | (this.header_base[this.header + 20] & 0xFF) << 16 | (this.header_base[this.header + 21] & 0xFF) << 24;
    }

    void checksum() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.header_len) {
            n = n << 8 ^ crc_lookup[n >>> 24 & 0xFF ^ this.header_base[this.header + n2] & 0xFF];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.body_len) {
            n = n << 8 ^ crc_lookup[n >>> 24 & 0xFF ^ this.body_base[this.body + n3] & 0xFF];
            ++n3;
        }
        this.header_base[this.header + 22] = (byte)n;
        this.header_base[this.header + 23] = (byte)(n >>> 8);
        this.header_base[this.header + 24] = (byte)(n >>> 16);
        this.header_base[this.header + 25] = (byte)(n >>> 24);
    }

    static {
        int n = 0;
        while (n < crc_lookup.length) {
            Page.crc_lookup[n] = Page.crc_entry(n);
            ++n;
        }
    }
}

