/* *******************************************************
 * 
 * name:          Reverse.java
 * 
 * description:   StereoModule which reverses the selected
 *                area of the wavefile.
 *
 * Author:        Florian Bomers
 *
 * (c) by         JaWavedit-Team
 *                JaWavedit@bome.com
 *
 ********************************************************* */


public class Reverse implements StereoModule {
    
	private void reverse(int start, int end, short data[]){
		short temp;
		// exchange last with first sample, 
		// then before-last with second, etc.
		while (start<end) {
			temp=data[start];
			data[start++]=data[end];
			data[end--]=temp;
		}
	}

	public void apply(WaveFile wf,Selection sel) {
		int start=sel.start;
		int end=sel.end;
		if (sel.onePoint()) {
			start=0;
			end=wf.getSize()-1;
		}
		if (sel.side==Selection.BOTH || sel.side==Selection.LEFT)
			reverse(start, end, wf.getLeftWave());
		if (sel.side==Selection.BOTH || sel.side==Selection.RIGHT)
			reverse(start, end, wf.getRightWave());
	}
}


