/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuItem;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Vector;
import sun.tools.javac.Main;

public class ModulePack {
    public static final int SIMPLE_MODULE = 1;
    public static final int STEREO_MODULE = 2;
    protected static final String moduleDir = "JWModules";
    protected static String[] paths = null;
    protected static Vector modules = null;
    protected static Vector sources = null;
    protected static Vector loaders = null;
    private static final String RELOAD_MODULES_COMMAND = "Reload Modules";
    private static final String COMPILE_ALL_COMMAND = "Compile All";
    private static final String COMPILE_COMMAND = "Compile a Module";

    /*
     * WARNING - void declaration
     */
    public static void init() {
        void var1_1;
        Menu menu;
        ModuleFrame moduleFrame;
        boolean bl = ModulePack.supportsCompiling();
        Menu menu2 = moduleFrame.getModuleMenu();
        menu2.removeAll();
        Menu menu3 = moduleFrame.getModuleOptionsMenu();
        menu3.removeAll();
        MenuItem menuItem = new MenuItem(Lang.getStr(1019));
        if (bl) {
            menuItem.setActionCommand(RELOAD_MODULES_COMMAND);
            menuItem.addActionListener(moduleFrame);
        } else {
            menuItem.setEnabled(false);
        }
        menu3.add(menuItem);
        if (bl) {
            menuItem = new MenuItem(Lang.getStr(1059));
            menuItem.setActionCommand(COMPILE_ALL_COMMAND);
            menuItem.addActionListener(moduleFrame);
            menu3.add(menuItem);
            menu = new Menu(Lang.getStr(1060));
            menu.setActionCommand(COMPILE_COMMAND);
            menu3.add(menu);
        } else {
            menu = new Menu(Lang.getStr(1060));
            menu3.add(menu);
            menuItem = new MenuItem(Lang.getStr(1061));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            menu = null;
        }
        if (var1_1 != null && loaders != null) {
            ModulePack.stealMenu(moduleFrame, (ModuleFrame)var1_1);
            return;
        }
        loaders = new Vector();
        modules = new Vector();
        sources = menu != null ? new Vector() : null;
        ModulePack.makeModulePaths();
        if (Globals.inApplet) {
            try {
                ModuleItem moduleItem = new ModuleItem("CreateTonesApplet.class", new CreateTonesApplet((Frame)((Object)moduleFrame)), 2);
                menu2.add(ModulePack.makeModuleMenuItem(moduleFrame, "CreateTonesApplet", moduleItem));
                modules.addElement(moduleItem);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if (paths.length > 0) {
            int n = 0;
            while (n < paths.length) {
                ModulePack.loadModules(moduleFrame, menu2, menu, paths[n]);
                ++n;
            }
            return;
        }
        ModulePack.makeEmptyMenu(menu2);
    }

    public static boolean supportsCompiling() {
        if (Globals.inApplet) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("sun.tools.javac.Main");
            if (clazz != null) {
                return true;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    private static ModuleItem checkClass(Class clazz) throws Throwable {
        int n = 0;
        if (clazz.isInterface()) {
            throw new Exception(Lang.getStr(1025));
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n2 = 0;
        while (n2 < classArray.length) {
            if (classArray[n2].getName().equals("SimpleModule")) {
                n = 1;
            } else if (classArray[n2].getName().equals("StereoModule")) {
                n = 2;
            }
            ++n2;
        }
        if (n == 0) {
            throw new Exception(Lang.getStr(1026));
        }
        return new ModuleItem(clazz, n);
    }

    private static synchronized void loadModules(ModuleFrame moduleFrame, Menu menu, Menu menu2, String string) {
        Label label = moduleFrame.getStatusLabel();
        ModuleLoader moduleLoader = new ModuleLoader(string);
        loaders.addElement(moduleLoader);
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                Object object;
                file = new File(string, stringArray[n]);
                if (file.isDirectory()) {
                    Menu menu3 = new Menu(stringArray[n]);
                    menu.add(menu3);
                    if (menu2 != null) {
                        object = new Menu(stringArray[n]);
                        ((MenuItem)object).setActionCommand(COMPILE_COMMAND);
                        menu2.add((MenuItem)object);
                        ModulePack.loadModules(moduleFrame, menu3, (Menu)object, String.valueOf(string) + stringArray[n] + Globals.fs);
                    } else {
                        ModulePack.loadModules(moduleFrame, menu3, null, String.valueOf(string) + stringArray[n] + Globals.fs);
                    }
                }
                label.setText(String.valueOf(Lang.getStr(1024)) + stringArray[n]);
                label.invalidate();
                int n2 = stringArray[n].lastIndexOf(".class");
                if (n2 > 0 && n2 == stringArray[n].length() - 6) {
                    try {
                        object = stringArray[n].substring(0, n2);
                        Class clazz = moduleLoader.loadClass((String)object, true);
                        ModuleItem moduleItem = ModulePack.checkClass(clazz);
                        moduleItem.fullFileName = String.valueOf(string) + stringArray[n];
                        menu.add(ModulePack.makeModuleMenuItem(moduleFrame, (String)object, moduleItem));
                        modules.addElement(moduleItem);
                    }
                    catch (Throwable throwable) {
                        Globals.debugOut(String.valueOf(stringArray[n].substring(0, n2)) + ": " + throwable.getMessage());
                    }
                } else if (menu2 != null && (n2 = stringArray[n].lastIndexOf(".java")) > 0 && n2 == stringArray[n].length() - 5) {
                    object = String.valueOf(string) + stringArray[n];
                    menu2.add(ModulePack.makeSourceMenuItem(moduleFrame, stringArray[n], (String)object));
                    sources.addElement(object);
                }
                ++n;
            }
        }
        if (menu.getItemCount() == 0) {
            ModulePack.makeEmptyMenu(menu);
        }
        if (menu2 != null && menu2.getItemCount() == 0) {
            ModulePack.makeEmptyMenu(menu2);
        }
        label.setText(Lang.getStr(1001));
    }

    private static MenuItem makeModuleMenuItem(ModuleFrame moduleFrame, String string, ModuleItem moduleItem) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setActionCommand(moduleItem.fullFileName);
        menuItem.addActionListener(moduleFrame);
        return menuItem;
    }

    private static MenuItem makeSourceMenuItem(ModuleFrame moduleFrame, String string, String string2) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setActionCommand(string2);
        menuItem.addActionListener(moduleFrame);
        return menuItem;
    }

    private static void makeEmptyMenu(Menu menu) {
        MenuItem menuItem = new MenuItem(Lang.getStr(1000));
        menuItem.setEnabled(false);
        menu.add(menuItem);
    }

    private static Menu getCompileMenu(Menu menu) {
        int n = menu.getItemCount();
        Menu menu2 = null;
        int n2 = 0;
        while (n2 < n && menu2 == null) {
            MenuItem menuItem = menu.getItem(n2);
            if (menuItem instanceof Menu && COMPILE_COMMAND.equals(menuItem.getActionCommand())) {
                menu2 = (Menu)menuItem;
            }
            ++n2;
        }
        return menu2;
    }

    private static void stealMenu(ModuleFrame moduleFrame, ModuleFrame moduleFrame2) {
        Label label = moduleFrame.getStatusLabel();
        label.setText(Lang.getStr(1027));
        label.invalidate();
        ModulePack.getMenu(moduleFrame.getModuleMenu(), moduleFrame2.getModuleMenu(), moduleFrame);
        Menu menu = ModulePack.getCompileMenu(moduleFrame.getModuleOptionsMenu());
        Menu menu2 = ModulePack.getCompileMenu(moduleFrame2.getModuleOptionsMenu());
        if (menu != null && menu2 != null) {
            ModulePack.getMenu(menu, menu2, moduleFrame);
        }
        label.setText(Lang.getStr(1001));
    }

    private static void getMenu(Menu menu, Menu menu2, ModuleFrame moduleFrame) {
        int n = menu2.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menu2.getItem(n2);
            MenuItem menuItem2 = null;
            if (menuItem instanceof Menu) {
                menuItem2 = new Menu(menuItem.getLabel());
                menuItem2.setActionCommand(menuItem.getActionCommand());
                ModulePack.getMenu((Menu)menuItem2, (Menu)menuItem, moduleFrame);
            } else {
                menuItem2 = new MenuItem(menuItem.getLabel());
                if (menuItem.isEnabled()) {
                    menuItem2.addActionListener(moduleFrame);
                    menuItem2.setActionCommand(menuItem.getActionCommand());
                } else {
                    menuItem2.setEnabled(false);
                }
            }
            menu.add(menuItem2);
            ++n2;
        }
    }

    public static boolean handleMenu(ModuleFrame moduleFrame, MenuItem menuItem) {
        String string = menuItem.getActionCommand();
        if (string != null) {
            if (string.equals(RELOAD_MODULES_COMMAND)) {
                ModulePack.reloadModules(moduleFrame.getInstances());
                return true;
            }
            if (string.equals(COMPILE_ALL_COMMAND)) {
                ModulePack.compileAll(moduleFrame);
                return true;
            }
            if (ModulePack.isCompileModule(menuItem)) {
                ModulePack.compile(moduleFrame, menuItem);
                return true;
            }
        }
        return false;
    }

    public static void reloadModules(Vector vector) {
        if (vector.size() > 0) {
            ModulePack.init((ModuleFrame)vector.elementAt(0), null);
        }
        int n = 1;
        while (n < vector.size()) {
            ModulePack.init((ModuleFrame)vector.elementAt(n), (ModuleFrame)vector.elementAt(n - 1));
            ++n;
        }
    }

    public static boolean isExecuteModule(MenuItem menuItem) {
        if (menuItem.getActionCommand() != null) {
            return menuItem.getActionCommand().lastIndexOf(".class") > 0;
        }
        return false;
    }

    private static void instantiateModule(ModuleItem moduleItem, Frame frame) throws Throwable {
        if (moduleItem.exec != null) {
            return;
        }
        if (moduleItem.type == 2) {
            Class[] classArray = new Class[]{Class.forName("java.awt.Frame")};
            try {
                Constructor constructor = moduleItem.moduleClass.getConstructor(classArray);
                Object[] objectArray = new Object[]{frame};
                moduleItem.exec = constructor.newInstance(objectArray);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                moduleItem.exec = moduleItem.moduleClass.newInstance();
                return;
            }
        }
        moduleItem.exec = moduleItem.moduleClass.newInstance();
    }

    public static void execute(MenuItem menuItem, ModuleFrame moduleFrame, ModuleContext moduleContext) throws Throwable {
        String string = menuItem.getActionCommand();
        if (string == null) {
            throw new Exception("MenuItem " + menuItem.getLabel() + " is not of a module.");
        }
        ModuleItem moduleItem = null;
        boolean bl = false;
        int n = 0;
        while (n < modules.size() && !bl) {
            moduleItem = (ModuleItem)modules.elementAt(n);
            if (string.equals(moduleItem.fullFileName)) {
                bl = true;
            }
            ++n;
        }
        if (!bl || moduleItem == null) {
            throw new Exception("MenuItem " + menuItem.getLabel() + " is not of a module.");
        }
        ModulePack.instantiateModule(moduleItem, moduleContext.getParentFrame());
        Label label = moduleFrame.getStatusLabel();
        label.setText(StringTool.sprintf(Lang.getStr(1029), menuItem.getLabel()));
        label.invalidate();
        if (moduleItem.type == 1) {
            short[] sArray = null;
            WaveFile waveFile = moduleContext.getWaveFile();
            Selection selection = moduleContext.getSelection();
            int n2 = 1;
            while (n2 < 3) {
                if (n2 == 1) {
                    waveFile.Wave = waveFile.getLeftWave();
                } else {
                    sArray = waveFile.Wave;
                    waveFile.Wave = waveFile.getRightWave();
                }
                if (selection.side == 0 || selection.side == n2) {
                    if (selection.onePoint()) {
                        ((SimpleModule)moduleItem.exec).apply(waveFile, 0, waveFile.Wave.length - 1);
                    } else {
                        ((SimpleModule)moduleItem.exec).apply(waveFile, selection.start, selection.end);
                    }
                }
                ++n2;
            }
            waveFile.setWaves(sArray, waveFile.Wave);
        } else if (moduleItem.type == 2) {
            ((StereoModule)moduleItem.exec).apply(moduleContext.getWaveFile(), moduleContext.getSelection());
            moduleContext.getParentFrame().show();
        }
        label.setText(StringTool.sprintf(Lang.getStr(1031), menuItem.getLabel()));
    }

    public static boolean isCompileModule(MenuItem menuItem) {
        if (menuItem.getActionCommand() != null) {
            return menuItem.getActionCommand().endsWith(".java");
        }
        return false;
    }

    private static String getJWModulePath(String string) {
        int n = string.indexOf(moduleDir);
        if (n >= 0) {
            return string.substring(n + Globals.fs.length() + moduleDir.length());
        }
        return Loader.extractFileName(string);
    }

    private static String[] makeCompileArguments(String string, Label label) {
        String[] stringArray = new String[]{"-classpath", String.valueOf(Loader.killLastSlash(Loader.extractFilePath(string))) + Globals.ps + Globals.classpath, string};
        Globals.debugOut("javac " + ModulePack.getJWModulePath(string));
        label.setText(StringTool.sprintf(Lang.getStr(1066), Loader.extractFileName(string)));
        label.invalidate();
        return stringArray;
    }

    public static void compile(ModuleFrame moduleFrame, MenuItem menuItem) {
        Label label = moduleFrame.getStatusLabel();
        try {
            Main main = new Main((OutputStream)System.out, Globals.name);
            if (main.compile(ModulePack.makeCompileArguments(menuItem.getActionCommand(), label))) {
                ModulePack.reloadModules(moduleFrame.getInstances());
                label.setText(StringTool.sprintf(Lang.getStr(1062), menuItem.getLabel()));
                return;
            }
            label.setText(StringTool.sprintf(Lang.getStr(1063), menuItem.getLabel()));
            return;
        }
        catch (Throwable throwable) {
            Globals.debugOut(throwable);
            label.setText(throwable.getMessage());
            return;
        }
    }

    public static void compileAll(ModuleFrame moduleFrame) {
        Label label = moduleFrame.getStatusLabel();
        try {
            int n = 0;
            Main main = new Main((OutputStream)System.out, Globals.name);
            int n2 = 0;
            while (n2 < sources.size()) {
                n += main.compile(ModulePack.makeCompileArguments((String)sources.elementAt(n2), label)) ? 0 : 1;
                ++n2;
            }
            if (n < sources.size()) {
                ModulePack.reloadModules(moduleFrame.getInstances());
            }
            if (n == 0) {
                label.setText(Lang.getStr(1064));
                return;
            }
            label.setText(Lang.getStr(1065));
            return;
        }
        catch (Throwable throwable) {
            Globals.debugOut(throwable);
            label.setText(throwable.getMessage());
            return;
        }
    }

    private static void addModulePath(Vector vector, Vector vector2, String string) {
        try {
            string = String.valueOf(Loader.addSlash(string)) + moduleDir;
            File file = new File(string);
            string = Loader.killPointSlash(file.getAbsolutePath());
            file = new File(string);
            if (file.exists() && file.isDirectory()) {
                long l = file.lastModified();
                boolean bl = false;
                int n = 0;
                while (n < vector2.size() && !bl) {
                    if ((Long)vector2.elementAt(n) == l) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    vector.addElement(String.valueOf(string) + Globals.fs);
                    vector2.addElement(new Long(l));
                }
                if (!bl) {
                    Globals.debugOut("loading Modules from " + string);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Globals.debugOut(throwable);
        }
    }

    private static void makeModulePaths() {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            ModulePack.addModulePath(vector, vector2, System.getProperty("module.path", "."));
        }
        catch (Exception exception) {}
        ModulePack.addModulePath(vector, vector2, Globals.userHome);
        ModulePack.addModulePath(vector, vector2, Globals.userDir);
        paths = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            ModulePack.paths[n] = (String)vector.elementAt(n);
            ++n;
        }
    }
}

