/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class CreateTonesApplet
extends Dialog
implements StereoModule,
ActionListener,
AdjustmentListener,
ItemListener {
    public static int MAXIMUM_FREQ = 4000;
    WaveFile wf;
    Selection sel;
    double initialFreq;
    double finalFreq;
    int createFreq;
    int createLength;
    private static final int SBMin = 1;
    private static final int SBRange = 500;
    private static final int SBVisible = 70;
    private Label LInitialFreq;
    private Label LFinalFreq;
    private Label LCreateLength;
    private Label LCLength;
    private Label LCreateFreq;
    private Label LCFreq;
    private Scrollbar SBInitialFreq;
    private Scrollbar SBFinalFreq;
    private Scrollbar SBCreateLength;
    private Scrollbar SBCreateFreq;
    private Checkbox CBSine;
    private Checkbox CBSquare;
    private Checkbox CBSaw;
    private Checkbox CBTriangle;
    private Checkbox CBCreate;
    private Button BOK;
    private Button BCancel;
    private static int[] Freqs = new int[]{8000, 11025, 22050, 44100, 48000};

    private void makeSine(short[] sArray, int n, double d, double d2, int n2, int n3) {
        double d3 = d;
        double d4 = (d2 - d) / (double)(n3 - n2 + 1);
        double d5 = Math.PI * 2 / (double)n;
        double d6 = 0.0;
        int n4 = n2;
        while (n4 < n3) {
            sArray[n4] = (short)(Math.sin(d6) * 32000.0);
            d3 = d + (double)n4 * d4;
            ++n4;
            d6 += d3 * d5;
        }
    }

    private void makeSquare(short[] sArray, int n, double d, double d2, int n2, int n3) {
        double d3 = d;
        double d4 = (d2 - d) / (double)(n3 - n2 + 1);
        int n4 = 0;
        int n5 = 1;
        int n6 = n2;
        while (n6 < n3) {
            sArray[n6] = (short)(n5 * 30000);
            d3 = d + (double)n6 * d4;
            if ((double)n4 > (double)n / d3) {
                n5 = (short)(-n5);
                n4 = 0;
            }
            ++n6;
            ++n4;
        }
    }

    private void makeSaw(short[] sArray, int n, double d, double d2, int n2, int n3) {
        double d3 = d;
        double d4 = (d2 - d) / (double)(n3 - n2 + 1);
        double d5 = -1.0;
        int n4 = n2;
        while (n4 < n3) {
            if (d5 > 1.0) {
                d5 = -1.0;
            }
            sArray[n4] = (short)(d5 * 30000.0);
            d3 = d + (double)n4 * d4;
            ++n4;
            d5 += d3 / (double)n;
        }
    }

    private void makeTriangle(short[] sArray, int n, double d, double d2, int n2, int n3) {
        double d3 = d;
        double d4 = (d2 - d) / (double)(n3 - n2 + 1);
        double d5 = -1.0;
        double d6 = 2.0;
        int n4 = n2;
        while (n4 < n3) {
            if (Math.abs(d5) > 1.0) {
                d5 = d6 / 2.0;
                d6 = -d6;
            }
            sArray[n4] = (short)(d5 * 30000.0);
            d3 = d + (double)n4 * d4;
            ++n4;
            d5 += d6 * d3 / (double)n;
        }
    }

    public void apply(WaveFile waveFile, Selection selection) {
        this.wf = waveFile;
        this.sel = selection;
        this.updateScrollbars();
        this.updateSBLabels();
        this.updateEnabled();
        ((Component)this).setVisible(true);
    }

    public CreateTonesApplet(Frame frame) {
        super(frame, true);
        try {
            this.setTitle("Create nice sounds...");
            this.initialFreq = 555.0;
            this.finalFreq = 1111.0;
            this.createFreq = 22050;
            this.createLength = 5;
            this.setLayout(new StripeLayout());
            this.add(new Label("Initial Frequency"));
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            this.SBInitialFreq = new Scrollbar(0, 1, 70, 1, 570);
            panel.add("Center", this.SBInitialFreq);
            this.LInitialFreq = new Label("48000 Hertz......");
            panel.add("East", this.LInitialFreq);
            this.add(panel);
            this.add(new Label("Final Frequency"));
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            this.SBFinalFreq = new Scrollbar(0, 1, 70, 1, 570);
            panel.add("Center", this.SBFinalFreq);
            this.LFinalFreq = new Label("48000 Hertz......");
            panel.add("East", this.LFinalFreq);
            this.add(panel);
            this.add(new HoriLine());
            CheckboxGroup checkboxGroup = new CheckboxGroup();
            panel = new Panel();
            panel.setLayout(new GridLayout(1, 2));
            this.CBSine = new Checkbox("Sine", checkboxGroup, true);
            panel.add(this.CBSine);
            this.CBSquare = new Checkbox("Square", checkboxGroup, false);
            panel.add(this.CBSquare);
            this.add(panel);
            panel = new Panel();
            panel.setLayout(new GridLayout(1, 2));
            this.CBSaw = new Checkbox("Saw", checkboxGroup, false);
            panel.add(this.CBSaw);
            this.CBTriangle = new Checkbox("Triangle", checkboxGroup, false);
            panel.add(this.CBTriangle);
            this.add(panel);
            this.add(new HoriLine());
            this.CBCreate = new Checkbox("Create new Wave", false);
            this.add(this.CBCreate);
            this.LCLength = new Label("Length of the new Wave");
            this.add(this.LCLength);
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            this.SBCreateLength = new Scrollbar(0, 5, 30, 1, 130);
            panel.add("Center", this.SBCreateLength);
            this.LCreateLength = new Label("5000 seconds....");
            panel.add("East", this.LCreateLength);
            this.add(panel);
            this.LCFreq = new Label("Playback rate of the new Wave");
            this.add(this.LCFreq);
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            this.SBCreateFreq = new Scrollbar(0, Freqs.length - 2, 1, 0, Freqs.length);
            panel.add("Center", this.SBCreateFreq);
            this.LCreateFreq = new Label("44100 Hz....");
            panel.add("East", this.LCreateFreq);
            this.add(panel);
            this.add(new HoriLine());
            panel = new Panel();
            panel.setLayout(new GridLayout(1, 4));
            panel.add(new Panel());
            this.BOK = new Button("OK");
            panel.add(this.BOK);
            this.BCancel = new Button("Cancel");
            panel.add(this.BCancel);
            this.add(panel);
            panel.add(new Panel());
            this.CBCreate.addItemListener(this);
            this.BOK.addActionListener(this);
            this.BCancel.addActionListener(this);
            this.SBInitialFreq.addAdjustmentListener(this);
            this.SBFinalFreq.addAdjustmentListener(this);
            this.SBCreateLength.addAdjustmentListener(this);
            this.SBCreateFreq.addAdjustmentListener(this);
            this.pack();
            return;
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
            throwable.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void updateSBLabels() {
        this.updateLFreq(true);
        this.updateLFreq(false);
        this.updateLCreateFreq();
        this.updateLCreateLength();
    }

    private void updateScrollbars() {
        this.updateSBFreq(true);
        this.updateSBFreq(false);
        this.updateSBCreateFreq();
        this.updateSBCreateLength();
    }

    private void updateLCreateFreq() {
        this.LCreateFreq.setText(String.valueOf(String.valueOf(this.createFreq)) + " Hz");
    }

    private void updateSBCreateFreq() {
        int n = 0;
        while (n < Freqs.length) {
            if (Freqs[n] == this.createFreq) {
                this.SBCreateFreq.setValue(n);
                return;
            }
            ++n;
        }
    }

    private void setCreateFreq(int n) {
        this.createFreq = Freqs[Math.max(0, Math.min(n, Freqs.length - 1))];
    }

    private void updateLCreateLength() {
        this.LCreateLength.setText(String.valueOf(String.valueOf(this.createLength)) + " sec");
    }

    private void updateSBCreateLength() {
        this.SBCreateLength.setValue(this.createLength);
    }

    private void setCreateLength(int n) {
        this.createLength = Math.max(0, Math.min(n, 100));
    }

    private void updateLFreq(boolean bl) {
        if (bl) {
            this.LInitialFreq.setText(String.valueOf(String.valueOf(this.initialFreq)) + " Hz");
            return;
        }
        this.LFinalFreq.setText(String.valueOf(String.valueOf(this.finalFreq)) + " Hz");
    }

    private void updateSBFreq(boolean bl) {
        double d = bl ? this.initialFreq : this.finalFreq;
        int n = (int)(d * 500.0 / (double)MAXIMUM_FREQ);
        if (bl) {
            this.SBInitialFreq.setValue(n);
            return;
        }
        this.SBFinalFreq.setValue(n);
    }

    private void setFreq(int n, boolean bl) {
        double d = Math.min(n * (MAXIMUM_FREQ / 500), MAXIMUM_FREQ);
        if (bl) {
            this.initialFreq = d;
            return;
        }
        this.finalFreq = d;
    }

    private void addFreq(int n, boolean bl) {
        double d = (int)(bl ? this.initialFreq : this.finalFreq);
        d = Math.max(Math.min(d + (double)n, (double)MAXIMUM_FREQ), 1.0);
        if (bl) {
            this.initialFreq = d;
            return;
        }
        this.finalFreq = d;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.SBInitialFreq || adjustmentEvent.getAdjustable() == this.SBFinalFreq) {
            if (adjustmentEvent.getAdjustmentType() == 2) {
                this.addFreq(-1, adjustmentEvent.getAdjustable() == this.SBInitialFreq);
                this.updateSBFreq(adjustmentEvent.getAdjustable() == this.SBInitialFreq);
            } else if (adjustmentEvent.getAdjustmentType() == 1) {
                this.addFreq(1, adjustmentEvent.getAdjustable() == this.SBInitialFreq);
                this.updateSBFreq(adjustmentEvent.getAdjustable() == this.SBInitialFreq);
            } else {
                this.setFreq(adjustmentEvent.getValue(), adjustmentEvent.getAdjustable() == this.SBInitialFreq);
            }
            this.updateLFreq(adjustmentEvent.getAdjustable() == this.SBInitialFreq);
            return;
        }
        if (adjustmentEvent.getAdjustable() == this.SBCreateLength) {
            this.setCreateLength(adjustmentEvent.getValue());
            this.updateLCreateLength();
            return;
        }
        if (adjustmentEvent.getAdjustable() == this.SBCreateFreq) {
            this.setCreateFreq(adjustmentEvent.getValue());
            this.updateLCreateFreq();
        }
    }

    private void updateEnabled() {
        if (this.wf.getSize() == 0) {
            this.CBCreate.setState(true);
            this.CBCreate.setEnabled(false);
        } else {
            this.CBCreate.setEnabled(true);
        }
        boolean bl = this.CBCreate.getState();
        this.SBCreateLength.setEnabled(bl);
        this.SBCreateFreq.setEnabled(bl);
        this.LCFreq.setEnabled(bl);
        this.LCLength.setEnabled(bl);
        this.LCreateFreq.setEnabled(bl);
        this.LCreateLength.setEnabled(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateEnabled();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.BOK) {
            short[] sArray = this.wf.getLeftWave();
            short[] sArray2 = this.wf.getRightWave();
            int n = this.sel.start;
            int n2 = this.sel.end;
            int n3 = this.wf.getFrequency();
            if (this.sel.onePoint()) {
                n = 0;
                n2 = sArray.length - 1;
            }
            if (this.CBCreate.getState()) {
                n = 0;
                n2 = this.createLength * this.createFreq;
                sArray = new short[n2 + 1];
                sArray2 = new short[n2 + 1];
                n3 = this.createFreq;
            }
            if (this.CBSine.getState()) {
                this.makeSine(sArray, n3, this.initialFreq, this.finalFreq, n, n2);
            } else if (this.CBSquare.getState()) {
                this.makeSquare(sArray, n3, this.initialFreq, this.finalFreq, n, n2);
            } else if (this.CBSaw.getState()) {
                this.makeSaw(sArray, n3, this.initialFreq, this.finalFreq, n, n2);
            }
            if (this.CBTriangle.getState()) {
                this.makeTriangle(sArray, n3, this.initialFreq, this.finalFreq, n, n2);
            }
            System.arraycopy(sArray, n, sArray2, n, n2 - n + 1);
            this.wf.setWaves(sArray, sArray2);
            if (this.CBCreate.getState()) {
                this.wf.setName("Sine.wav");
                this.wf.setChannelCount((short)1);
                this.wf.setFrequency(n3);
                this.wf.setResolution((short)16);
            }
        }
        ((Component)this).setVisible(false);
    }
}

