/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.converter;

import com.wet.wired.jsr.converter.PlayerDataSource;
import java.io.File;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class RecordingConverter
implements ControllerListener,
DataSinkListener {
    private static boolean finished = false;
    private Object waitSync = new Object();
    private boolean stateTransitionOK = true;

    public static void main(String[] args) {
        if (args.length != 1 || !args[0].endsWith("cap")) {
            System.out.println("Usage: java -jar screen_cap_to_video.jar <screen_cap_file.cap>");
            return;
        }
        String movieFile = new String(args[0]);
        movieFile = movieFile.replace("cap", "mov");
        try {
            RecordingConverter recordingConverter = new RecordingConverter();
            recordingConverter.process(args[0], movieFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void process(String recordingFile, String movieFile) throws Exception {
        MediaLocator mediaLocator = new MediaLocator(new File(movieFile).toURI().toURL());
        PlayerDataSource playerDataSource = new PlayerDataSource(recordingFile);
        Processor processor = Manager.createProcessor((DataSource)playerDataSource);
        processor.addControllerListener((ControllerListener)this);
        processor.configure();
        if (!this.waitForState(processor, 180)) {
            System.err.println("Failed to configure the processor.");
            return;
        }
        processor.setContentDescriptor(new ContentDescriptor("video.quicktime"));
        TrackControl[] trackControl = processor.getTrackControls();
        Format[] format = trackControl[0].getSupportedFormats();
        trackControl[0].setFormat(format[0]);
        processor.realize();
        if (!this.waitForState(processor, 300)) {
            System.err.println("Failed to realize the processor.");
            return;
        }
        DataSource dataSource = processor.getDataOutput();
        DataSink dataSink = Manager.createDataSink((DataSource)dataSource, (MediaLocator)mediaLocator);
        dataSink.open();
        processor.start();
        dataSink.start();
        this.waitForFileDone();
        dataSink.close();
        processor.removeControllerListener((ControllerListener)this);
    }

    void waitForFileDone() {
        while (!finished) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void dataSinkUpdate(DataSinkEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            evt.getSourceController().close();
            finished = true;
        }
    }
}

