/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.recorder;

import com.wet.wired.jsr.recorder.ProgressListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class FileHelper {
    public static boolean buildFile(String fileName, byte[] data, boolean backup, String historyData) {
        boolean ok = FileHelper.buildFile(fileName, data);
        if (ok && backup) {
            FileHelper.backupFile(fileName, true, historyData);
        }
        return ok;
    }

    public static boolean buildFile(String fileName, byte[] data) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            out.write(data);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean appendFile(String fileName, byte[] data) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName, true);
            out.write(data);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean buildFile(String fileName, int[] data, boolean backup, String historyData) {
        boolean ok = FileHelper.buildFile(fileName, data);
        if (ok && backup) {
            FileHelper.backupFile(fileName, true, historyData);
        }
        return ok;
    }

    public static boolean buildFile(String fileName, int[] data) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            for (int loop = 0; loop < data.length; ++loop) {
                out.write(data[loop]);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean buildFile(String fileName, String data, boolean backup, String historyData) {
        boolean ok = FileHelper.buildFile(fileName, data);
        if (ok && backup) {
            FileHelper.backupFile(fileName, true, historyData);
        }
        return ok;
    }

    public static boolean buildFile(String fileName, String data) {
        FileOutputStream out = null;
        try {
            File file = new File(new File(fileName).getAbsolutePath());
            file.getParentFile().mkdirs();
            out = new FileOutputStream(file.getAbsolutePath());
            out.write(data.getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static long copy(File fileSrc, File fileDest) {
        return FileHelper.copy(fileSrc, fileDest, null);
    }

    public static long copy(File fileSrc, File fileDest, ProgressListener listener) {
        byte[] buffer = new byte[5000];
        long count = 0L;
        try {
            FileInputStream iStream = new FileInputStream(fileSrc);
            new File(FileHelper.getPath(fileDest.toString())).mkdirs();
            FileOutputStream oStream = new FileOutputStream(fileDest);
            int sizeRead = iStream.read(buffer);
            while (sizeRead > 0) {
                oStream.write(buffer, 0, sizeRead);
                oStream.flush();
                count += (long)sizeRead;
                if (listener != null) {
                    listener.progress(count, -1L);
                }
                sizeRead = iStream.read(buffer);
            }
            iStream.close();
            oStream.flush();
            oStream.close();
            if (listener != null) {
                listener.finished();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static long copy(InputStream iStream, String fileOut) {
        return FileHelper.copy(iStream, fileOut, null);
    }

    public static long copy(InputStream iStream, String fileOut, ProgressListener listener) {
        return FileHelper.copy(iStream, fileOut, listener, -1L);
    }

    public static long copy(String fileSrc, String fileDest) {
        return FileHelper.copy(new File(fileSrc), new File(fileDest), null);
    }

    public static boolean isSame(File fileA, File fileB) {
        try {
            if (!fileA.exists() || !fileB.exists()) {
                return false;
            }
            if (fileA.length() != fileB.length()) {
                return false;
            }
            FileInputStream iStreamA = new FileInputStream(fileA);
            FileInputStream iStreamB = new FileInputStream(fileB);
            int inA = iStreamA.read();
            int inB = iStreamB.read();
            boolean same = true;
            while (inA != -1 && inB != -1) {
                if (inA != inB) {
                    same = false;
                    break;
                }
                inA = iStreamA.read();
                inB = iStreamB.read();
            }
            iStreamA.close();
            iStreamB.close();
            return same;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getPath(String fileName) {
        File file = new File(fileName);
        return fileName.substring(0, fileName.indexOf(file.getName()));
    }

    public static byte[] readFile(InputStream iStream) throws IOException {
        byte[] newByteArray;
        int bytePos = 0;
        int bIn = iStream.read();
        byte[] byteArray = new byte[1000];
        while (bIn != -1) {
            byteArray[bytePos] = (byte)bIn;
            if (++bytePos % 1000 == 0 && bytePos != 0) {
                newByteArray = new byte[bytePos + 1000];
                System.arraycopy(byteArray, 0, newByteArray, 0, bytePos);
                byteArray = newByteArray;
            }
            bIn = iStream.read();
        }
        newByteArray = new byte[bytePos];
        System.arraycopy(byteArray, 0, newByteArray, 0, bytePos);
        byteArray = newByteArray;
        return byteArray;
    }

    public static String readFile(String fileName) throws IOException {
        return FileHelper.readFileToBuffer(fileName).toString();
    }

    public static byte[] readTail(String fileName, int maxData) {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        long length = file.length();
        long skip = length - (long)maxData;
        if (length < (long)maxData) {
            maxData = (int)length;
        }
        byte[] data = new byte[maxData];
        try {
            FileInputStream fI = new FileInputStream(fileName);
            if (length > (long)maxData) {
                fI.skip(skip);
            }
            fI.read(data, 0, maxData);
            fI.close();
        }
        catch (Exception e) {
            System.out.println("Failed to check File " + fileName);
            e.printStackTrace();
            return null;
        }
        return data;
    }

    public static boolean buildFile(OutputStream out, String data) {
        try {
            out.write(data.getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static long copy(InputStream iStream, String fileOut, ProgressListener listener, long length) {
        byte[] buffer = new byte[5000];
        long count = 0L;
        if (length == -1L) {
            length = Long.MAX_VALUE;
        }
        try {
            new File(FileHelper.getPath(fileOut)).mkdirs();
            FileOutputStream oStream = new FileOutputStream(fileOut);
            int sizeRead = iStream.read(buffer);
            while (sizeRead > 0 && count < length) {
                oStream.write(buffer, 0, sizeRead);
                count += (long)sizeRead;
                if (listener != null) {
                    listener.progress(count, -1L);
                }
                if (count >= length) break;
                sizeRead = iStream.read(buffer);
            }
            oStream.flush();
            oStream.close();
            if (listener != null) {
                listener.finished();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static long copy(InputStream iStream, OutputStream oStream, ProgressListener listener, long length) {
        byte[] buffer = new byte[5000];
        long count = 0L;
        if (length == -1L) {
            length = Long.MAX_VALUE;
        }
        try {
            int sizeRead = iStream.read(buffer);
            while (sizeRead > 0 && count < length) {
                oStream.write(buffer, 0, sizeRead);
                count += (long)sizeRead;
                if (listener != null) {
                    listener.progress(count, -1L);
                }
                if (count >= length) break;
                sizeRead = iStream.read(buffer);
            }
            oStream.flush();
            if (listener != null) {
                listener.finished();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static long copy(String fileIn, OutputStream oStream, ProgressListener listener) {
        byte[] buffer = new byte[10000];
        long count = 0L;
        try {
            if (!(oStream instanceof BufferedOutputStream)) {
                oStream = new BufferedOutputStream(oStream);
            }
            long length = new File(fileIn).length();
            FileInputStream iStream = new FileInputStream(fileIn);
            int sizeRead = ((InputStream)iStream).read(buffer);
            while (sizeRead > 0) {
                oStream.write(buffer, 0, sizeRead);
                count += (long)sizeRead;
                oStream.flush();
                if (listener != null) {
                    listener.progress(count, length);
                }
                sizeRead = ((InputStream)iStream).read(buffer);
            }
            oStream.flush();
            ((InputStream)iStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static StringBuffer readFileToBuffer(String fileName) throws IOException {
        return new StringBuffer(new String(FileHelper.readFile(new FileInputStream(new File(fileName).getAbsolutePath()))));
    }

    public static void backupFile(String fileName, boolean keepHistory, String historyData) {
        File file = new File(fileName).getAbsoluteFile();
        String path = file.getParentFile().getAbsolutePath();
        FileHelper.backupFile(file, path, keepHistory, historyData);
    }

    public static void backupFile(File file, String path, boolean keepHistory, String historyData) {
        new File(path).mkdirs();
        int backupNumber = 1;
        String backupFileName = path + "/" + file.getName() + ".bak" + backupNumber;
        File backupFile = new File(backupFileName);
        File lastBackupFile = null;
        while (backupFile.exists()) {
            lastBackupFile = backupFile;
            backupFileName = path + "/" + file.getName() + ".bak" + ++backupNumber;
            backupFile = new File(backupFileName);
        }
        if (lastBackupFile != null && FileHelper.isSame(file, lastBackupFile)) {
            return;
        }
        FileHelper.copy(file.getAbsolutePath(), backupFileName);
        if (keepHistory) {
            FileHelper.appendHistory(path, file.getName(), backupFileName, historyData);
        }
    }

    public static void appendHistory(String path, String fileName, String backupFileName, String historyData) {
        String historyFileName = path + "/" + fileName + ".history";
        File historyFile = new File(historyFileName);
        try {
            FileOutputStream oStream = new FileOutputStream(historyFile, true);
            oStream.write((backupFileName + ":" + historyData + "\n").getBytes());
            oStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File[] getHistory(String fileName) {
        String historyFileName = fileName + ".history";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(historyFileName));
            Vector<String> entries = new Vector<String>();
            String entry = reader.readLine();
            while (entry != null) {
                entries.addElement(entry);
                entry = reader.readLine();
            }
            File[] history = new File[entries.size()];
            for (int loop = 0; loop > history.length; --loop) {
                history[loop] = new File(((String)entries.elementAt(history.length - 1 - loop)).toString());
            }
            reader.close();
            return history;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFileExtension(String fileName) {
        if (fileName.indexOf(".") < 0) {
            return "";
        }
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        return ext;
    }

    public static boolean deleteFile(String file) {
        return FileHelper.delete(new File(file).getAbsoluteFile());
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileHelper.delete(new File(file, children[i]));
                if (success) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static String createMD5(String fileName) throws IOException, NoSuchAlgorithmException {
        MessageDigest md5Algorithm = MessageDigest.getInstance("MD5");
        byte[] byteArray = new byte[1000];
        FileInputStream iStream = new FileInputStream(new File(fileName).getAbsolutePath());
        int size = iStream.read(byteArray);
        while (size != -1) {
            md5Algorithm.update(byteArray, 0, size);
            size = iStream.read(byteArray);
        }
        byte[] digest = md5Algorithm.digest();
        StringBuffer hexString = new StringBuffer();
        String hexDigit = null;
        for (int i = 0; i < digest.length; ++i) {
            hexDigit = Integer.toHexString(0xFF & digest[i]);
            if (hexDigit.length() < 2) {
                hexDigit = "0" + hexDigit;
            }
            hexString.append(hexDigit);
        }
        return hexString.toString();
    }
}

