/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.tree.*;
import java.io.*;
import java.util.*;

/**
 * This type was created in VisualAge.
 */
public class HDataTableModel extends AbstractTableModel
{
    protected Vector nodes = new Vector(10,0);

    String columnNames[] = {"Icon","Filename","Path","Size","Date Modified"};

    int type = 0;
    public final static int NO_PATH = 0, PATH = 1;

    TreePath pathToTable = null;
    JTree assocTree;
    HDatabase database;

/**
 * HDataTableModel constructor comment.
 */
public HDataTableModel(int type, JTree assocTree, HDatabase database)
{
    super();

    this.type = type;
    this.assocTree = assocTree;
    this.database = database;
}

/**
 * This method was created in VisualAge.
 */
public void fireTableDataChanged()
{
   super.fireTableDataChanged();
}


/**
 * This method was created in VisualAge.
 * @return java.lang.Class
 * @param c int
 */
public Class getColumnClass(int c)
{
    if(type == NO_PATH)
       if(c >= 2) c++;

    switch(c)
    {
       case 0: return ImageIcon.class;
       case 1: return String.class;
       case 2: return String.class;
       case 3: return Number.class;
       case 4: return Date.class;
       default: return Object.class;
    }
}
/**
 * getColumnCount method comment.
 */
public int getColumnCount()
{
   if(type == NO_PATH)
      return 4;
   else
      return 5;
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 * @param col int
 */
public String getColumnName(int col)
{
   if(type == NO_PATH)
      if(col >= 2) col++;

   return columnNames[col].toString();
}
/**
 * getRowCount method comment.
 */
public int getRowCount()
{
   if(nodes == null)
      return 0;
   else
      return nodes.size();
}
/**
 * This method was created in VisualAge.
 * @return java.lang.Object
 * @param row int
 * @param col int
 */
public Object getValueAt(int row, int col)
{
   if(type == NO_PATH)
      if(col >= 2) col++;

   switch(col)
   {
      case 0:
         if( ((HDataNode) nodes.elementAt(row)).type == HDataNode.f)
            return UIManager.getIcon("Tree.leafIcon");
         else
         {
            HDataNode aNode = (HDataNode) nodes.elementAt(row);
            return FileManagerPanel.getAssocIcon(aNode.type);
         }
      case 1: return ( (HDataNode) nodes.elementAt(row)).toString();
      case 2: return ( (HDataNode) nodes.elementAt(row)).path;
      case 3: return new Long( ((HDataNode) nodes.elementAt(row)).length);
      case 4: return new Date( ((HDataNode) nodes.elementAt(row)).dateModified);
      default: return null;
   }
}

public HDataNode getNode(int row)
{
   return (HDataNode) nodes.elementAt(row);
}

public void setNode(int row, HDataNode aNode)
{
   nodes.setElementAt(aNode, row);
   fireTableRowsUpdated(row,row);
}

public void addNode(HDataNode aNode)
{
   nodes.addElement(aNode);
   fireTableRowsInserted(nodes.size()-1, nodes.size()-1);
}

public void addNodes(Vector nodes)
{
   this.nodes.ensureCapacity(this.nodes.size() + nodes.size());
   int firstNew = this.nodes.size()-1;
   int newCount = nodes.size();
   for(int i = 0; i < newCount; i++)
      this.nodes.addElement(nodes.elementAt(i));

//   fireTableRowsInserted(firstNew, this.nodes.size()-1);
// Swing Bug: columns are reloaded when fireTableRowsInserted is used
//            so preferredSize() are discarded. fireTableDataChanged
//            doesn't have that problem.  but it's slow!!!!
   fireTableDataChanged();
}

public void removeNode(HDataNode aNode)
{
   int row = nodes.indexOf(aNode);
   if(row != -1)
   {
      nodes.removeElementAt(row);
      fireTableRowsDeleted(row,row);
   }
}

public void clearTable()
{
   nodes.removeAllElements();
   fireTableDataChanged();
}


protected void finalize() throws Throwable
{
   nodes.removeAllElements();
   nodes = null;
   assocTree = null;
   database = null;
   pathToTable = null;

   super.finalize();
}

public DynamicTreeNode getAssocTreeNode(HDataNode aNode)
{
   DefaultTreeModel treeModel = (DefaultTreeModel) assocTree.getModel();

   // returns parent
   if(aNode.fileName == "..")
   {
//      assocTree.collapsePath(pathToTable);
      return (DynamicTreeNode) pathToTable.getPathComponent(pathToTable.getPathCount()-2); // before last == parent
   }

   // scanning tree to find the associated treenode
   DynamicTreeNode lastPath = (DynamicTreeNode) pathToTable.getLastPathComponent();
   int count = treeModel.getChildCount(lastPath);
   for(int i = 0; i < count; i++)
   {
      DynamicTreeNode aTreeNode = (DynamicTreeNode) treeModel.getChild(lastPath,i);
      HDataNode aTreeDataNode = (HDataNode) aTreeNode.getUserObject();
      if(aTreeDataNode.equals(aNode))
         return aTreeNode;
   }
   return null;
}

public DynamicTreeNode getAssocTreeNode(int index)
{
   HDataNode aNode = (HDataNode) nodes.elementAt(index);
   return getAssocTreeNode(aNode);
}

public TreePath getAssocTreePath(int index)
{
   DefaultTreeModel treeModel = (DefaultTreeModel) assocTree.getModel();
   DynamicTreeNode aTreeNode = getAssocTreeNode(index);
   if(aTreeNode == null)
      return null;

   return new TreePath(treeModel.getPathToRoot(aTreeNode));
}

public HDataNode[] getNodes(int rows[])
{
   if(rows.length == 0)
      return null;

   // if 0 is selected it may be ".."
   HDataNode[] nodes;
   if(rows[0] == 0 && this.nodes.elementAt(0).toString() == "..")
      nodes = new HDataNode[rows.length-1];
   else
      nodes = new HDataNode[rows.length];

   int j = 0;
   for(int i = 0; i < rows.length; i++)
   {
      HDataNode aNode = (HDataNode) this.nodes.elementAt(rows[i]);
      if(aNode.toString() != "..")
         nodes[j++] = aNode;
   }
   return nodes;
}


protected void updateListTable(DynamicTreeNode aTreeNode) throws IOException
{
   HDataNode hdataparent = (HDataNode) aTreeNode.getUserObject();
   long totalSize = 0;
   int count = database.childCount(hdataparent);
   nodes.removeAllElements();
   nodes.ensureCapacity(count+1);

   // adding ".." for previous directory except for rootnode
   if(hdataparent.myPointer != 0)
   {
      HDataNode grandParent = (HDataNode) ((DynamicTreeNode)aTreeNode.getParent()).getUserObject();
      HDataNode anode = (HDataNode) grandParent.clone();
//      anode.type = anode.d; // so that it reports fileName even for disks
      anode.length = 0;
      anode.fileName = "..";
      anode.desc = "..";

      nodes.addElement(anode);
   }

   int i = 0;
   for(i = 0; i < count; i++)
   {
     HDataNode anode = database.read(hdataparent,i);
     nodes.addElement(anode);
     totalSize += anode.length;
   }

   fireTableDataChanged();
}

public void loadTable(DynamicTreeNode aTreeNode) throws IOException
{
   DefaultTreeModel treeModel = (DefaultTreeModel) assocTree.getModel();
   pathToTable = new TreePath(treeModel.getPathToRoot(aTreeNode));
   updateListTable(aTreeNode);
}

public TreePath getPathToTable()
{
   return pathToTable;
}

public void setValueAt(HDataNode aNode, int row)
{
   nodes.setElementAt(aNode,row);
   fireTableRowsUpdated(row,row);
}


/* setting values directly from table, but eessh single click crap is no fun

public boolean isCellEditable(int row, int col)
{
   if(type == NO_PATH)
      if(col >= 2) col++;

   switch(col)
   {
      case 1: return true;
   }
   return false;
}

public void setValueAt(Object value, int row, int col)
{
   if(type == NO_PATH)
      if(col >= 2) col++;

   switch(col)
   {
      case 1:
         HDataNode aNode = (HDataNode) nodes.elementAt(row);
         switch(aNode.type)
         {
            case aNode.f:
            case aNode.d:
            case aNode.c:
               aNode.fileName = (String) value; break;
            case aNode.v:
               aNode.desc = (String) value; break;
         }
         try
         {
            database.update(aNode);
         }
         catch(IOException e)
         {
         }
         break;
   }
}
*/

}
