/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import java.io.*;
import java.util.*;
import java.text.*;

public class FileManagerPanel extends JPanel implements TreeSelectionListener, ListSelectionListener, PropertiesStickListener
{
   JSplitPane splitPanel;
   JTree dirTree;
   JTable listTable;
   JScrollPane scrollTree, scrollTable;

   HDataTableModel tableModelOrg;
   HDataTreeModel treeModel;
   TableSorter tableModel;

   JLabel statusLabel;
   JLabel unregLabel;
   Box statusLine;

   Vector stickyPropertiesDialogs = new Vector(5);

   JFrame mainFrame;
   HDatabase database;

FileManagerPanel(JFrame mainFrame, HDatabase database)
{
   super();
   this.mainFrame = mainFrame;
   this.database = database;

   // tree, table and their scroll stuff
   treeModel = new HDataTreeModel(new DynamicTreeNode(database.rootNode,database));
   dirTree = new JTree(treeModel);
//  dirTree.setRootVisible(false);
   dirTree.addTreeSelectionListener(this);
   dirTree.setCellRenderer(new TreeFolderRenderer());


   tableModelOrg = new HDataTableModel(HDataTableModel.NO_PATH,dirTree,database);
   tableModel = new TableSorter(tableModelOrg);
   listTable = new JTable(tableModel);
   tableModel.addMouseListenerToHeaderInTable(listTable);
//  listTable.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
   listTable.setShowVerticalLines(false);
   listTable.setShowHorizontalLines(false);
   listTable.getSelectionModel().addListSelectionListener(this);

   for (int i = 0; i < 4; i++)
   {
      TableColumn column = listTable.getColumnModel().getColumn(i);
      switch(i)
      {
         case 0: column.setPreferredWidth(UIManager.getIcon("Tree.closedIcon").getIconWidth()+15);
                 column.setMaxWidth(column.getPreferredWidth()); break;
         case 1: column.setPreferredWidth(150); break;
         case 2: column.setPreferredWidth(75); break;
         case 3: column.setPreferredWidth(100); break;
      }
   }

   listTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer()
   {
      public Component getTableCellRendererComponent(JTable table, Object date,
                       boolean isSelected, boolean hasFocus, int row, int column)
      {
         setHorizontalAlignment(CENTER);
         return super.getTableCellRendererComponent(table, DateFormat.getInstance().format((Date)date), isSelected, hasFocus, row, column);
      }
   });

   scrollTree = new JScrollPane(dirTree);
   scrollTree.getViewport().setBackingStoreEnabled(true);
   scrollTree.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);

   scrollTable = new JScrollPane(listTable);
//  scrollTable.setColumnHeaderView(listTable.getTableHeader());
   scrollTable.getViewport().setBackingStoreEnabled(true);
   scrollTable.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);


   // the split panel
   splitPanel = new JSplitPane();
   splitPanel.add(scrollTree,"left");
   splitPanel.add(scrollTable,"right");

   // status line
   statusLabel = new JLabel("Nothing yet");
   unregLabel = new JLabel("");
   unregLabel.setForeground(Color.red);
   unregLabel.setAlignmentX(RIGHT_ALIGNMENT);
   statusLine = Box.createHorizontalBox();
   statusLine.add(statusLabel);
   statusLine.add(Box.createGlue());
   statusLine.add(unregLabel);

   // the main panel
   setLayout(new BorderLayout());
   add(splitPanel, "Center");
   add(statusLine, "South");

   // loads initial data
   dirTree.expandPath(new TreePath(treeModel.getRoot()));
   dirTree.addSelectionRow(0);
}


public void addTableMouseListener(MouseListener l)
{
   listTable.addMouseListener(l);
}

public void addTreeMouseListener(MouseListener l)
{
   dirTree.addMouseListener(l);
}

public void addTableKeyListener(KeyListener l)
{
   listTable.addKeyListener(l);
}


public void valueChanged(TreeSelectionEvent event)
{
   if(!stickyPropertiesDialogs.isEmpty())
   {
      TreePath[] selections = dirTree.getSelectionPaths();
      for(int i = 0; i < selections.length && i < stickyPropertiesDialogs.size(); i++)
         ((PropertiesDialog) stickyPropertiesDialogs.elementAt(i)).loadNode((HDataNode)((DynamicTreeNode)selections[i].getLastPathComponent()).getUserObject(),selections[i].getParentPath());
   }

   DynamicTreeNode parent = (DynamicTreeNode) dirTree.getLastSelectedPathComponent();
   if (parent == null)
      return;

   try
   {
      tableModel.loadTable(parent);

      int totalSize = 0;
      for(int i = 0; i < tableModel.getRowCount(); i++)
      {
         HDataNode anode = tableModel.getNode(i);
         totalSize += anode.length;
      }
      statusLabel.setText(tableModel.getRowCount() + " Files   " + parent + "   Total Size " + NumberFormat.getInstance().format(totalSize));
   }
   catch(IOException e)
   {
      JOptionPane.showMessageDialog(mainFrame,"Database corrupted, could not load nodes in table.","Error",JOptionPane.ERROR_MESSAGE);
   }
}

public void valueChanged(ListSelectionEvent e)
{
   if(!stickyPropertiesDialogs.isEmpty())
   {
      HDataNode[] nodes = tableModel.getNodes(listTable.getSelectedRows());
      for(int i = 0; i < nodes.length && i < stickyPropertiesDialogs.size(); i++)
         ((PropertiesDialog) stickyPropertiesDialogs.elementAt(i)).loadNode(nodes[i],tableModel.getPathToTable());
   }
}

public void addStickDialog(PropertiesDialog aDialog)
{
   stickyPropertiesDialogs.addElement(aDialog);
}

public void removeStickDialog(PropertiesDialog aDialog)
{
   stickyPropertiesDialogs.removeElement(aDialog);
}



// finds the first treenode with the desired type along the lead selection path
public DynamicTreeNode getFirstOfType(int type)
{
   TreePath selectedDir = dirTree.getLeadSelectionPath();
   DynamicTreeNode aTreeNode = null;
   HDataNode aNode = null;

   if(type == -1)
     return (DynamicTreeNode) selectedDir.getLastPathComponent();

   for(int i = selectedDir.getPathCount()-1; i >= 0; i--)
   {
     aTreeNode = (DynamicTreeNode) selectedDir.getPathComponent(i);
     aNode = (HDataNode) aTreeNode.getUserObject();
     if(aNode.type == type)
       break;
   }
   return aTreeNode;  // gets root at worse
}

// checks if any ancestor of that treenode is of the desired type
public boolean hasAncestorOfType(DynamicTreeNode aTreeNode, byte type)
{
   TreeNode[] pathToStudy = treeModel.getPathToRoot(aTreeNode);

   for(int i = 0; i < pathToStudy.length; i++)
   {
     HDataNode aNode = (HDataNode) ((DynamicTreeNode)pathToStudy[i]).getUserObject();
     if(aNode.type == type)
       return true;
   }
   return false;
}

public DynamicTreeNode addNewNode(DynamicTreeNode parent, HDataNode anode)
{
   DynamicTreeNode treenode = new DynamicTreeNode(anode,database);
   treeModel.insertNodeInto(treenode, parent, parent.getChildCount());
   treeModel.sortChildren(parent);
   dirTree.setSelectionPath(new TreePath(treeModel.getPathToRoot(treenode)));
   return treenode;
}

public void deleteTreeNode(DynamicTreeNode aTreeNode)
{
   TreePath pathToTable = tableModel.getPathToTable();
   DynamicTreeNode nodeToTable = (DynamicTreeNode) pathToTable.getLastPathComponent();
   TreePath pathToSelect = null;

   // If the node being deleted is 1. a parent of the selected node or
   // 2. the actual selected node,
   // let's select the parent of the deleted node to refresh the table
   if(nodeToTable.isNodeAncestor(aTreeNode))
      pathToSelect = new TreePath(treeModel.getPathToRoot(aTreeNode.getParent()));

   // if the node being deleted is a direct child of the node being shown
   // in the table, let's just refresh the table
   if(nodeToTable.isNodeChild(aTreeNode))
      pathToSelect = pathToTable;

if(false)
{

   // decrement hdatanode indexes over the index of the deleted node to
   // keep consistency with the database
   HDataNode deletedNode = (HDataNode) aTreeNode.getUserObject();
   DynamicTreeNode parentTreeNode = (DynamicTreeNode) aTreeNode.getParent();
   int childCount = parentTreeNode.getChildCount();

   for(int i = 0; i < childCount; i++)
   {
      DynamicTreeNode aChildTreeNode = (DynamicTreeNode) parentTreeNode.getChildAt(i);
      HDataNode oldNode = (HDataNode) aChildTreeNode.getUserObject();
      if(oldNode.index > deletedNode.index)
         oldNode.index--;  // consistency with the database engine
   }

}

   treeModel.removeNodeFromParent(aTreeNode);

   if(pathToSelect != null)
   {
      dirTree.clearSelection(); // assures a table refresh
      dirTree.setSelectionPath(pathToSelect);
   }

}

// deletes nodes that are currently loaded in the table
public void deleteTableNodes(HDataNode[] nodes)
{
   for(int i = 0; i < nodes.length; i++)
      tableModel.removeNode(nodes[i]);

   tableModel.sort();
}

public void replaceNode(HDataNode aNode, HDataNode newNode, TreePath aPath)
{
   DynamicTreeNode parentTreeNode = (DynamicTreeNode) aPath.getLastPathComponent();
   int childCount = parentTreeNode.getChildCount();
   for(int i = 0; i < childCount; i++)
   {
      DynamicTreeNode aTreeNode = (DynamicTreeNode) parentTreeNode.getChildAt(i);
      HDataNode oldNode = (HDataNode) aTreeNode.getUserObject();
      if(oldNode.equals(aNode))
      {
         aTreeNode.setUserObject(newNode);
         treeModel.sortChildren(parentTreeNode);
         treeModel.nodeChanged(aTreeNode);
      }
      else
      {
         if(oldNode.index > aNode.index)
            oldNode.index--;  // consistency with the database engine
      }
   }
}


// custom icon routines!! most are static

   static Icon containerIcon = new FolderIcon("c"),
               volumeIcon = new FolderIcon("v"),
               directoryIcon = UIManager.getIcon("Tree.closedIcon"),
               zipIcon = new FolderIcon("z");

static public Icon getAssocIcon(int type)
{
   switch(type)
   {
      case HDataNode.c: return containerIcon;
      case HDataNode.v: return volumeIcon;
      case HDataNode.d: return directoryIcon;
      case HDataNode.z: return zipIcon;
      default: return UIManager.getIcon("Tree.closedIcon");
   }
}


   static public class FolderIcon implements Icon
   {
      Icon orgFolderIcon = UIManager.getIcon("Tree.closedIcon");
      String character;

      public FolderIcon(String character)
      {
         this.character = character;
      }

      public void paintIcon(Component c, Graphics g, int x, int y)
      {
         orgFolderIcon.paintIcon(c,g,x,y);
         Font oldFont = g.getFont();
         Color oldColor = g.getColor();
         g.setColor( UIManager.getColor("Label.foreground") );
         g.setFont( UIManager.getFont("Label.font") );

         FontMetrics fontMetrics = g.getFontMetrics();

         g.drawString(character,x+getIconWidth()/2-fontMetrics.stringWidth(character)/2-2,
                          y+3*getIconHeight()/4-1);
         g.setColor(oldColor);
         g.setFont(oldFont);
      }
      public int getIconWidth() { return orgFolderIcon.getIconWidth(); }
      public int getIconHeight() { return orgFolderIcon.getIconHeight(); }
   }


   public class TreeFolderRenderer extends DefaultTreeCellRenderer
   {
      public Component getTreeCellRendererComponent(JTree tree, Object value,
             boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus)
      {
         super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
         HDataNode aNode = (HDataNode) ((DynamicTreeNode) value).getUserObject();
         setIcon(getAssocIcon(aNode.type));
         return this;
      }
   }


}
