/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

class Base64
{
   protected final static char[] charSet =
   {'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
    'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
    '0','1','2','3','4','5','6','7','8','9','+','/' };

   public static String encode(byte[] data)
   {
      char[] encodedData = new char[(data.length / 3 + (data.length % 3 > 0 ? 1 : 0) ) * 4];
      int buffer, i = 0, j = 0;
      while(data.length - i > 2)
      {
         buffer = data[i++] & 0xFF;
         buffer <<= 8;
         buffer |= data[i++] & 0xFF;
         buffer <<= 8;
         buffer |= data[i++] & 0xFF;

         encodedData[j++] = charSet[ (buffer & 0xFC0000) >> 18 ];
         encodedData[j++] = charSet[ (buffer & 0x3F000) >> 12 ];
         encodedData[j++] = charSet[ (buffer & 0xFC0) >> 6 ];
         encodedData[j++] = charSet[ (buffer & 0x3F) ];
      }

      // if we need padding
      if(data.length - i == 2)
      {
         buffer = data[i++] & 0xFF;
         buffer <<= 8;
         buffer |= data[i++] & 0xFF;
         buffer <<= 8;

         encodedData[j++] = charSet[ (buffer & 0xFC0000) >> 18 ];
         encodedData[j++] = charSet[ (buffer & 0x3F000) >> 12 ];
         encodedData[j++] = charSet[ (buffer & 0xFC0) >> 6 ];

         encodedData[j++] = '='; // padding
      }
      else if(data.length - i == 1)
      {
         buffer = data[i++] & 0xFF;
         buffer <<= 8;
         buffer <<= 8;

         encodedData[j++] = charSet[ (buffer & 0xFC0000) >> 18 ];
         encodedData[j++] = charSet[ (buffer & 0x3F000) >> 12 ];

         encodedData[j++] = '='; // padding
         encodedData[j++] = '='; // padding
      }

      return new String(encodedData);
   }

   // used only for decoding... actually returns the position of a certain char
   // in the charSet array
   protected static int getCharValue(char c)
   {
      int value = -1;

      if(c >= 'A' && c <= 'Z')
         value = c - 'A';
      else if(c >= 'a' && c <= 'z')
         value = c - 'a' + 26;
      else if(c >= '0' && c <= '9')
         value = c - '0' + 2*26;
      else if(c == '+')
         value = 2*26+10;
      else if(c == '/')
         value = 2*26+11;

      return value;
   }


   public static byte[] decode(String data)
   {
      int pad = 0;
      if(data.endsWith("=="))
         pad = 2;
      else if(data.endsWith("="))
         pad = 1;

      byte[] decodedData = new byte[(data.length() - pad) * 3/4];
      int buffer, i = 0, j = 0;

      while(data.length() - i > 3+pad)
      {
         buffer = getCharValue(data.charAt(i++)); // no error checking, garbage in, garbage out
         buffer <<= 6;
         buffer |= getCharValue(data.charAt(i++));
         buffer <<= 6;
         buffer |= getCharValue(data.charAt(i++));
         buffer <<= 6;
         buffer |= getCharValue(data.charAt(i++));

         decodedData[j++] = (byte) ((buffer & 0xFF0000) >> 16);
         decodedData[j++] = (byte) ((buffer & 0xFF00) >> 8);
         decodedData[j++] = (byte) ((buffer & 0xFF));
      }

      if(pad == 1)
      {
         buffer = getCharValue(data.charAt(i++)); // no error checking, garbage in, garbage out
         buffer <<= 6;
         buffer |= getCharValue(data.charAt(i++));
         buffer <<= 6;
         buffer |= getCharValue(data.charAt(i++));
         buffer <<= 6;

         decodedData[j++] = (byte) ((buffer & 0xFF0000) >> 16);
         decodedData[j++] = (byte) ((buffer & 0xFF00) >> 8);
      }
      else if(pad == 2)
      {
         buffer = getCharValue(data.charAt(i++)); // no error checking, garbage in, garbage out
         buffer <<= 6;
         buffer |= getCharValue(data.charAt(i++));
         buffer <<= 6;
         buffer <<= 6;

         decodedData[j++] = (byte) ((buffer & 0xFF0000) >> 16);
      }

      return decodedData;
   }

   public static void main(String[] args)
   {
      String encoded = encode(args[0].getBytes());
      System.out.println(encoded + " -> " + new String(decode(encoded)));
   }
}
