/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;

public class HDatabase
implements HDatabaseIO {
    protected HBufferManager dataBuffer = null;
    public static final int DATABASE_VERSION = 1;
    public int databaseVersion = 1;
    public static final int PAGE_SIZE = 1024;
    public HDataNode rootNode = null;
    static int numline = 0;
    protected int removeRecursionLevel = 0;

    public HDatabase(HBufferManager hBufferManager) {
        this.dataBuffer = hBufferManager;
        this.rootNode = hBufferManager.rootNode;
        this.databaseVersion = hBufferManager.databaseVersion;
    }

    public short childCount(HDataNode hDataNode) throws IOException {
        short s = 0;
        if (hDataNode == null) {
            hDataNode = this.rootNode;
        }
        if (hDataNode.childPointer == -1) {
            return 0;
        }
        HDataPage hDataPage = this.dataBuffer.getPage(hDataNode.childPointer);
        s = (short)(s + hDataPage.amount);
        while (hDataPage.nextBrother != -1) {
            hDataPage = this.dataBuffer.getPage(hDataPage.nextBrother);
            s = (short)(s + hDataPage.amount);
        }
        return s;
    }

    protected void finalize() throws Throwable {
        this.dataBuffer = null;
        this.rootNode = null;
        super.finalize();
    }

    public final HDataNode findNode(HDataNode hDataNode, String string) throws IOException {
        int n = 0;
        int n2 = this.childCount(hDataNode);
        HDataNode hDataNode2 = new HDataNode();
        while (n < n2) {
            hDataNode2 = this.read(hDataNode, n++);
            if (!string.equals(hDataNode2.fileName)) continue;
            return hDataNode2;
        }
        return null;
    }

    public synchronized boolean move(HDataNode hDataNode, HDataNode hDataNode2) throws IOException {
        HDataNode hDataNode3 = this.rootNode;
        synchronized (hDataNode3) {
            HDataNode hDataNode4 = (HDataNode)hDataNode2.clone();
            this.write(hDataNode, hDataNode4);
            this.removeFromPage(hDataNode2);
            this.dataBuffer.startLazyWriteTimer();
        }
        return true;
    }

    public HDataNode read(HDataNode hDataNode, int n) throws IOException {
        HDataPage hDataPage = this.dataBuffer.getPage(hDataNode.childPointer);
        while (n >= hDataPage.startAt + hDataPage.amount) {
            if (hDataPage.nextBrother == -1) {
                return null;
            }
            hDataPage = this.dataBuffer.getPage(hDataPage.nextBrother);
        }
        return hDataPage.getNode(n - hDataPage.startAt);
    }

    protected boolean readBlob(HDataNode hDataNode) throws IOException {
        if (hDataNode.blobPointer == -1) {
            return false;
        }
        int n = 0;
        HDataPage hDataPage = this.dataBuffer.getPage(hDataNode.blobPointer);
        int n2 = hDataPage.nextBrother;
        n += hDataPage.blobData.length;
        while (n2 != -1) {
            hDataPage = this.dataBuffer.getPage(n2);
            n2 = hDataPage.nextBrother;
            n += hDataPage.blobData.length;
        }
        byte[] byArray = new byte[n];
        n = 0;
        hDataPage = this.dataBuffer.getPage(hDataNode.blobPointer);
        n2 = hDataPage.nextBrother;
        System.arraycopy(hDataPage.blobData, 0, byArray, n, hDataPage.blobData.length);
        n += hDataPage.blobData.length;
        while (n2 != -1) {
            hDataPage = this.dataBuffer.getPage(n2);
            n2 = hDataPage.nextBrother;
            System.arraycopy(hDataPage.blobData, 0, byArray, n, hDataPage.blobData.length);
            n += hDataPage.blobData.length;
        }
        return hDataNode.setBlobData(byArray);
    }

    public HDataNode readParent(HDataNode hDataNode) throws IOException {
        HDataNode hDataNode2 = new HDataNode();
        if (hDataNode.parentPointer == 0) {
            return this.rootNode;
        }
        HDataPage hDataPage = this.dataBuffer.getPage(hDataNode.parentPointer);
        int n = hDataPage.getNodeSize();
        int n2 = 0;
        while (n2 < n) {
            if (hDataPage.getNode((int)n2).childPointer == hDataNode.primaryPointer) {
                return hDataPage.getNode(n2);
            }
            ++n2;
        }
        return null;
    }

    public boolean remove(HDataNode hDataNode) throws IOException {
        HDataNode hDataNode2 = this.rootNode;
        synchronized (hDataNode2) {
            ++this.removeRecursionLevel;
            this.removeBlob(hDataNode);
            if (hDataNode.childPointer != -1) {
                int n = this.childCount(hDataNode);
                int n2 = 0;
                while (n2 < n) {
                    this.remove(this.read(hDataNode, n2));
                    ++n2;
                }
                HDataPage hDataPage = this.dataBuffer.getPage(hDataNode.childPointer);
                this.dataBuffer.removePage(hDataNode.childPointer);
                int n3 = hDataPage.nextBrother;
                while (n3 != -1) {
                    hDataPage = this.dataBuffer.getPage(n3);
                    this.dataBuffer.removePage(n3);
                    n3 = hDataPage.nextBrother;
                }
            }
            if (this.removeRecursionLevel == 1) {
                this.removeFromPage(hDataNode);
                this.dataBuffer.trimFile();
                this.dataBuffer.startLazyWriteTimer();
            }
            --this.removeRecursionLevel;
        }
        return true;
    }

    protected boolean removeBlob(HDataNode hDataNode) throws IOException {
        if (hDataNode.blobPointer == -1) {
            return false;
        }
        HDataPage hDataPage = this.dataBuffer.getPage(hDataNode.blobPointer);
        int n = hDataPage.nextBrother;
        this.dataBuffer.removePage(hDataPage.myPointer);
        while (n != -1) {
            hDataPage = this.dataBuffer.getPage(n);
            n = hDataPage.nextBrother;
            this.dataBuffer.removePage(hDataPage.myPointer);
        }
        this.dataBuffer.startLazyWriteTimer();
        return true;
    }

    protected boolean removeFromPage(HDataNode hDataNode) throws IOException {
        HDataPage hDataPage = this.dataBuffer.getPage(hDataNode.myPointer);
        int n = hDataPage.getIndexOf(hDataNode);
        if (n != -1) {
            hDataPage.removeNode(n);
            int n2 = hDataPage.nextBrother;
            while (n2 != -1) {
                hDataPage = this.dataBuffer.getPage(n2);
                hDataPage.startAt = (short)(hDataPage.startAt - 1);
                hDataPage.setStartAt(hDataPage.startAt);
                n2 = hDataPage.nextBrother;
            }
            return true;
        }
        return false;
    }

    public synchronized boolean retrieveBlob(HDataNode hDataNode) throws IOException {
        if (hDataNode.thumbnail != null) {
            return true;
        }
        return this.readBlob(hDataNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update(HDataNode hDataNode, HDataNode hDataNode2) throws IOException {
        HDataNode hDataNode3 = this.rootNode;
        synchronized (hDataNode3) {
            HDataPage hDataPage = this.dataBuffer.getPage(hDataNode.myPointer);
            int n = hDataPage.getIndexOf(hDataNode);
            if (n == -1) {
                return false;
            }
            if (hDataPage.setNode(hDataNode2, n)) {
                this.dataBuffer.startLazyWriteTimer();
                return true;
            }
            this.writeToPage(hDataNode2);
            if (hDataNode2.myPointer != hDataNode.myPointer && hDataNode2.childPointer != -1) {
                hDataPage = this.dataBuffer.getPage(hDataNode2.childPointer);
                hDataPage.setParentPointer(hDataNode2.myPointer);
                int n2 = hDataPage.nextBrother;
                while (n2 != -1) {
                    hDataPage = this.dataBuffer.getPage(n2);
                    hDataPage.setParentPointer(hDataNode2.myPointer);
                    n2 = hDataPage.nextBrother;
                }
            }
            this.removeFromPage(hDataNode);
            this.dataBuffer.startLazyWriteTimer();
            return true;
        }
    }

    public synchronized boolean write(HDataNode hDataNode, HDataNode hDataNode2) throws IOException {
        HDataNode hDataNode3 = this.rootNode;
        synchronized (hDataNode3) {
            if (hDataNode == null) {
                hDataNode = this.rootNode;
            }
            if (hDataNode.childPointer == -1) {
                HDataNode hDataNode4 = (HDataNode)hDataNode.clone();
                HDataPage hDataPage = this.dataBuffer.createChildPage(hDataNode);
                if (hDataNode != this.rootNode) {
                    this.update(hDataNode4, hDataNode);
                }
            }
            hDataNode2.primaryPointer = hDataNode.childPointer;
            this.writeToPage(hDataNode2);
            this.writeBlob(hDataNode2);
            this.dataBuffer.startLazyWriteTimer();
        }
        return true;
    }

    public static final boolean writeBlanks(RandomAccessFile randomAccessFile, int n) throws IOException {
        int n2 = n > 2048 ? 2048 : n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n / byArray.length) {
            randomAccessFile.write(byArray);
            ++n3;
        }
        n3 = 0;
        while (n3 < n % byArray.length) {
            randomAccessFile.writeByte(0);
            ++n3;
        }
        return true;
    }

    protected boolean writeBlob(HDataNode hDataNode) throws IOException {
        if (hDataNode.blobPointer != -1) {
            return false;
        }
        byte[] byArray = hDataNode.getBlobData();
        if (byArray == null) {
            return false;
        }
        HDataPage hDataPage = this.dataBuffer.createBlobPage(hDataNode);
        int n = 0;
        short s = (short)Math.min(byArray.length - n, 1002);
        hDataPage.setBlobData(byArray, n, s);
        n = (short)(n + s);
        s = (short)Math.min(byArray.length - n, 1002);
        while (s > 0) {
            hDataPage = this.dataBuffer.createBrotherPage(hDataPage);
            hDataPage.setBlobData(byArray, n, s);
            n = (short)(n + s);
            s = (short)Math.min(byArray.length - n, 1002);
        }
        this.dataBuffer.startLazyWriteTimer();
        return true;
    }

    protected void writeToPage(HDataNode hDataNode) throws IOException {
        int n;
        HDataPage hDataPage = this.dataBuffer.getPage(hDataNode.primaryPointer);
        short s = hDataNode.size();
        while (!hDataPage.addNode(hDataNode)) {
            n = hDataPage.nextBrother;
            hDataPage = n == -1 ? this.dataBuffer.createBrotherPage(hDataPage) : this.dataBuffer.getPage(n);
        }
        n = hDataPage.nextBrother;
        while (n != -1) {
            hDataPage = this.dataBuffer.getPage(n);
            hDataPage.startAt = (short)(hDataPage.startAt + 1);
            hDataPage.setStartAt(hDataPage.startAt);
            n = hDataPage.nextBrother;
        }
    }
}

