/*
 * Decompiled with CFR 0.152.
 */
import encoder.jpeg.JpegEncoder;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import javax.swing.tree.TreePath;

public class HDataNode
implements Cloneable {
    String fileName = null;
    String desc = null;
    ID3Tag id3tag = null;
    byte type = (byte)-1;
    public static final byte d = 100;
    public static final byte f = 102;
    public static final byte v = 118;
    public static final byte c = 99;
    public static final byte z = 122;
    long length = -1L;
    long dateModified = -1L;
    short width = (short)-1;
    short height = (short)-1;
    int childPointer = -1;
    int blobPointer = -1;
    boolean[] scanOptions = null;
    Image thumbnail = null;
    public static final short infoSize = 36;
    int primaryPointer = -1;
    int myPointer = -1;
    int parentPointer = -1;
    int index = -1;
    TreePath treePath = null;
    String path = null;
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    protected static final Toolkit toolkit = Toolkit.getDefaultToolkit();

    public HDataNode() {
    }

    public HDataNode(File file) {
        this.copyFrom(file);
    }

    public void clear() {
        this.fileName = null;
        this.desc = null;
        this.id3tag = null;
        this.type = (byte)-1;
        this.length = -1L;
        this.dateModified = -1L;
        this.width = (short)-1;
        this.height = (short)-1;
        this.childPointer = -1;
        this.blobPointer = -1;
        this.primaryPointer = -1;
        this.myPointer = -1;
        this.parentPointer = -1;
        this.index = -1;
        this.flushThumbnail();
        this.treePath = null;
        this.path = null;
    }

    public Object clone() {
        try {
            HDataNode hDataNode = (HDataNode)super.clone();
            hDataNode.fileName = this.fileName;
            hDataNode.desc = this.desc;
            if (this.id3tag != null) {
                hDataNode.id3tag = (ID3Tag)this.id3tag.clone();
            }
            hDataNode.type = this.type;
            hDataNode.length = this.length;
            hDataNode.dateModified = this.dateModified;
            hDataNode.width = this.width;
            hDataNode.height = this.height;
            hDataNode.childPointer = this.childPointer;
            hDataNode.blobPointer = this.blobPointer;
            hDataNode.primaryPointer = this.myPointer;
            hDataNode.myPointer = this.myPointer;
            hDataNode.parentPointer = this.parentPointer;
            hDataNode.index = this.index;
            hDataNode.thumbnail = this.thumbnail;
            hDataNode.treePath = this.treePath;
            hDataNode.path = this.path;
            return hDataNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void copyFrom(File file) {
        this.copyFrom(file, new boolean[3]);
    }

    public void copyFrom(File file, boolean[] blArray) {
        this.clear();
        this.dateModified = file.lastModified();
        this.length = file.length();
        this.type = file.isDirectory() ? (byte)100 : (byte)102;
        this.fileName = file.getName();
        if (blArray[1]) {
            try {
                this.id3tag = new ID3Tag();
                if (!this.id3tag.read(file.getPath())) {
                    this.id3tag = null;
                }
            }
            catch (IOException iOException) {
                this.id3tag = null;
            }
        } else {
            this.id3tag = null;
        }
        if (blArray[2]) {
            try {
                Image image = toolkit.getImage(file.getPath());
                MediaTracker mediaTracker = tracker;
                synchronized (mediaTracker) {
                    tracker.addImage(image, 0);
                    tracker.waitForID(0);
                    tracker.removeImage(image, 0);
                }
                this.flushThumbnail();
                if (image.getHeight(null) != -1 && image.getWidth(null) != -1) {
                    this.thumbnail = image.getScaledInstance(-1, 90, 4);
                    mediaTracker = tracker;
                    synchronized (mediaTracker) {
                        tracker.addImage(this.thumbnail, 0);
                        tracker.waitForID(0);
                        tracker.removeImage(this.thumbnail, 0);
                    }
                    this.width = (short)image.getWidth(null);
                    this.height = (short)image.getHeight(null);
                }
                image.flush();
                image = null;
            }
            catch (InterruptedException interruptedException) {
                this.flushThumbnail();
            }
        } else {
            this.flushThumbnail();
        }
    }

    public void copyFrom(ZipEntry zipEntry) {
        this.clear();
        this.dateModified = zipEntry.getTime();
        this.length = zipEntry.getSize();
        this.fileName = zipEntry.getName();
        if (zipEntry.isDirectory()) {
            this.type = (byte)100;
            this.fileName = this.fileName.substring(this.fileName.lastIndexOf(47, this.fileName.length() - 2) + 1, this.fileName.length() - 1);
        } else {
            this.type = (byte)102;
            this.fileName = this.fileName.substring(this.fileName.lastIndexOf(47) + 1);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof HDataNode)) {
            return false;
        }
        return this.primaryPointer == ((HDataNode)object).primaryPointer && this.type == ((HDataNode)object).type && this.toString().equals(object.toString()) && this.dateModified == ((HDataNode)object).dateModified;
    }

    protected void finalize() throws Throwable {
        this.fileName = null;
        this.desc = null;
        this.flushThumbnail();
        super.finalize();
    }

    private void flushThumbnail() {
        if (this.thumbnail != null) {
            this.thumbnail.flush();
        }
        this.thumbnail = null;
    }

    public byte[] getBlobData() {
        if (this.thumbnail == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(3 * this.thumbnail.getHeight(null) * this.thumbnail.getWidth(null) / 4);
        new JpegEncoder(this.thumbnail, 75, byteArrayOutputStream).Compress();
        return byteArrayOutputStream.toByteArray();
    }

    public boolean readFrom(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray;
        short s = randomAccessFile.readShort();
        if (s <= 0) {
            this.fileName = null;
        } else {
            byArray = new byte[s];
            randomAccessFile.read(byArray);
            this.fileName = new String(byArray);
        }
        s = randomAccessFile.readShort();
        if (s <= 0) {
            this.desc = null;
        } else {
            byArray = new byte[s];
            randomAccessFile.read(byArray);
            this.desc = new String(byArray);
        }
        short s2 = randomAccessFile.readShort();
        if (s2 <= 0) {
            this.id3tag = null;
        } else if (s2 == 128) {
            this.id3tag = new ID3Tag(randomAccessFile);
        } else {
            randomAccessFile.skipBytes(s2);
        }
        this.type = randomAccessFile.readByte();
        this.length = randomAccessFile.readLong();
        this.dateModified = randomAccessFile.readLong();
        this.width = randomAccessFile.readShort();
        this.height = randomAccessFile.readShort();
        this.childPointer = randomAccessFile.readInt();
        this.blobPointer = randomAccessFile.readInt();
        byte by = randomAccessFile.readByte();
        if (by == 0) {
            this.scanOptions = null;
        } else {
            if (this.scanOptions == null) {
                this.scanOptions = new boolean[3];
            }
            this.scanOptions[0] = (by & 1) == 1;
            this.scanOptions[1] = (by & 2) == 2;
            this.scanOptions[2] = (by & 4) == 4;
        }
        this.flushThumbnail();
        return true;
    }

    public boolean setBlobData(byte[] byArray) {
        this.flushThumbnail();
        this.thumbnail = toolkit.createImage(byArray);
        try {
            MediaTracker mediaTracker = tracker;
            synchronized (mediaTracker) {
                tracker.addImage(this.thumbnail, 0);
                tracker.waitForID(0);
                tracker.removeImage(this.thumbnail, 0);
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.thumbnail.getHeight(null) == -1 || this.thumbnail.getWidth(null) == -1) {
            System.out.println("NOT!!");
            this.flushThumbnail();
            return false;
        }
        return true;
    }

    public short size() {
        short s = 0;
        if (this.fileName != null) {
            s = (short)(s + (short)this.fileName.getBytes().length);
        }
        if (this.desc != null) {
            s = (short)(s + (short)this.desc.getBytes().length);
        }
        if (this.id3tag != null) {
            s = (short)(s + 128);
        }
        return (short)(s + 36);
    }

    public static void skip(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.skipBytes(randomAccessFile.readShort());
        randomAccessFile.skipBytes(randomAccessFile.readShort());
        randomAccessFile.skipBytes(randomAccessFile.readShort());
        randomAccessFile.skipBytes(30);
    }

    public String toString() {
        if (this.type == 118) {
            return this.desc;
        }
        return this.fileName;
    }

    public boolean writeTo(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray;
        if (this.fileName == null) {
            randomAccessFile.writeShort(0);
        } else {
            byArray = this.fileName.getBytes();
            randomAccessFile.writeShort(byArray.length);
            randomAccessFile.write(byArray);
        }
        if (this.desc == null) {
            randomAccessFile.writeShort(0);
        } else {
            byArray = this.desc.getBytes();
            randomAccessFile.writeShort(byArray.length);
            randomAccessFile.write(byArray);
        }
        if (this.id3tag == null) {
            randomAccessFile.writeShort(0);
        } else {
            randomAccessFile.writeShort(128);
            this.id3tag.write(randomAccessFile);
        }
        randomAccessFile.writeByte(this.type);
        randomAccessFile.writeLong(this.length);
        randomAccessFile.writeLong(this.dateModified);
        randomAccessFile.writeShort(this.width);
        randomAccessFile.writeShort(this.height);
        randomAccessFile.writeInt(this.childPointer);
        randomAccessFile.writeInt(this.blobPointer);
        int n = 0;
        if (this.scanOptions != null) {
            if (this.scanOptions[0]) {
                n = (byte)(n | 1);
            }
            if (this.scanOptions[1]) {
                n = (byte)(n | 2);
            }
            if (this.scanOptions[2]) {
                n = (byte)(n | 4);
            }
        }
        randomAccessFile.writeByte(n);
        return true;
    }
}

