/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AddDiskDialog
extends JDialog
implements ActionListener,
Runnable {
    JLabel message = new JLabel("Root directory of drive:");
    JTextField rootDir;
    JTextField desc;
    JButton ok = new JButton("Ok");
    JButton cancel = new JButton("Cancel");
    JPanel buttonPane = new JPanel();
    JFrame mainFrame;
    JCheckBox doZipButton;
    JCheckBox doID3TagButton;
    JCheckBox doGIFJPGButton;
    JLabel status = new JLabel("");
    boolean[] scanOptions = new boolean[3];
    HDatabase database;
    DynamicTreeNode parent;
    Properties options;
    boolean success = false;
    Thread addDiskThread = null;
    HDataNode addDiskToNode = null;
    File addDirectory = null;
    UpdateStatus updateStatus = new UpdateStatus();

    public AddDiskDialog(JFrame jFrame, DynamicTreeNode dynamicTreeNode, HDatabase hDatabase, Properties properties) {
        super((Frame)jFrame, true);
        this.setTitle("Adding a New Disk Volume to \"" + dynamicTreeNode + "\"");
        this.mainFrame = jFrame;
        this.database = hDatabase;
        this.parent = dynamicTreeNode;
        this.options = properties;
        this.rootDir = new JTextField(properties.getProperty("disk.add"));
        this.desc = new JTextField(properties.getProperty("disk.desc"));
        this.message.setAlignmentX(0.0f);
        this.rootDir.setPreferredSize(new Dimension(this.rootDir.getPreferredSize().width, this.rootDir.getPreferredSize().height + 5));
        this.rootDir.setMaximumSize(new Dimension(Short.MAX_VALUE, this.rootDir.getPreferredSize().height));
        this.rootDir.setAlignmentX(0.0f);
        this.desc.setPreferredSize(new Dimension(this.desc.getPreferredSize().width, this.desc.getPreferredSize().height + 5));
        this.desc.setMaximumSize(new Dimension(Short.MAX_VALUE, this.desc.getPreferredSize().height));
        this.desc.setAlignmentX(0.0f);
        this.doZipButton = new JCheckBox("Scan Zip Files");
        this.doZipButton.setMnemonic(90);
        this.doZipButton.setSelected(Boolean.valueOf(properties.getProperty("disk.dozip")));
        this.doID3TagButton = new JCheckBox("Scan ID3 Tags");
        this.doID3TagButton.setMnemonic(51);
        this.doID3TagButton.setSelected(Boolean.valueOf(properties.getProperty("disk.doid3tag")));
        this.doGIFJPGButton = new JCheckBox("Scan GIF and JPG Images");
        this.doGIFJPGButton.setMnemonic(73);
        this.doGIFJPGButton.setSelected(Boolean.valueOf(properties.getProperty("disk.dogifjpg")));
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
        this.buttonPane.add(this.ok);
        this.buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.buttonPane.add(this.cancel);
        this.buttonPane.setAlignmentX(0.0f);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.ok.setMnemonic(79);
        this.cancel.setMnemonic(67);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.message);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(this.rootDir);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(this.desc);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(this.doZipButton);
        jPanel.add(this.doID3TagButton);
        jPanel.add(this.doGIFJPGButton);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(this.buttonPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addWindowListener(new WindowAdapter(){
            boolean focusSet = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (!this.focusSet) {
                    AddDiskDialog.this.rootDir.requestFocus();
                }
                this.focusSet = true;
            }

            public void windowClosing(WindowEvent windowEvent) {
                AddDiskDialog.this.mainFrame.requestFocus();
            }
        });
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.status, "South");
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Ok") {
            this.scanOptions[0] = this.doZipButton.isSelected();
            this.scanOptions[1] = this.doID3TagButton.isSelected();
            this.scanOptions[2] = this.doGIFJPGButton.isSelected();
            this.ok.setEnabled(false);
            this.cancel.setEnabled(true);
            this.addNewDisk();
        } else if (string == "Cancel") {
            if (this.addDiskThread == null) {
                this.dispose();
                this.mainFrame.requestFocus();
            } else {
                this.addDiskThread = null;
            }
        }
    }

    public void addFiles(HDataNode hDataNode, boolean[] blArray, File file, Thread thread) throws IOException {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length && thread == this.addDiskThread) {
            File file2 = new File(file, stringArray[n]);
            HDataNode hDataNode2 = new HDataNode();
            if (file2.isDirectory()) {
                this.updateStat(file2.getPath());
                hDataNode2.copyFrom(file2, blArray);
                this.database.write(hDataNode, hDataNode2);
                this.addFiles(hDataNode2, blArray, file2, thread);
            }
            file2 = null;
            hDataNode2 = null;
            ++n;
        }
        this.updateStat(file.getPath());
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length && thread == this.addDiskThread) {
            File file3 = new File(file, stringArray[n2]);
            HDataNode hDataNode3 = new HDataNode();
            if (!file3.isDirectory()) {
                if (blArray[0]) {
                    try {
                        ZipFile zipFile = new ZipFile(file3);
                        this.updateStat(file3.getPath());
                        hDataNode3.copyFrom(file3, blArray);
                        hDataNode3.type = (byte)122;
                        this.database.write(hDataNode, hDataNode3);
                        this.addZipFile(hDataNode3, zipFile, thread);
                        bl = true;
                    }
                    catch (ZipException zipException) {
                        if (bl) {
                            this.updateStat(file.getPath());
                        }
                        hDataNode3.copyFrom(file3, blArray);
                        this.database.write(hDataNode, hDataNode3);
                        bl = false;
                    }
                } else {
                    hDataNode3.copyFrom(file3, blArray);
                    this.database.write(hDataNode, hDataNode3);
                }
            }
            file3 = null;
            hDataNode3 = null;
            ++n2;
        }
        stringArray = null;
    }

    protected boolean addNewDisk() {
        if (this.addDiskThread != null) {
            return false;
        }
        File file = new File(this.rootDir.getText());
        if (!file.isDirectory()) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error " + this.rootDir.getText() + " is not a valid directory", "Error", 0);
            this.ok.setEnabled(true);
            return false;
        }
        try {
            HDataNode hDataNode = new HDataNode();
            hDataNode.fileName = this.rootDir.getText();
            hDataNode.desc = this.desc.getText();
            hDataNode.type = (byte)118;
            hDataNode.length = 0L;
            hDataNode.dateModified = System.currentTimeMillis();
            hDataNode.scanOptions = this.scanOptions;
            this.database.write((HDataNode)this.parent.getUserObject(), hDataNode);
            this.addDiskToNode = hDataNode;
            this.addDirectory = file;
            this.addDiskThread = new Thread((Runnable)this, "Adding");
            this.addDiskThread.start();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error trying to add new disk volume: Could not write to database.", "Error", 0);
            this.dispose();
            this.mainFrame.requestFocus();
        }
        return true;
    }

    public void addZipFile(HDataNode hDataNode, ZipFile zipFile, Thread thread) throws IOException {
        HDataNode hDataNode2;
        HDataNode hDataNode3;
        Object object;
        int n;
        String string;
        HDataNode hDataNode4;
        ZipEntry zipEntry;
        HDataNode hDataNode5 = hDataNode;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String string2 = null;
        while (enumeration.hasMoreElements() && thread == this.addDiskThread) {
            zipEntry = enumeration.nextElement();
            hDataNode4 = new HDataNode();
            if (!zipEntry.isDirectory()) continue;
            string = zipEntry.getName();
            n = string.lastIndexOf(47, string.length() - 2);
            if (n == -1) {
                string = null;
                hDataNode5 = hDataNode;
            } else {
                string = string.substring(0, n);
            }
            if (string != null && !string.equals(string2)) {
                object = AddDiskDialog.splitPath(string);
                hDataNode5 = hDataNode;
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    hDataNode3 = this.database.findNode(hDataNode5, (String)object[n2]);
                    if (hDataNode3 == null) {
                        hDataNode2 = hDataNode5;
                        hDataNode5 = new HDataNode();
                        hDataNode5.fileName = object[n2];
                        hDataNode5.type = (byte)100;
                        hDataNode5.length = 0L;
                        hDataNode5.dateModified = System.currentTimeMillis();
                        this.database.write(hDataNode2, hDataNode5);
                        hDataNode2 = null;
                    } else {
                        hDataNode5 = hDataNode3;
                    }
                    ++n2;
                }
            }
            hDataNode4.copyFrom(zipEntry);
            object = this.database.findNode(hDataNode5, hDataNode4.fileName);
            if (object != null) {
                HDataNode hDataNode6 = (HDataNode)((HDataNode)object).clone();
                ((HDataNode)object).length = hDataNode4.length;
                ((HDataNode)object).dateModified = hDataNode4.dateModified;
                this.database.update(hDataNode6, (HDataNode)object);
            } else {
                this.database.write(hDataNode5, hDataNode4);
            }
            string2 = string;
        }
        hDataNode5 = hDataNode;
        enumeration = zipFile.entries();
        string2 = null;
        while (enumeration.hasMoreElements() && thread == this.addDiskThread) {
            zipEntry = enumeration.nextElement();
            hDataNode4 = new HDataNode();
            if (zipEntry.isDirectory()) continue;
            string = zipEntry.getName();
            n = string.lastIndexOf(47);
            if (n == -1) {
                string = null;
                hDataNode5 = hDataNode;
            } else {
                string = string.substring(0, n);
            }
            if (string != null && !string.equals(string2)) {
                object = AddDiskDialog.splitPath(string);
                hDataNode5 = hDataNode;
                int n3 = 0;
                while (n3 < ((Object)object).length) {
                    hDataNode3 = this.database.findNode(hDataNode5, (String)object[n3]);
                    if (hDataNode3 == null) {
                        hDataNode2 = hDataNode5;
                        hDataNode5 = new HDataNode();
                        hDataNode5.fileName = object[n3];
                        hDataNode5.type = (byte)100;
                        hDataNode5.length = 0L;
                        hDataNode5.dateModified = System.currentTimeMillis();
                        this.database.write(hDataNode2, hDataNode5);
                        hDataNode2 = null;
                    } else {
                        hDataNode5 = hDataNode3;
                    }
                    ++n3;
                }
            }
            hDataNode4.copyFrom(zipEntry);
            this.database.write(hDataNode5, hDataNode4);
            string2 = string;
        }
    }

    public void run() {
        try {
            Thread thread = Thread.currentThread();
            this.updateStat(this.addDirectory.getPath());
            this.addFiles(this.addDiskToNode, this.scanOptions, this.addDirectory, thread);
        }
        catch (IOException iOException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AddDiskDialog.this.status.setText("");
                    AddDiskDialog.this.ok.setEnabled(true);
                    JOptionPane.showMessageDialog(AddDiskDialog.this.mainFrame, "Error: Could not add the complete Disk Volume. Database corrupted?", "Error", 0);
                    AddDiskDialog.this.dispose();
                    AddDiskDialog.this.mainFrame.requestFocus();
                }
            });
        }
        if (this.addDiskThread != null) {
            this.success = true;
            this.addDiskThread = null;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AddDiskDialog.this.status.setText("");
                    AddDiskDialog.this.ok.setEnabled(true);
                    ((Hashtable)AddDiskDialog.this.options).put("disk.add", AddDiskDialog.this.rootDir.getText());
                    ((Hashtable)AddDiskDialog.this.options).put("disk.desc", AddDiskDialog.this.desc.getText());
                    ((Hashtable)AddDiskDialog.this.options).put("disk.dozip", String.valueOf(AddDiskDialog.this.doZipButton.isSelected()));
                    ((Hashtable)AddDiskDialog.this.options).put("disk.doid3tag", String.valueOf(AddDiskDialog.this.doID3TagButton.isSelected()));
                    ((Hashtable)AddDiskDialog.this.options).put("disk.dogifjpg", String.valueOf(AddDiskDialog.this.doGIFJPGButton.isSelected()));
                    AddDiskDialog.this.dispose();
                    DiskIndexer.saveProperties();
                    AddDiskDialog.this.mainFrame.requestFocus();
                }
            });
        } else {
            try {
                if (this.addDiskToNode != null) {
                    this.database.remove(this.addDiskToNode);
                }
                this.addDiskToNode = null;
            }
            catch (IOException iOException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(AddDiskDialog.this.mainFrame, "Database corrupted. Could not Delete all nodes added.", "Error", 0);
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AddDiskDialog.this.status.setText("");
                    AddDiskDialog.this.ok.setEnabled(true);
                }
            });
        }
    }

    public static HDataNode showAutomaticDialog(JFrame jFrame, DynamicTreeNode dynamicTreeNode, HDatabase hDatabase, String string, String string2, boolean[] blArray) {
        AddDiskDialog addDiskDialog = new AddDiskDialog(jFrame, dynamicTreeNode, hDatabase, new Properties());
        addDiskDialog.rootDir.setText(string);
        addDiskDialog.desc.setText(string2);
        if (blArray != null) {
            addDiskDialog.doZipButton.setSelected(blArray[0]);
            addDiskDialog.doID3TagButton.setSelected(blArray[1]);
            addDiskDialog.doGIFJPGButton.setSelected(blArray[2]);
            addDiskDialog.scanOptions[0] = blArray[0];
            addDiskDialog.scanOptions[1] = blArray[1];
            addDiskDialog.scanOptions[2] = blArray[2];
        }
        addDiskDialog.ok.setEnabled(false);
        addDiskDialog.cancel.setEnabled(true);
        addDiskDialog.addNewDisk();
        ((Component)addDiskDialog).setVisible(true);
        return addDiskDialog.addDiskToNode;
    }

    public static HDataNode showDialog(JFrame jFrame, DynamicTreeNode dynamicTreeNode, HDatabase hDatabase, Properties properties) {
        AddDiskDialog addDiskDialog = new AddDiskDialog(jFrame, dynamicTreeNode, hDatabase, properties);
        ((Component)addDiskDialog).setVisible(true);
        return addDiskDialog.addDiskToNode;
    }

    public static String[] splitPath(String string) {
        Vector<String> vector = new Vector<String>(10);
        int n = string.indexOf(47);
        int n2 = -1;
        while (n != -1) {
            vector.addElement(string.substring(n2 + 1, n));
            n2 = n;
            n = string.indexOf(47, n2 + 1);
        }
        vector.addElement(string.substring(n2 + 1));
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void updateStat(String string) {
        this.updateStatus.path = string;
        SwingUtilities.invokeLater(this.updateStatus);
    }

    class UpdateStatus
    implements Runnable {
        String path = null;

        UpdateStatus() {
        }

        public void run() {
            AddDiskDialog.this.status.setText("Adding " + this.path);
        }
    }
}

