/*
 * Decompiled with CFR 0.152.
 */
package com.sfs._102.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;

public class ImageButton
extends Panel {
    Image image;
    boolean Border = true;
    boolean showMouseOver = false;
    Insets insets = new Insets(3, 3, 3, 3);
    boolean pressed = false;
    boolean mouseOver = false;

    public ImageButton(Image image) {
        this.image = image;
        this.setForeground(Color.gray);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        Dimension i = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        if (this.Border) {
            g.setColor(this.pressed ? this.getForeground().darker() : this.getForeground().brighter().brighter());
            g.drawLine(0, 0, d.width - 1, 0);
            g.drawLine(0, 0, 0, d.height - 1);
            g.setColor(this.pressed ? this.getForeground().brighter().brighter() : this.getForeground().darker());
            g.drawLine(d.width - 1, 0, d.width - 1, d.height - 1);
            g.drawLine(0, d.height - 1, d.width - 1, d.height - 1);
        } else if (this.showMouseOver && this.mouseOver) {
            g.setColor(this.pressed ? this.getForeground().darker() : this.getForeground().brighter().brighter());
            g.drawLine(0, 0, d.width - 1, 0);
            g.drawLine(0, 0, 0, d.height - 1);
            g.setColor(this.pressed ? this.getForeground().brighter().brighter() : this.getForeground().darker());
            g.drawLine(d.width - 1, 0, d.width - 1, d.height - 1);
            g.drawLine(0, d.height - 1, d.width - 1, d.height - 1);
        }
        g.drawImage(this.image, (d.width - i.width) / 2 + (this.pressed ? 1 : 0), (d.height - i.height) / 2 + (this.pressed ? 1 : 0), this);
    }

    public void setBorder(boolean b) {
        this.Border = b;
        this.insets = b || this.showMouseOver ? new Insets(3, 3, 3, 3) : new Insets(1, 1, 1, 1);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        return new Dimension(this.image.getWidth(this) + this.insets.left + this.insets.right, this.image.getHeight(this) + this.insets.top + this.insets.bottom);
    }

    public void setShowMouseOver(boolean b) {
        this.showMouseOver = b;
        this.insets = this.Border || this.showMouseOver ? new Insets(3, 3, 3, 3) : new Insets(1, 1, 1, 1);
    }

    public Insets insets() {
        return this.insets;
    }

    public boolean handleEvent(Event e) {
        if (e.id == 501) {
            this.pressed = true;
            this.postEvent(new Event(this, 1001, this));
            this.repaint();
            return true;
        }
        if (e.id == 504) {
            this.mouseOver = true;
            this.repaint();
            return false;
        }
        if (e.id == 503) {
            this.mouseOver = true;
            this.repaint();
            return true;
        }
        if (e.id == 505 || e.id == 502) {
            this.mouseOver = false;
            this.pressed = false;
            this.repaint();
            return false;
        }
        return super.handleEvent(e);
    }
}

