/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.Vector;

class TablePanel
extends Canvas {
    String[] names;
    Vector[] columns;
    float[] sizes;
    private static Font fnames = new Font("SansSerif", 1, 12);
    private static Font fcolumns = new Font("SansSerif", 0, 12);
    private FontMetrics metrics;
    private int boxWidth;
    private int boxFontOffset;
    private Color headbackcolor = Color.gray;
    private Color headcolor = Color.black;
    private Color linecolor = Color.black;
    private Color textcolor = Color.black;
    private Color selectedbackcolor = Color.yellow;
    private Color selectedcolor = Color.black;
    int tablepos;
    int selected = -1;
    SimpleTable st;
    TableHandler handler;

    public TablePanel(String[] stringArray, float[] fArray, SimpleTable simpleTable) {
        this.st = simpleTable;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(fnames);
        this.boxWidth = 3 + fontMetrics.getHeight() + 3;
        this.boxFontOffset = 3 + fontMetrics.getLeading() + fontMetrics.getAscent();
        this.names = stringArray;
        this.sizes = fArray;
        this.columns = new Vector[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.columns[n] = new Vector();
            ++n;
        }
    }

    public int max() {
        return this.columns[0].size();
    }

    public int position() {
        return this.tablepos;
    }

    public int getSelected() {
        if (this.selected < 0 || this.columns[0].size() - 1 - this.selected < 0) {
            return -1;
        }
        return this.selected;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.columns.length) {
            this.columns[n].removeAllElements();
            ++n;
        }
    }

    public int getRowCount() {
        return this.columns[0].size();
    }

    public synchronized void delete(int n) {
        int n2 = 0;
        while (n2 < this.columns.length) {
            this.columns[n2].removeElementAt(n);
            ++n2;
        }
    }

    public void setPos(int n) {
        this.tablepos = n;
        if (this.tablepos > this.columns[0].size() - 1) {
            this.tablepos = this.columns[0].size() - 1;
        }
    }

    public int current() {
        int n = this.size().height;
        return n / this.boxWidth - 1;
    }

    public void setColumns(Vector[] vectorArray) {
        int n = 0;
        while (n < vectorArray.length) {
            this.columns[n] = vectorArray[n];
            ++n;
        }
    }

    public Dimension preferredSize() {
        return new Dimension(400, 100);
    }

    public Dimension minimumSize() {
        return new Dimension(100, 100);
    }

    public synchronized void addRow(Vector vector) {
        int n = 0;
        while (n < this.columns.length) {
            this.columns[n].addElement(vector.elementAt(n));
            ++n;
        }
    }

    public synchronized void addRow(String[] stringArray) {
        int n = 0;
        while (n < this.columns.length) {
            this.columns[n].addElement(stringArray[n]);
            ++n;
        }
    }

    public synchronized void setRow(int n, String[] stringArray) {
        int n2 = 0;
        while (n2 < this.columns.length) {
            this.columns[n2].setElementAt(stringArray[n2], n);
            ++n2;
        }
    }

    public synchronized String[] getRow(int n) {
        String[] stringArray = new String[this.columns.length];
        int n2 = 0;
        while (n2 < this.columns.length) {
            stringArray[n2] = this.columns[n2].elementAt(n).toString();
            ++n2;
        }
        return stringArray;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        if (dimension.height - this.boxWidth >= this.max() * this.boxWidth) {
            this.tablepos = 0;
        }
        graphics.setColor(this.headbackcolor);
        graphics.fillRect(0, 0, dimension.width, this.boxWidth);
        graphics.setColor(this.headcolor);
        graphics.setFont(fnames);
        int n = 3;
        int n2 = 0;
        while (n2 < this.names.length) {
            graphics.drawString(this.names[n2], n, this.boxFontOffset);
            n = (int)((float)n + (float)dimension.width * this.sizes[n2]);
            ++n2;
        }
        graphics.setFont(fcolumns);
        n = 3;
        int n3 = 0;
        while (n3 < this.columns.length) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(n - 3, this.boxWidth, (int)((float)dimension.width * this.sizes[n3]) + 1, dimension.height - this.boxWidth);
            graphics.setColor(this.textcolor);
            int n4 = this.tablepos;
            while (n4 < this.columns[n3].size()) {
                int n5 = this.boxFontOffset + this.boxWidth + this.boxWidth * (n4 - this.tablepos);
                graphics.drawString(this.columns[n3].elementAt(n4).toString(), n, n5);
                ++n4;
            }
            n = (int)((float)n + (float)dimension.width * this.sizes[n3]);
            ++n3;
        }
        if (this.selected >= this.tablepos && this.selected < this.columns[0].size()) {
            graphics.setColor(this.selectedcolor);
            graphics.setXORMode(this.selectedbackcolor);
            graphics.fillRect(0, (this.selected - this.tablepos + 1) * this.boxWidth, dimension.width, this.boxWidth);
        }
    }

    public void setHandler(TableHandler tableHandler) {
        this.handler = tableHandler;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 501) {
            if (event.y < this.boxWidth) {
                return true;
            }
            int n = this.tablepos + event.y / this.boxWidth - 1;
            if (n >= this.columns[0].size()) {
                n = -1;
            }
            this.selected = n;
            this.repaint();
            if (this.selected > -1 && this.handler != null) {
                this.handler.handleTable(this.st, this.selected, this.getRow(this.selected));
            }
        }
        return super.handleEvent(event);
    }
}

