/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Scrollbar;
import java.util.Vector;

public class SimpleTable
extends BPanel {
    TablePanel table;
    Scrollbar scroll = new Scrollbar(1);

    SimpleTable(String[] stringArray, float[] fArray) {
        super(new Insets(2, 2, 2, 2));
        this.table = new TablePanel(stringArray, fArray, this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.table);
        this.scroll.setValues(0, 0, 0, 0);
        this.add("East", this.scroll);
    }

    public int getSelected() {
        return this.table.getSelected();
    }

    public void delete(int n) {
        this.table.delete(n);
    }

    public int getTableSize() {
        return this.table.max();
    }

    public void setColumns(Vector[] vectorArray) {
        this.table.setColumns(vectorArray);
        this.scroll.setValues(0, this.table.current(), 0, this.table.max() - 1);
        this.repaint();
    }

    public void clear() {
        this.table.clear();
        this.scroll.setValues(this.table.position(), 0, 0, this.table.max() - 1);
        this.repaint();
    }

    public void repaint() {
        super.repaint(100L);
        this.table.repaint(100L);
    }

    public void setHandler(TableHandler tableHandler) {
        this.table.setHandler(tableHandler);
    }

    public boolean handleEvent(Event event) {
        if ((event.id == 602 || event.id == 601 || event.id == 605 || event.id == 603 || event.id == 604) && event.target == this.scroll) {
            this.table.setPos(this.scroll.getValue());
            this.repaint();
        }
        return super.handleEvent(event);
    }

    public void addRow(String[] stringArray) {
        this.table.addRow(stringArray);
        this.scroll.setValues(this.table.position(), 1, 0, this.table.max() - 1);
        this.scroll.setValues(0, this.table.current(), 0, this.table.max() - 1);
        this.repaint();
    }

    public void setRow(int n, String[] stringArray) {
        this.table.setRow(n, stringArray);
        this.repaint();
    }

    public String[] getRow(int n) {
        return this.table.getRow(n);
    }

    public static void main(String[] stringArray) {
        Vector[] vectorArray = new Vector[2];
        vectorArray[1] = new Vector();
        vectorArray[0] = new Vector();
        int n = 0;
        while (n < 10) {
            vectorArray[0].addElement("One: " + n);
            vectorArray[1].addElement("Two: " + n);
            ++n;
        }
        String[] stringArray2 = new String[]{"one", "two"};
        float[] fArray = new float[]{0.5f, 0.5f};
        SimpleTable simpleTable = new SimpleTable(stringArray2, fArray);
        simpleTable.setColumns(vectorArray);
        Frame frame = new Frame();
        frame.setLayout(new BorderLayout());
        frame.add("Center", simpleTable);
        frame.pack();
        frame.show();
    }
}

