/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.database;

import com._17od.upm.database.AccountInformation;
import com._17od.upm.database.DatabaseOptions;
import com._17od.upm.database.Revision;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class PasswordDatabase {
    private File databaseFile;
    private Revision revision;
    private DatabaseOptions dbOptions;
    private HashMap accounts;

    public PasswordDatabase(Revision revision, DatabaseOptions dbOptions, HashMap accounts, File databaseFile) {
        this.revision = revision;
        this.dbOptions = dbOptions;
        this.accounts = accounts;
        this.databaseFile = databaseFile;
    }

    public PasswordDatabase(File dbFile) {
        this.revision = new Revision();
        this.dbOptions = new DatabaseOptions();
        this.accounts = new HashMap();
        this.databaseFile = dbFile;
    }

    public void addAccount(AccountInformation ai) {
        this.accounts.put(ai.getAccountName(), ai);
    }

    public void deleteAccount(String accountName) {
        this.accounts.remove(accountName);
    }

    public AccountInformation getAccount(String name) {
        return (AccountInformation)this.accounts.get(name);
    }

    public ArrayList getAccounts() {
        return new ArrayList(this.accounts.values());
    }

    public HashMap getAccountsHash() {
        return this.accounts;
    }

    public File getDatabaseFile() {
        return this.databaseFile;
    }

    public DatabaseOptions getDbOptions() {
        return this.dbOptions;
    }

    public Revision getRevisionObj() {
        return this.revision;
    }

    public int getRevision() {
        return this.revision.getRevision();
    }
}

