/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.crypto;

import com._17od.upm.crypto.CryptoException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;

public class EncryptionService {
    private static final String randomAlgorithm = "SHA1PRNG";
    public static final int SALT_LENGTH = 8;
    private byte[] salt;
    private BufferedBlockCipher encryptCipher;
    private BufferedBlockCipher decryptCipher;

    public EncryptionService(char[] password) throws CryptoException {
        try {
            this.salt = this.generateSalt();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        this.initCipher(password);
    }

    public EncryptionService(char[] password, byte[] salt) {
        this.salt = salt;
        this.initCipher(password);
    }

    public void initCipher(char[] password) {
        PKCS12ParametersGenerator keyGenerator = new PKCS12ParametersGenerator((Digest)new SHA256Digest());
        keyGenerator.init(PKCS12ParametersGenerator.PKCS12PasswordToBytes((char[])password), this.salt, 20);
        CipherParameters keyParams = keyGenerator.generateDerivedParameters(256, 128);
        this.encryptCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)new PKCS7Padding());
        this.encryptCipher.init(true, keyParams);
        this.decryptCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)new PKCS7Padding());
        this.decryptCipher.init(false, keyParams);
    }

    private byte[] generateSalt() throws NoSuchAlgorithmException {
        SecureRandom saltGen = SecureRandom.getInstance(randomAlgorithm);
        byte[] pSalt = new byte[8];
        saltGen.nextBytes(pSalt);
        return pSalt;
    }

    public byte[] encrypt(byte[] plainText) throws CryptoException {
        byte[] encryptedBytes = new byte[this.encryptCipher.getOutputSize(plainText.length)];
        int outputLength = this.encryptCipher.processBytes(plainText, 0, plainText.length, encryptedBytes, 0);
        try {
            outputLength += this.encryptCipher.doFinal(encryptedBytes, outputLength);
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException((Exception)((Object)e));
        }
        byte[] results = new byte[outputLength];
        System.arraycopy(encryptedBytes, 0, results, 0, outputLength);
        return results;
    }

    public byte[] decrypt(byte[] encryptedBytes) throws CryptoException {
        byte[] decryptedBytes = new byte[this.decryptCipher.getOutputSize(encryptedBytes.length)];
        int outputLength = this.decryptCipher.processBytes(encryptedBytes, 0, encryptedBytes.length, decryptedBytes, 0);
        try {
            outputLength += this.decryptCipher.doFinal(decryptedBytes, outputLength);
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException((Exception)((Object)e));
        }
        byte[] results = new byte[outputLength];
        System.arraycopy(decryptedBytes, 0, results, 0, outputLength);
        return results;
    }

    public byte[] getSalt() {
        return this.salt;
    }
}

