/*
 * Decompiled with CFR 0.152.
 */
package shared.xml;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import shared.xml.JXmlNodeIndex;

public final class JXmlHelper {
    private JXmlHelper() {
    }

    public static Node findNextNode(String name, NodeList list) {
        return JXmlHelper.findNextNode(name, list, null);
    }

    public static Node findNextNode(String name, NodeList list, JXmlNodeIndex index) {
        int i;
        int anzahl = list.getLength();
        int n = i = index != null ? index.getIndex() : 0;
        while (i < anzahl) {
            Node node = list.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals(name)) {
                if (index != null) {
                    index.setIndex(i + 1);
                }
                return node;
            }
            ++i;
        }
        return null;
    }

    public static String getNodeText(Node node) {
        return node != null && (node = node.getFirstChild()) != null && node.getNodeType() == 3 ? node.getNodeValue() : "";
    }

    public static String getNodeTextStrict(Node node) {
        return node != null && (node = node.getFirstChild()) != null && node.getNodeType() == 3 ? node.getNodeValue() : null;
    }

    public static String getAttribute(Node node, String key) {
        NamedNodeMap map = node.getAttributes();
        return map != null ? JXmlHelper.getNodeText(map.getNamedItem(key)) : null;
    }

    public static Text createNewLineTab(Document doc, int tabCount) {
        String nlStr = "\n";
        String tabStr = "\t";
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(nlStr);
        while (tabCount-- > 0) {
            strBuilder.append(tabStr);
        }
        return doc.createTextNode(strBuilder.toString());
    }
}

