/*
 * Decompiled with CFR 0.152.
 */
package shared.settings;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import shared.swing.JSwingHelper;

public abstract class JSettingsHelper {
    private static final String DEBUG = "Debug";
    private static final String NOBOLDFONT = "NoBoldFont";
    private static final String LOCALE = "Locale";
    private static final String LOOKANDFEEL = "LookAndFeel";
    private static final String RESBUNDLEFILE = "ResBundleFile";
    private static final String CHECKUPDATE = "CheckUpdates";
    private static final String VERSION = "Version";
    private static final String DEF_DEBUG = "false";
    private static final String DEF_NOBOLDFONT = "true";
    private static final String DEF_LOCALE = "";
    private static final String DEF_CHECKUPDATE = "true";
    private static final String DEF_VERSION = "";
    protected boolean m_bDebug;
    protected boolean m_bNoBoldFont;
    protected String m_locale;
    protected String m_lookAndFeel;
    protected String m_resBundleFile;
    protected String m_version;
    protected boolean m_bInitSwing;
    protected boolean m_bCheckUpdate;
    protected ResourceBundle m_resBundle;

    public JSettingsHelper(boolean bInitSwing) {
        this.m_bInitSwing = bInitSwing;
        if (this.m_bInitSwing) {
            JSwingHelper.setAnitAliasing();
        }
    }

    protected abstract void doLoad(Properties var1);

    protected abstract void doSave(Properties var1);

    protected abstract String getComment();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDummy(String fileName) {
        Properties prop = new Properties();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            prop.store(out, this.getComment());
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String fileName, String version) {
        FileInputStream in = null;
        File file = new File(fileName);
        if (!file.exists()) {
            this.createDummy(fileName);
        }
        if (file.canRead()) {
            try {
                in = new FileInputStream(file);
                Properties prop = new Properties();
                prop.load(in);
                this.m_bDebug = new Boolean(prop.getProperty(DEBUG, DEF_DEBUG));
                this.m_bNoBoldFont = new Boolean(prop.getProperty(NOBOLDFONT, "true"));
                this.m_locale = prop.getProperty(LOCALE, "");
                this.m_lookAndFeel = prop.getProperty(LOOKANDFEEL, UIManager.getCrossPlatformLookAndFeelClassName());
                this.m_resBundleFile = prop.getProperty(RESBUNDLEFILE, "");
                this.m_bCheckUpdate = new Boolean(prop.getProperty(CHECKUPDATE, "true"));
                this.m_version = prop.getProperty(VERSION, "");
                if (this.getLocale().length() > 0) {
                    Locale.setDefault(new Locale(this.getLocale()));
                }
                if (this.m_bInitSwing && this.isNoBoldFont()) {
                    JSwingHelper.unBoldAllFonts();
                }
                this.doLoad(prop);
                this.m_version = version;
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String fileName) {
        Properties prop = new Properties();
        prop.setProperty(DEBUG, Boolean.toString(this.m_bDebug));
        prop.setProperty(NOBOLDFONT, Boolean.toString(this.m_bNoBoldFont));
        prop.setProperty(LOCALE, this.m_locale);
        prop.setProperty(LOOKANDFEEL, this.m_lookAndFeel);
        prop.setProperty(RESBUNDLEFILE, this.m_resBundleFile);
        prop.setProperty(CHECKUPDATE, Boolean.toString(this.m_bCheckUpdate));
        prop.setProperty(VERSION, this.m_version);
        this.doSave(prop);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            prop.store(out, this.getComment());
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public ResourceBundle getResBundle() {
        return this.m_resBundle;
    }

    public String getResBundleString(String key) {
        return this.m_resBundle.getString(key);
    }

    public String getResBundleString(String key, boolean bReplaceLFTAB) {
        String str = this.getResBundleString(key);
        if (bReplaceLFTAB) {
            str.replace("\\n", "\n");
            str.replace("\\t", "\t");
        }
        return str;
    }

    public void setIsDebug(boolean bDebug) {
        this.m_bDebug = bDebug;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    public boolean isNoBoldFont() {
        return this.m_bNoBoldFont;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public void setLocale(String locale) {
        this.m_locale = locale;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.m_lookAndFeel = lookAndFeel;
    }

    public String getLookAndFeel() {
        return this.m_lookAndFeel;
    }

    public boolean isCheckUpdate() {
        return this.m_bCheckUpdate;
    }

    public void setCheckUpdate(boolean bCheckUpdate) {
        this.m_bCheckUpdate = bCheckUpdate;
    }

    public String getResBundleFile() {
        return this.m_resBundleFile;
    }

    public boolean init(String resBundleName) {
        return this.init(resBundleName, null, null);
    }

    public boolean init(String resBundleName, String errMsgBoxCaption) {
        return this.init(resBundleName, errMsgBoxCaption, null);
    }

    public boolean init(String resBundleName, String errMsgBoxCaption, String errMsgBoxMessage) {
        block9: {
            if (this.m_bInitSwing) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            String str = null;
            if (this.m_resBundleFile != null) {
                str = this.getResBundleFile().trim();
            }
            try {
                if (str != null && str.length() > 0) {
                    final String resBundleFile = str + ".properties";
                    this.m_resBundle = ResourceBundle.getBundle(str, Locale.getDefault(), new ClassLoader(){

                        public InputStream getResourceAsStream(String name) {
                            if (name.equals(resBundleFile)) {
                                try {
                                    return new FileInputStream(name);
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    // empty catch block
                                }
                            }
                            return null;
                        }
                    });
                } else {
                    this.m_resBundle = ResourceBundle.getBundle(resBundleName);
                }
            }
            catch (MissingResourceException ex) {
                JOptionPane.showMessageDialog(null, errMsgBoxMessage != null ? errMsgBoxMessage : "No resource file was found!\nThe program will terminate now!", errMsgBoxCaption != null ? errMsgBoxCaption : "Error", 0);
            }
            if (this.m_bInitSwing) {
                try {
                    UIManager.setLookAndFeel(this.getLookAndFeel());
                }
                catch (Exception ex) {
                    if (!this.isDebug()) break block9;
                    System.err.print("Unable to set look and feel: " + this.getLookAndFeel() + " " + ex.toString());
                }
            }
        }
        return this.m_resBundle != null;
    }

    public static String toString(Dimension dim) {
        return String.format(Locale.US, "%d,%d", dim.width, dim.height);
    }

    public static Dimension fromString(String str, String defDim) {
        Dimension dim = null;
        String[] strArray = str.split(",");
        if (strArray.length > 1) {
            try {
                dim = new Dimension(Integer.parseInt(strArray[0]), Integer.parseInt(strArray[1]));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (dim == null && (strArray = defDim.split(",")).length > 1) {
            try {
                dim = new Dimension(Integer.parseInt(strArray[0]), Integer.parseInt(strArray[1]));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return dim;
    }
}

