/*
 * Decompiled with CFR 0.152.
 */
package shared.md5;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import shared.proglistener.ProgListener;
import shared.proglistener.ProgNotify;

public class JMD5Helper {
    private static final int BUF_SIZE = 4096;
    private byte[] m_byteArray;

    public byte[] getMD5() {
        return this.m_byteArray;
    }

    public String getMD5AsString() {
        String str = null;
        if (this.m_byteArray != null && this.m_byteArray.length == 16) {
            str = String.format("%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x", this.m_byteArray[0], this.m_byteArray[1], this.m_byteArray[2], this.m_byteArray[3], this.m_byteArray[4], this.m_byteArray[5], this.m_byteArray[6], this.m_byteArray[7], this.m_byteArray[8], this.m_byteArray[9], this.m_byteArray[10], this.m_byteArray[11], this.m_byteArray[12], this.m_byteArray[13], this.m_byteArray[14], this.m_byteArray[15]);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCalculateMD5(File file, ProgListener listener) {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            long size = file.length();
            MessageDigest mg = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[4096];
            int readed = -1;
            if (listener != null) {
                listener.notify(new ProgNotify(0, 0, new Long(size).toString()));
            }
            long total = size;
            boolean bAbort = false;
            while (size != 0L && (readed = inStream.read(buf)) >= 0) {
                mg.update(buf, 0, readed);
                assert (size <= (long)readed);
                if (listener == null || !(bAbort = listener.notify(new ProgNotify(1, (int)(1000L - (size -= (long)readed) * 1000L / total), null)))) continue;
            }
            if (bAbort) {
                if (listener != null) {
                    listener.notify(new ProgNotify(-2, 0, null));
                }
            } else {
                this.m_byteArray = mg.digest();
                String str = String.format("%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X", this.m_byteArray[0], this.m_byteArray[1], this.m_byteArray[2], this.m_byteArray[3], this.m_byteArray[4], this.m_byteArray[5], this.m_byteArray[6], this.m_byteArray[7], this.m_byteArray[8], this.m_byteArray[9], this.m_byteArray[10], this.m_byteArray[11], this.m_byteArray[12], this.m_byteArray[13], this.m_byteArray[14], this.m_byteArray[15]);
                if (listener != null) {
                    listener.notify(new ProgNotify(2, 1000, str));
                }
            }
        }
        catch (FileNotFoundException ex) {
            if (listener != null) {
                listener.notify(new ProgNotify(-1, 0, ex.toString()));
            }
        }
        catch (Exception ex) {
            if (listener != null) {
                listener.notify(new ProgNotify(-1, 0, ex.toString()));
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void calculateMD5(File file, ProgListener listener) {
        final File file_ = file;
        final ProgListener listener_ = listener;
        Thread thread = new Thread(){

            public void run() {
                JMD5Helper.this.doCalculateMD5(file_, listener_);
            }
        };
        thread.start();
    }

    public void calculateMD5(String fileName, ProgListener listener) {
        this.calculateMD5(new File(fileName), listener);
    }
}

