/*
 * Decompiled with CFR 0.152.
 */
package shared.ftp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shared.files.JPathHelper;
import shared.ftp.FtpNotify;
import shared.ftp.JFtpFile;
import shared.misc.JSleepHelper;
import shared.proglistener.ProgListener;
import shared.proglistener.ProgNotify;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFtp
implements ProgListener {
    public static final int REPLY_125 = 125;
    public static final int REPLY_150 = 150;
    public static final int REPLY_200 = 200;
    public static final int REPLY_214 = 214;
    public static final int REPLY_215 = 215;
    public static final int REPLY_220 = 220;
    public static final int REPLY_221 = 221;
    public static final int REPLY_226 = 226;
    public static final int REPLY_227 = 227;
    public static final int REPLY_230 = 230;
    public static final int REPLY_250 = 250;
    public static final int REPLY_257 = 257;
    public static final int REPLY_331 = 331;
    public static final int REPLY_332 = 332;
    public static final int REPLY_350 = 350;
    public static final char TYPE_ASCII = 'A';
    public static final char TYPE_IMAGE = 'I';
    public static final char MODE_STREAM = 'S';
    public static final char MODE_BLOCK = 'B';
    public static final char MODE_COMPRESSED = 'C';
    protected static boolean m_isDebug = false;
    protected boolean m_bOpen = false;
    protected int m_dataPort = 0;
    protected boolean m_bPassive = true;
    protected Socket m_comSocket;
    protected int m_waitTimeout = 50;
    protected int m_comConTimeOut = 30000;
    protected int m_comTimeOut = 10000;
    protected int m_dataConTimeout = 30000;
    protected int m_dataTimeout = 25000;
    protected int m_activeTimeOut = 25000;
    protected int m_bufSize = 1396;
    protected int m_socketUsedReties = 10;
    protected int m_socketUsedWait = 1000;
    protected boolean m_bWaitForReady = true;
    protected BufferedReader m_comBufReader;
    protected BufferedWriter m_comBuffWriter;
    protected String[] m_tempFileNames = null;
    protected ArrayList<String> m_messages = new ArrayList();
    protected ArrayList<String> m_lastListOutput = null;
    protected boolean m_bHasLastListOutputHardlinks;
    protected int m_lastReplyCode;
    protected Thread m_dataThread = null;
    protected final Object m_lock = new Object();

    public void setDebug(boolean bDebug) {
        m_isDebug = bDebug;
    }

    public ArrayList<String> getLastListOutput() {
        return this.m_lastListOutput;
    }

    public boolean getHasLastListOutputHardlinks() {
        return this.m_bHasLastListOutputHardlinks;
    }

    public ArrayList<String> getMessages() {
        return this.m_messages;
    }

    public boolean getWaitForReady() {
        return this.m_bWaitForReady;
    }

    public void setWaitForReady(boolean bWaitForReady) {
        this.m_bWaitForReady = bWaitForReady;
    }

    public boolean isOpen() {
        return this.m_bOpen && this.m_comSocket.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReady() {
        boolean flag = true;
        while (flag) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_dataThread == null) {
                    flag = false;
                } else if (m_isDebug) {
                    System.err.println("Waiting ....");
                }
            }
            if (!flag) break;
            JSleepHelper.sleep(300);
        }
    }

    public boolean isReady() {
        Thread.yield();
        boolean flag = false;
        if (this.isOpen()) {
            Thread.yield();
            if (this.m_dataThread == null) {
                flag = true;
            }
        }
        return flag;
    }

    public void setActive(int dataPort) {
        this.m_dataPort = dataPort;
        this.m_bPassive = false;
    }

    public void setPassive() {
        this.m_bPassive = true;
    }

    public boolean open(String server, String user, String pass) {
        return this.open(server, 21, user, pass, null, 'I', true, 0);
    }

    public boolean open(String server, String user, String pass, String account) {
        return this.open(server, 21, user, pass, account, 'I', true, 0);
    }

    public boolean open(String server, int port, String user, String pass) {
        return this.open(server, port, user, pass, null, 'I', true, 0);
    }

    public boolean open(String server, int port, String user, String pass, String account) {
        return this.open(server, port, user, pass, account, 'I', true, 0);
    }

    public boolean open(String server, String user, String pass, boolean bPassive) {
        return this.open(server, 21, user, pass, null, 'I', bPassive, 0);
    }

    public boolean open(String server, String user, String pass, String account, boolean bPassive) {
        return this.open(server, 21, user, pass, account, 'I', bPassive, 0);
    }

    public boolean open(String server, String user, String pass, boolean bPassive, int dataPort) {
        return this.open(server, 21, user, pass, null, 'I', bPassive, dataPort);
    }

    public boolean open(String server, String user, String pass, String account, boolean bPassive, int dataPort) {
        return this.open(server, 21, user, pass, account, 'I', bPassive, dataPort);
    }

    public boolean open(String server, int port, String user, String pass, boolean bPassive) {
        return this.open(server, port, user, pass, null, 'I', bPassive, 0);
    }

    public boolean open(String server, int port, String user, String pass, String account, boolean bPassive) {
        return this.open(server, port, user, pass, account, 'I', bPassive, 0);
    }

    public boolean open(String server, int port, String user, String pass, boolean bPassive, int dataPort) {
        return this.open(server, port, user, pass, null, 'I', bPassive, dataPort);
    }

    public boolean open(String server, int port, String user, String pass, String account, boolean bPassive, int dataPort) {
        return this.open(server, port, user, pass, account, 'I', bPassive, dataPort);
    }

    public boolean open(String server, int port, String user, String pass, String account, char dataType, boolean bPassive, int dataPort) {
        boolean flag;
        block14: {
            flag = false;
            if (!this.isOpen()) {
                try {
                    this.m_comSocket = new Socket();
                    this.m_comSocket.connect(new InetSocketAddress(server, port), this.m_comConTimeOut);
                    this.m_comBufReader = new BufferedReader(new InputStreamReader(this.m_comSocket.getInputStream()));
                    this.m_comBuffWriter = new BufferedWriter(new OutputStreamWriter(this.m_comSocket.getOutputStream()));
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 220 && this.doLogin(user, pass, account)) {
                        this.m_bOpen = true;
                        flag = this.setDataType(dataType);
                        if (bPassive) {
                            this.setPassive();
                        } else {
                            this.setActive(dataPort);
                        }
                    }
                }
                catch (UnknownHostException ex) {
                    if (m_isDebug) {
                        System.err.println("Unable to connect to '" + server + "'");
                    }
                }
                catch (NoRouteToHostException ex) {
                    if (m_isDebug) {
                        System.err.println("Unable to connect to '" + server + "'; route error");
                    }
                }
                catch (ConnectException ex) {
                    if (m_isDebug) {
                        System.err.println("Unable to find '" + server + "'");
                    }
                }
                catch (SocketTimeoutException ex) {
                    if (m_isDebug) {
                        System.err.println("Timeout during connecting to '" + server + "'");
                    }
                }
                catch (IOException ex) {
                    if (!m_isDebug) break block14;
                    System.err.println("Error during connect to '" + server + "'");
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("QUIT\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 221) {
                        this.m_comSocket.close();
                        this.m_bOpen = false;
                        flag = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    public boolean ping() {
        return this.noop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noop() {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("NOOP\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 200) {
                        flag = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentDirectory() {
        String str = null;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    Pattern pat;
                    Matcher m;
                    this.m_comBuffWriter.write("PWD\r\n");
                    this.m_comBuffWriter.flush();
                    String hstr = this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 257 && hstr != null && (m = (pat = Pattern.compile("^\\d{3}[ \t]+\"(.+)\".*")).matcher(hstr)).find()) {
                        str = m.group(1);
                        if (m_isDebug) {
                            System.err.println(str);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentDirectory(String str) {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("CWD " + str + "\r\n");
                    this.m_comBuffWriter.flush();
                    String hstr = this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250) {
                        flag = true;
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeToParentDirectory() {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("CDUP\r\n");
                    this.m_comBuffWriter.flush();
                    String hstr = this.getMessage(this.m_comTimeOut, 1);
                    if (this.m_lastReplyCode == 250) {
                        flag = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getStatus(String str) {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("STAT " + str + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250) {
                        flag = true;
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean system() {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("SYST\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 215) {
                        flag = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean site(String str) {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("SITE " + str + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 200) {
                        flag = true;
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean help(String str) {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("HELP " + str + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 214) {
                        flag = true;
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    protected boolean abortInternal() {
        boolean flag = false;
        try {
            this.m_comBuffWriter.write("ABOR\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 226) {
                flag = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort() {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                flag = this.abortInternal();
            }
        }
        return flag;
    }

    protected boolean renameInternal(String source, String target) {
        boolean flag = false;
        try {
            this.m_comBuffWriter.write("RNFR " + source + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 350) {
                this.m_comBuffWriter.write("RNTO " + target + "\r\n");
                this.m_comBuffWriter.flush();
                this.getMessage(this.m_comTimeOut);
                if (this.m_lastReplyCode == 250) {
                    flag = true;
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String source, String target) {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                flag = this.renameInternal(source, target);
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String str) {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("DELE " + str + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250) {
                        flag = true;
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean makeDirectory(String str) {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("MKD " + str + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 257) {
                        flag = true;
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDirectory(String str) {
        boolean flag = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("RMD " + str + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250) {
                        flag = true;
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listDirectory(String str) {
        Object object = this.m_lock;
        synchronized (object) {
        }
        boolean flag = false;
        if (this.isReady()) {
            Socket socket = null;
            ServerSocket serverSocket = null;
            if (this.m_bPassive) {
                socket = this.doPassive();
            } else {
                serverSocket = this.doActive();
            }
            if (this.m_bPassive && socket != null || !this.m_bPassive && serverSocket != null) {
                final Socket _socket = socket;
                final ServerSocket _serverSocket = serverSocket;
                final JFtp ftp = this;
                int waitTimeout = this.m_waitTimeout;
                final boolean[] bServerSocketWaits = new boolean[]{false};
                this.m_dataThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = ftp.m_lock;
                        synchronized (object) {
                            ArrayList<String> results = new ArrayList<String>();
                            boolean bAbort = false;
                            Socket socket = _socket;
                            boolean flag = false;
                            try {
                                String str;
                                if (_serverSocket != null) {
                                    bServerSocketWaits[0] = true;
                                    socket = JFtp.this.activeWaitForConnection(_serverSocket);
                                }
                                ftp.notify(new FtpNotify(1, 0));
                                BufferedReader bufReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                while (!this.isInterrupted() && !bAbort && (str = bufReader.readLine()) != null) {
                                    results.add(str);
                                    if (ftp.notify(new FtpNotify<String>(1, 1, str))) continue;
                                    ftp.abort();
                                    bAbort = true;
                                }
                                flag = true;
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            JFtp.this.closeSocket(socket);
                            if (flag) {
                                ftp.notify(new FtpNotify(1, bAbort ? -2 : 2, results));
                            } else {
                                ftp.notify(new FtpNotify(1, -1));
                            }
                        }
                    }
                };
                if (!this.m_bPassive) {
                    this.m_dataThread.start();
                    int count = 100;
                    while (!bServerSocketWaits[0] && count-- > 0) {
                        JSleepHelper.sleep(waitTimeout);
                    }
                    Thread.yield();
                }
                try {
                    flag = false;
                    this.m_comBuffWriter.write("LIST -al " + (str != null ? str : ".") + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250 || this.m_lastReplyCode == 125 || this.m_lastReplyCode == 150) {
                        if (this.m_bPassive) {
                            this.m_dataThread.start();
                        }
                        flag = true;
                    }
                    if (!flag) {
                        if (!this.m_bPassive) {
                            this.m_dataThread.interrupt();
                        }
                        this.closeSocket(socket);
                        this.closeSocket(serverSocket);
                    }
                }
                catch (IOException ex) {
                    if (!this.m_bPassive) {
                        this.m_dataThread.interrupt();
                    }
                    this.closeSocket(socket);
                    this.closeSocket(serverSocket);
                }
            }
        }
        if (!flag) {
            this.m_dataThread = null;
        } else if (this.m_bWaitForReady) {
            this.waitForReady();
        }
        return flag;
    }

    public boolean getFile(String source, String target) {
        return this.getFile(source, target, false, 0L);
    }

    public boolean getFile(String source, String target, boolean bTemp) {
        return this.getFile(source, target, bTemp, 0L);
    }

    public boolean getFile(String source, String target, long startPos) {
        return this.getFile(source, target, false, startPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFile(String source, final String target, final boolean bTemp, final long startPos) {
        Object object = this.m_lock;
        synchronized (object) {
        }
        boolean flag = false;
        if (this.isReady()) {
            Socket socket = null;
            ServerSocket serverSocket = null;
            if (this.m_bPassive) {
                socket = this.doPassive();
            } else {
                serverSocket = this.doActive();
            }
            if (this.m_bPassive && socket != null || !this.m_bPassive && serverSocket != null) {
                final Socket _socket = socket;
                final ServerSocket _serverSocket = serverSocket;
                final JFtp ftp = this;
                int waitTimeout = this.m_waitTimeout;
                final boolean[] bServerSocketWaits = new boolean[]{false};
                this.m_dataThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = ftp.m_lock;
                        synchronized (object) {
                            FileOutputStream fileOutput = null;
                            long size = 0L;
                            boolean bAbort = false;
                            File tempFile = null;
                            Socket socket = _socket;
                            boolean flag = false;
                            try {
                                int readed;
                                if (_serverSocket != null) {
                                    bServerSocketWaits[0] = true;
                                    socket = JFtp.this.activeWaitForConnection(_serverSocket);
                                }
                                if (bTemp) {
                                    tempFile = File.createTempFile("ftp", "", new File(JPathHelper.getFolder(target)));
                                    fileOutput = new FileOutputStream(tempFile);
                                } else {
                                    File file = new File(target);
                                    if (file.exists() && startPos > 0L) {
                                        RandomAccessFile rf = new RandomAccessFile(file, "rw");
                                        if (rf.getFilePointer() > startPos) {
                                            rf.setLength(startPos);
                                        }
                                        rf.close();
                                        fileOutput = new FileOutputStream(target, true);
                                    }
                                    if (fileOutput == null) {
                                        fileOutput = new FileOutputStream(target);
                                    }
                                }
                                ftp.notify(new FtpNotify<String>(2, 0, bTemp ? tempFile.getPath() : target));
                                InputStream inputStream = socket.getInputStream();
                                byte[] buf = new byte[JFtp.this.m_bufSize];
                                while (!this.isInterrupted() && !bAbort && (readed = inputStream.read(buf)) > 0) {
                                    fileOutput.write(buf, 0, readed);
                                    size += (long)readed;
                                    if (ftp.notify(new FtpNotify<Long>(2, 1, new Long(readed)))) continue;
                                    ftp.abortInternal();
                                    bAbort = true;
                                }
                                flag = true;
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            JFtp.this.closeSocket(socket);
                            if (fileOutput != null) {
                                try {
                                    fileOutput.close();
                                }
                                catch (IOException ex) {
                                    // empty catch block
                                }
                            }
                            if (flag && !bAbort && tempFile != null) {
                                tempFile.renameTo(new File(target));
                            }
                            if (flag) {
                                ftp.notify(new FtpNotify<Long>(2, bAbort ? -2 : 2, new Long(size)));
                            } else {
                                ftp.notify(new FtpNotify<String>(2, -1, bTemp ? tempFile.getPath() : null));
                            }
                        }
                    }
                };
                try {
                    flag = false;
                    if (startPos > 0L) {
                        this.m_comBuffWriter.write("REST " + Long.toString(startPos) + "\r\n");
                        this.m_comBuffWriter.flush();
                        this.getMessage(this.m_comTimeOut);
                        if (this.m_lastReplyCode == 350) {
                            flag = true;
                        }
                    } else {
                        flag = true;
                    }
                    if (flag) {
                        if (!this.m_bPassive) {
                            this.m_dataThread.start();
                            int count = 100;
                            while (!bServerSocketWaits[0] && count-- > 0) {
                                JSleepHelper.sleep(waitTimeout);
                            }
                            Thread.yield();
                        }
                        flag = false;
                        this.m_comBuffWriter.write("RETR " + source + "\r\n");
                        this.m_comBuffWriter.flush();
                        this.getMessage(this.m_comTimeOut);
                        if (this.m_lastReplyCode == 150 || this.m_lastReplyCode == 125) {
                            if (this.m_bPassive) {
                                this.m_dataThread.start();
                            }
                            flag = true;
                        }
                    }
                    if (!flag) {
                        if (!this.m_bPassive) {
                            this.m_dataThread.interrupt();
                        }
                        this.closeSocket(socket);
                        this.closeSocket(serverSocket);
                    }
                }
                catch (IOException ex) {
                    if (!this.m_bPassive) {
                        this.m_dataThread.interrupt();
                    }
                    this.closeSocket(socket);
                    this.closeSocket(serverSocket);
                }
            }
        }
        if (!flag) {
            this.m_dataThread = null;
        } else if (this.m_bWaitForReady) {
            this.waitForReady();
        }
        return flag;
    }

    public boolean sendFile(String source, String target) {
        return this.sendFile(source, target, false, 0L);
    }

    public boolean sendFile(String source, String target, boolean bTemp) {
        return this.sendFile(source, target, bTemp, 0L);
    }

    public boolean sendFile(String source, String target, long startPos) {
        return this.sendFile(source, target, false, startPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFile(final String source, String target, final boolean bTemp, final long startPos) {
        Object object = this.m_lock;
        synchronized (object) {
        }
        this.m_tempFileNames = null;
        boolean flag = false;
        if (this.isReady()) {
            Socket socket = null;
            ServerSocket serverSocket = null;
            if (this.m_bPassive) {
                socket = this.doPassive();
            } else {
                serverSocket = this.doActive();
            }
            String[] tempFileNameArray = new String[1];
            if (this.m_bPassive && socket != null || !this.m_bPassive && serverSocket != null) {
                final Socket _socket = socket;
                final ServerSocket _serverSocket = serverSocket;
                final JFtp ftp = this;
                int waitTimeout = this.m_waitTimeout;
                final String _target = target;
                final boolean[] bServerSocketWaits = new boolean[]{false};
                this.m_dataThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = ftp.m_lock;
                        synchronized (object) {
                            boolean flag = false;
                            long size = 0L;
                            boolean bAbort = false;
                            FileInputStream fileInput = null;
                            Socket socket = _socket;
                            try {
                                int readed;
                                if (_serverSocket != null) {
                                    bServerSocketWaits[0] = true;
                                    socket = JFtp.this.activeWaitForConnection(_serverSocket);
                                }
                                fileInput = new FileInputStream(source);
                                if (startPos > 0L) {
                                    fileInput.skip(startPos);
                                }
                                ftp.notify(new FtpNotify<String>(3, 0, bTemp ? JFtp.this.m_tempFileNames[0] : _target));
                                OutputStream outputStream = socket.getOutputStream();
                                byte[] buf = new byte[JFtp.this.m_bufSize];
                                while (!bAbort && (readed = fileInput.read(buf)) > 0) {
                                    outputStream.write(buf, 0, readed);
                                    size += (long)readed;
                                    if (ftp.notify(new FtpNotify<Long>(3, 1, new Long(readed)))) continue;
                                    ftp.abort();
                                    bAbort = true;
                                }
                                flag = true;
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            try {
                                fileInput.close();
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            JFtp.this.closeSocket(socket);
                            if (flag) {
                                ftp.notify(new FtpNotify<Long>(3, bAbort ? -2 : 2, new Long(size)));
                            } else {
                                ftp.notify(new FtpNotify<Object>(3, -1, (bTemp ? JFtp.this.m_tempFileNames[0] : null)));
                            }
                        }
                    }
                };
                try {
                    if (startPos > 0L) {
                        this.m_comBuffWriter.write("REST " + Long.toString(startPos) + "\r\n");
                        this.m_comBuffWriter.flush();
                        this.getMessage(this.m_comTimeOut);
                        if (this.m_lastReplyCode == 350) {
                            flag = true;
                        }
                    } else {
                        flag = true;
                    }
                    if (flag) {
                        flag = false;
                        if (!this.m_bPassive) {
                            this.m_dataThread.start();
                            int count = 100;
                            while (!bServerSocketWaits[0] && count-- > 0) {
                                JSleepHelper.sleep(50);
                            }
                            Thread.yield();
                        }
                        if (bTemp) {
                            this.m_comBuffWriter.write("STOU \r\n");
                        } else {
                            this.m_comBuffWriter.write("STOR " + target + "\r\n");
                        }
                        this.m_comBuffWriter.flush();
                        String str = this.getMessage(this.m_comTimeOut);
                        if (this.m_lastReplyCode == 150) {
                            if (bTemp) {
                                Pattern pat = Pattern.compile("150[- ]FILE: (.+)");
                                Matcher m = pat.matcher(str);
                                if (m.find()) {
                                    this.m_tempFileNames = new String[2];
                                    this.m_tempFileNames[0] = m.group(1);
                                    this.m_tempFileNames[1] = target;
                                    flag = true;
                                }
                            } else {
                                flag = true;
                            }
                            if (this.m_bPassive && flag) {
                                this.m_dataThread.start();
                            }
                        }
                    }
                    if (!flag) {
                        if (this.m_bPassive) {
                            this.m_dataThread.interrupt();
                        }
                        this.closeSocket(socket);
                        this.closeSocket(serverSocket);
                    }
                }
                catch (IOException ex) {
                    if (this.m_bPassive) {
                        this.m_dataThread.interrupt();
                    }
                    this.closeSocket(socket);
                    this.closeSocket(serverSocket);
                }
            }
        }
        if (!flag) {
            this.m_dataThread = null;
        } else if (this.m_bWaitForReady) {
            this.waitForReady();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transferFile(String source, String target, JFtp ftp2, boolean bTemp) {
        boolean flag = false;
        if (!this.m_bPassive && ftp2.m_bPassive || this.m_bPassive && !ftp2.m_bPassive) {
            Object object = this.m_lock;
            synchronized (object) {
            }
            object = ftp2.m_lock;
            synchronized (object) {
            }
            try {
                if (this.isReady() && ftp2.isReady()) {
                    InetSocketAddress addr;
                    if (ftp2.m_bPassive) {
                        addr = ftp2.doPassiveSimple();
                        flag = this.doActiveSimple(addr);
                    } else {
                        addr = this.doPassiveSimple();
                        flag = ftp2.doActiveSimple(addr);
                    }
                    if (flag) {
                        flag = false;
                        if (bTemp) {
                            ftp2.m_comBuffWriter.write("STOU \r\n");
                        } else {
                            ftp2.m_comBuffWriter.write("STOR " + target + "\r\n");
                        }
                        ftp2.m_comBuffWriter.flush();
                        String str = ftp2.getMessage(this.m_comTimeOut);
                        if (ftp2.m_lastReplyCode == 150) {
                            if (bTemp) {
                                Pattern pat = Pattern.compile("150[- ]FILE: (.+)");
                                Matcher m = pat.matcher(str);
                                if (m.find()) {
                                    flag = true;
                                }
                            } else {
                                flag = true;
                            }
                            if (flag) {
                                flag = false;
                                this.m_comBuffWriter.write("RETR " + source + "\r\n");
                                this.m_comBuffWriter.flush();
                                this.getMessage(this.m_comTimeOut);
                                if (this.m_lastReplyCode == 150 || this.m_lastReplyCode == 125) {
                                    flag = true;
                                }
                            }
                            if (flag) {
                                flag = false;
                                this.notify(new FtpNotify(4, 0));
                                str = this.getMessage(0, 1);
                                String str2 = ftp2.getMessage(0, 1);
                                if (!(this.m_lastReplyCode != 150 && this.m_lastReplyCode != 125 || ftp2.m_lastReplyCode != 150 || bTemp)) {
                                    flag = true;
                                }
                                this.notify(new FtpNotify(4, flag ? 2 : -1));
                            }
                        }
                    }
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return flag;
    }

    protected Socket doPassive() {
        Socket socket = null;
        if (this.isReady()) {
            try {
                InetSocketAddress addr = this.doPassiveSimple();
                if (addr != null) {
                    socket = new Socket();
                    socket.connect(addr, this.m_dataConTimeout);
                    socket.setSoTimeout(this.m_dataTimeout);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return socket;
    }

    protected InetSocketAddress doPassiveSimple() {
        InetSocketAddress addr = null;
        if (this.isReady()) {
            try {
                Pattern pat;
                Matcher m;
                this.m_comBuffWriter.write("PASV\r\n");
                this.m_comBuffWriter.flush();
                String str = this.getMessage(this.m_comTimeOut);
                if (this.m_lastReplyCode == 227 && (m = (pat = Pattern.compile("\\d{3}.*\\((\\d{1,3}),(\\d{1,3}),(\\d{1,3}),(\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)")).matcher(str)).find()) {
                    addr = new InetSocketAddress(m.group(1) + "." + m.group(2) + "." + m.group(3) + "." + m.group(4), Integer.parseInt(m.group(5)) * 256 + Integer.parseInt(m.group(6)));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return addr;
    }

    protected Socket activeWaitForConnection(ServerSocket serverSocket) throws IOException {
        Socket socket = null;
        if (serverSocket != null) {
            socket = serverSocket.accept();
            socket.setSoTimeout(this.m_dataTimeout);
            this.closeSocket(serverSocket);
        }
        return socket;
    }

    protected ServerSocket doActive() {
        ServerSocket socket = null;
        int count = 0;
        try {
            InetSocketAddress addr = new InetSocketAddress("0.0.0.0", this.m_dataPort);
            while (socket == null && count++ < this.m_socketUsedReties) {
                try {
                    socket = this.doInternalActive(addr);
                }
                catch (BindException ex) {
                    JSleepHelper.sleep(this.m_socketUsedWait);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return socket;
    }

    protected ServerSocket doInternalActive(InetSocketAddress addr) throws IOException {
        ServerSocket socket = null;
        if (this.isReady()) {
            String str = addr.getAddress().getHostAddress();
            int port = addr.getPort();
            if (str.equals("0.0.0.0")) {
                str = this.m_comSocket.getLocalAddress().getHostAddress();
            }
            socket = new ServerSocket();
            socket.setReuseAddress(true);
            if (port > 0) {
                socket.bind(new InetSocketAddress("0.0.0.0", port));
            } else {
                socket.bind(null);
            }
            socket.setSoTimeout(this.m_activeTimeOut);
            port = socket.getLocalPort();
            str = str.replace('.', ',');
            str = str + ',';
            str = str + Integer.toString(port / 256);
            str = str + ',';
            str = str + Integer.toString(port % 256);
            this.m_comBuffWriter.write("PORT " + str + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode != 200) {
                socket.close();
                socket = null;
            }
        }
        return socket;
    }

    protected boolean doActiveSimple(InetSocketAddress addr) {
        boolean flag = false;
        if (addr != null && this.isReady()) {
            try {
                String str = addr.getAddress().getHostAddress();
                int port = addr.getPort();
                str = str.replace('.', ',');
                str = str + ',';
                str = str + Integer.toString(port / 256);
                str = str + ',';
                str = str + Integer.toString(port % 256);
                this.m_comBuffWriter.write("PORT " + str + "\r\n");
                this.m_comBuffWriter.flush();
                this.getMessage(this.m_comTimeOut);
                flag = true;
                if (this.m_lastReplyCode != 200) {
                    flag = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return flag;
    }

    protected boolean doLogin(String user, String pass, String account) {
        boolean flag = false;
        try {
            this.m_comBuffWriter.write("USER " + user + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 331) {
                this.m_comBuffWriter.write("PASS " + pass + "\r\n");
                this.m_comBuffWriter.flush();
                this.getMessage(this.m_comTimeOut);
                if (this.m_lastReplyCode == 230) {
                    flag = true;
                } else if (this.m_lastReplyCode == 332) {
                    this.m_comBuffWriter.write("ACCT " + account + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 230) {
                        flag = true;
                    }
                }
            } else if (this.m_lastReplyCode == 230) {
                flag = true;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return flag;
    }

    public boolean setDataType(char type) {
        boolean flag = false;
        try {
            this.m_comBuffWriter.write("TYPE " + type + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 200) {
                flag = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flag;
    }

    public boolean setTransferMode(char mode) {
        boolean flag = false;
        try {
            this.m_comBuffWriter.write("MODE " + mode + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 200) {
                flag = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flag;
    }

    protected String getMessage(int timeout) {
        return this.getMessage(timeout, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getMessage(int timeout, int lines) {
        String str = null;
        String hstr = null;
        try {
            this.m_comSocket.setSoTimeout(timeout);
            int count = lines > 0 ? lines : -1;
            Boolean bMultiLine = false;
            while (true) {
                int status;
                if (!bMultiLine.booleanValue() && count >= 0) {
                    if (count-- <= 0) return str;
                }
                if ((hstr = this.m_comBufReader.readLine()) == null) {
                    return str;
                }
                if (str == null) {
                    str = hstr;
                }
                if ((status = this.getReplyCode(hstr, bMultiLine)) > 0) {
                    if (bMultiLine.booleanValue() && status == this.m_lastReplyCode) {
                        bMultiLine = false;
                        count = 0;
                    } else {
                        this.m_lastReplyCode = status;
                    }
                } else if (status < 0) {
                    this.m_lastReplyCode = -status;
                    bMultiLine = true;
                }
                ArrayList<String> arrayList = this.m_messages;
                synchronized (arrayList) {
                    this.m_messages.add(hstr);
                    if (m_isDebug) {
                        System.err.println(hstr);
                    }
                }
            }
        }
        catch (SocketException ex) {
            return str;
        }
        catch (IOException ex) {
            // empty catch block
        }
        return str;
    }

    protected int getReplyCode(String str, Boolean bMultiline) {
        Pattern pat;
        Matcher m;
        int status = 0;
        if (str != null && (m = (pat = Pattern.compile("^(\\d{3})(-|\\s+).*")).matcher(str)).find()) {
            status = Integer.parseInt(m.group(1));
            if (m.group(2).equals("-")) {
                status = -status;
            }
        }
        return status;
    }

    @Override
    public boolean notify(ProgNotify progNotify) {
        boolean flag = true;
        boolean bTransferOk = false;
        FtpNotify ftpNotify = (FtpNotify)progNotify;
        if (ftpNotify.getReason() == 2) {
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 226) {
                bTransferOk = true;
            }
            this.m_dataThread = null;
        } else if (ftpNotify.getReason() == -2 || ftpNotify.getReason() == -1) {
            this.m_dataThread = null;
        }
        if (ftpNotify.getType() == 1) {
            if (ftpNotify.getReason() == 0) {
                if (m_isDebug) {
                    System.err.println("List start");
                }
            } else if (ftpNotify.getReason() == 1) {
                FtpNotify ftpNotify2 = ftpNotify;
                String fileName = (String)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("List :" + fileName);
                }
            } else if (ftpNotify.getReason() == 2) {
                FtpNotify ftpNotify2 = ftpNotify;
                ArrayList list = (ArrayList)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("List results:");
                    for (String str : list) {
                        System.err.println(str);
                        this.parseListLine(str);
                    }
                }
                this.m_lastListOutput = list;
            } else if (ftpNotify.getReason() == -1) {
                if (m_isDebug) {
                    System.err.println("List error");
                }
            } else if (ftpNotify.getReason() == -2) {
                FtpNotify ftpNotify2 = ftpNotify;
                ArrayList list = (ArrayList)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("List abort");
                    for (String str : list) {
                        System.err.println(str);
                    }
                }
            }
        } else if (ftpNotify.getType() == 2) {
            if (ftpNotify.getReason() == 0) {
                FtpNotify ftpNotify2 = ftpNotify;
                String fileName = (String)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("Retr start of '" + fileName + "'");
                }
            } else if (ftpNotify.getReason() == 1) {
                if (m_isDebug) {
                    System.err.println("Retr :" + ftpNotify.getData().toString());
                }
            } else if (ftpNotify.getReason() == 2) {
                FtpNotify ftpNotify2 = ftpNotify;
                Long fileSize = (Long)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("Retr end fileSize = " + fileSize);
                }
            } else if (ftpNotify.getReason() == -1) {
                FtpNotify ftpNotify2 = ftpNotify;
                String tempFileName = (String)ftpNotify2.getData();
                if (m_isDebug) {
                    if (tempFileName != null) {
                        System.err.println("Retr error tempfile = '" + tempFileName + "'");
                    } else {
                        System.err.println("Retr error");
                    }
                }
            } else if (ftpNotify.getReason() == -2) {
                FtpNotify ftpNotify2 = ftpNotify;
                Long fileSize = (Long)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("Retr abort fileSize = " + fileSize);
                }
            }
        } else if (ftpNotify.getType() == 3) {
            if (ftpNotify.getReason() == 0) {
                FtpNotify ftpNotify2 = ftpNotify;
                String fileName = (String)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("Stor start of '" + fileName + "'");
                }
            } else if (ftpNotify.getReason() == 1) {
                if (m_isDebug) {
                    System.err.println("Stor :" + ftpNotify.getData().toString());
                }
            } else if (ftpNotify.getReason() == 2) {
                if (this.m_tempFileNames != null) {
                    this.renameInternal(this.m_tempFileNames[0], this.m_tempFileNames[1]);
                }
                FtpNotify ftpNotify2 = ftpNotify;
                Long fileSize = (Long)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("Stor end fileSize = " + fileSize);
                }
            } else if (ftpNotify.getReason() == -1) {
                FtpNotify ftpNotify2 = ftpNotify;
                String tempFileName = (String)ftpNotify2.getData();
                if (m_isDebug) {
                    if (tempFileName != null) {
                        System.err.println("Stor error tempfile = '" + tempFileName + "'");
                    } else {
                        System.err.println("Stor error");
                    }
                }
            } else if (ftpNotify.getReason() == -2) {
                FtpNotify ftpNotify2 = ftpNotify;
                Long fileSize = (Long)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("Stor abort fileSize = " + fileSize);
                }
            }
        }
        return flag;
    }

    public JFtpFile parseListLine(String str) {
        Matcher m2;
        String month;
        JFtpFile ftpFile = null;
        Calendar cal = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        cal.set(14, 0);
        cal.set(13, 0);
        Pattern pat = Pattern.compile("([dl-])((?:[r-][w-][xst-]){3})\\s+(\\d+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+(\\d+)\\s+([a-zA-Z]{3})\\s+(\\d{1,2})\\s+(\\d{4}|\\d{2}:\\d{2})\\s+(.+)");
        Matcher m = pat.matcher(str);
        if (m.matches()) {
            ftpFile = new JFtpFile();
            if (m.group(1).equals("-")) {
                ftpFile.setType(1);
            } else if (m.group(1).equals("d")) {
                ftpFile.setType(2);
            } else if (m.group(1).equals("l")) {
                ftpFile.setType(3);
            }
            ftpFile.setRights(m.group(2));
            ftpFile.setNumberOfHardLinks(Integer.parseInt(m.group(3)));
            ftpFile.setUser(m.group(4));
            ftpFile.setGroup(m.group(5));
            ftpFile.setSize(Long.parseLong(m.group(6)));
            month = m.group(7);
            if (month.equalsIgnoreCase("jan")) {
                cal.set(2, 0);
            } else if (month.equalsIgnoreCase("feb")) {
                cal.set(2, 1);
            } else if (month.equalsIgnoreCase("mar")) {
                cal.set(2, 2);
            } else if (month.equalsIgnoreCase("apr")) {
                cal.set(2, 3);
            } else if (month.equalsIgnoreCase("may")) {
                cal.set(2, 4);
            } else if (month.equalsIgnoreCase("jun")) {
                cal.set(2, 5);
            } else if (month.equalsIgnoreCase("jul")) {
                cal.set(2, 6);
            } else if (month.equalsIgnoreCase("aug")) {
                cal.set(2, 7);
            } else if (month.equalsIgnoreCase("sep")) {
                cal.set(2, 8);
            } else if (month.equalsIgnoreCase("oct")) {
                cal.set(2, 9);
            } else if (month.equalsIgnoreCase("nov")) {
                cal.set(2, 10);
            } else if (month.equalsIgnoreCase("dec")) {
                cal.set(2, 11);
            }
            cal.set(5, Integer.parseInt(m.group(8)));
            ftpFile.setTimeStamp(cal);
            pat = Pattern.compile("(\\d{2}):(\\d{2})");
            m2 = pat.matcher(m.group(9));
            if (m2.matches()) {
                cal.set(11, Integer.parseInt(m2.group(1)));
                cal.set(12, Integer.parseInt(m2.group(2)));
                if (cal.get(2) > now.get(2)) {
                    cal.set(1, cal.get(1) - 1);
                }
            } else {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(1, Integer.parseInt(m.group(9)));
            }
            ftpFile.setName(this.parseFileName(m.group(10)));
            this.m_bHasLastListOutputHardlinks = true;
        }
        if (ftpFile == null && (m = (pat = Pattern.compile("([dl-])((?:[r-][w-][xst-]){3})\\s+([^\\s]+)\\s+(\\d+)\\s+(\\d+)\\s+([a-zA-Z]{3})\\s+(\\d{1,2})\\s+(\\d{4}|\\d{2}:\\d{2})\\s+(.+)")).matcher(str)).matches()) {
            ftpFile = new JFtpFile();
            if (m.group(1).equals("-")) {
                ftpFile.setType(1);
            } else if (m.group(1).equals("d")) {
                ftpFile.setType(2);
            } else if (m.group(1).equals("l")) {
                ftpFile.setType(3);
            }
            ftpFile.setRights(m.group(2));
            ftpFile.setNumberOfHardLinks(Integer.parseInt(m.group(3)));
            ftpFile.setUser(m.group(4));
            ftpFile.setSize(Long.parseLong(m.group(5)));
            month = m.group(6);
            if (month.equalsIgnoreCase("jan")) {
                cal.set(2, 0);
            } else if (month.equalsIgnoreCase("feb")) {
                cal.set(2, 1);
            } else if (month.equalsIgnoreCase("mar")) {
                cal.set(2, 2);
            } else if (month.equalsIgnoreCase("apr")) {
                cal.set(2, 3);
            } else if (month.equalsIgnoreCase("may")) {
                cal.set(2, 4);
            } else if (month.equalsIgnoreCase("jun")) {
                cal.set(2, 5);
            } else if (month.equalsIgnoreCase("jul")) {
                cal.set(2, 6);
            } else if (month.equalsIgnoreCase("aug")) {
                cal.set(2, 7);
            } else if (month.equalsIgnoreCase("sep")) {
                cal.set(2, 8);
            } else if (month.equalsIgnoreCase("oct")) {
                cal.set(2, 9);
            } else if (month.equalsIgnoreCase("nov")) {
                cal.set(2, 10);
            } else if (month.equalsIgnoreCase("dec")) {
                cal.set(2, 11);
            }
            cal.set(5, Integer.parseInt(m.group(7)));
            ftpFile.setTimeStamp(cal);
            pat = Pattern.compile("(\\d{2}):(\\d{2})");
            m2 = pat.matcher(m.group(8));
            if (m2.matches()) {
                cal.set(11, Integer.parseInt(m2.group(1)));
                cal.set(12, Integer.parseInt(m2.group(2)));
                if (cal.get(2) > now.get(2)) {
                    cal.set(1, cal.get(1) - 1);
                }
            } else {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(1, Integer.parseInt(m.group(8)));
            }
            ftpFile.setName(this.parseFileName(m.group(9)));
            this.m_bHasLastListOutputHardlinks = true;
        }
        if (ftpFile == null && (m = (pat = Pattern.compile("([dl-])((?:[r-][w-][xst-]){3})\\s+(\\d+)\\s+([^\\s]+)\\s+(\\d+)\\s+([a-zA-Z]{3})\\s+(\\d{1,2})\\s+(\\d{4}|\\d{2}:\\d{2})\\s+(.+)")).matcher(str)).matches()) {
            ftpFile = new JFtpFile();
            if (m.group(1).equals("-")) {
                ftpFile.setType(1);
            } else if (m.group(1).equals("d")) {
                ftpFile.setType(2);
            } else if (m.group(1).equals("l")) {
                ftpFile.setType(3);
            }
            ftpFile.setRights(m.group(2));
            ftpFile.setNumberOfHardLinks(Integer.parseInt(m.group(3)));
            ftpFile.setUser(m.group(4));
            ftpFile.setSize(Long.parseLong(m.group(5)));
            month = m.group(6);
            if (month.equalsIgnoreCase("jan")) {
                cal.set(2, 0);
            } else if (month.equalsIgnoreCase("feb")) {
                cal.set(2, 1);
            } else if (month.equalsIgnoreCase("mar")) {
                cal.set(2, 2);
            } else if (month.equalsIgnoreCase("apr")) {
                cal.set(2, 3);
            } else if (month.equalsIgnoreCase("may")) {
                cal.set(2, 4);
            } else if (month.equalsIgnoreCase("jun")) {
                cal.set(2, 5);
            } else if (month.equalsIgnoreCase("jul")) {
                cal.set(2, 6);
            } else if (month.equalsIgnoreCase("aug")) {
                cal.set(2, 7);
            } else if (month.equalsIgnoreCase("sep")) {
                cal.set(2, 8);
            } else if (month.equalsIgnoreCase("oct")) {
                cal.set(2, 9);
            } else if (month.equalsIgnoreCase("nov")) {
                cal.set(2, 10);
            } else if (month.equalsIgnoreCase("dec")) {
                cal.set(2, 11);
            }
            cal.set(5, Integer.parseInt(m.group(7)));
            ftpFile.setTimeStamp(cal);
            pat = Pattern.compile("(\\d{2}):(\\d{2})");
            m2 = pat.matcher(m.group(8));
            if (m2.matches()) {
                cal.set(11, Integer.parseInt(m2.group(1)));
                cal.set(12, Integer.parseInt(m2.group(2)));
                if (cal.get(2) > now.get(2)) {
                    cal.set(1, cal.get(1) - 1);
                }
            } else {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(1, Integer.parseInt(m.group(8)));
            }
            ftpFile.setName(this.parseFileName(m.group(9)));
            this.m_bHasLastListOutputHardlinks = true;
        }
        if (ftpFile == null && (m = (pat = Pattern.compile("([dl-])((?:[r-][w-][xst-]){3})\\s+(\\d+)\\s+([^\\s]+)\\s+@\\s+([^\\s]+)\\s+@\\s+(\\d+)\\s+([a-zA-Z]{3})\\s+(\\d{1,2})\\s+(\\d{4}|\\d{2}:\\d{2})\\s+(.+)")).matcher(str)).matches()) {
            ftpFile = new JFtpFile();
            if (m.group(1).equals("-")) {
                ftpFile.setType(1);
            } else if (m.group(1).equals("d")) {
                ftpFile.setType(2);
            } else if (m.group(1).equals("l")) {
                ftpFile.setType(3);
            }
            ftpFile.setRights(m.group(2));
            ftpFile.setNumberOfHardLinks(Integer.parseInt(m.group(3)));
            ftpFile.setUser(m.group(4));
            ftpFile.setGroup(m.group(5));
            ftpFile.setSize(Long.parseLong(m.group(6)));
            month = m.group(7);
            if (month.equalsIgnoreCase("jan")) {
                cal.set(2, 0);
            } else if (month.equalsIgnoreCase("feb")) {
                cal.set(2, 1);
            } else if (month.equalsIgnoreCase("mar")) {
                cal.set(2, 2);
            } else if (month.equalsIgnoreCase("apr")) {
                cal.set(2, 3);
            } else if (month.equalsIgnoreCase("may")) {
                cal.set(2, 4);
            } else if (month.equalsIgnoreCase("jun")) {
                cal.set(2, 5);
            } else if (month.equalsIgnoreCase("jul")) {
                cal.set(2, 6);
            } else if (month.equalsIgnoreCase("aug")) {
                cal.set(2, 7);
            } else if (month.equalsIgnoreCase("sep")) {
                cal.set(2, 8);
            } else if (month.equalsIgnoreCase("oct")) {
                cal.set(2, 9);
            } else if (month.equalsIgnoreCase("nov")) {
                cal.set(2, 10);
            } else if (month.equalsIgnoreCase("dec")) {
                cal.set(2, 11);
            }
            cal.set(5, Integer.parseInt(m.group(8)));
            ftpFile.setTimeStamp(cal);
            pat = Pattern.compile("(\\d{2}):(\\d{2})");
            m2 = pat.matcher(m.group(9));
            if (m2.matches()) {
                cal.set(11, Integer.parseInt(m2.group(1)));
                cal.set(12, Integer.parseInt(m2.group(2)));
                if (cal.get(2) > now.get(2)) {
                    cal.set(1, cal.get(1) - 1);
                }
            } else {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(1, Integer.parseInt(m.group(9)));
            }
            ftpFile.setName(this.parseFileName(m.group(10)));
            this.m_bHasLastListOutputHardlinks = true;
        }
        if (ftpFile == null && (m = (pat = Pattern.compile("(\\d{2})-(\\d{2})-(\\d{2})\\s+(\\d{2}):(\\d{2})([A|P]M)\\s+(<DIR>|\\d+)\\s+(.+)")).matcher(str)).matches()) {
            ftpFile = new JFtpFile();
            cal.set(2, Integer.parseInt(m.group(1)) - 1);
            cal.set(5, Integer.parseInt(m.group(2)));
            cal.set(1, Integer.parseInt(m.group(3)));
            cal.set(10, Integer.parseInt(m.group(4)));
            cal.set(12, Integer.parseInt(m.group(5)));
            cal.set(9, m.group(6).equalsIgnoreCase("pm") ? 1 : 0);
            ftpFile.setTimeStamp(cal);
            try {
                ftpFile.setSize(Long.parseLong(m.group(7)));
                ftpFile.setType(1);
            }
            catch (NumberFormatException ex) {
                ftpFile.setType(2);
            }
            ftpFile.setName(m.group(8));
            this.m_bHasLastListOutputHardlinks = false;
        }
        if (m_isDebug && ftpFile == null) {
            System.err.println("NO MATCH FOUND FOR '" + str + "'");
        }
        return ftpFile;
    }

    private void closeSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeSocket(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String parseFileName(String name) {
        Pattern pat = Pattern.compile("(.+)\\s+->\\s+(.+)");
        Matcher m = pat.matcher(name);
        if (m.matches()) {
            return m.group(1);
        }
        return name;
    }
}

