/*
 * Decompiled with CFR 0.152.
 */
package shared.files;

import java.io.File;

public class JPathHelper {
    public static String getFileExtension(File file) {
        return JPathHelper.getFileExtension(file.getName());
    }

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index >= 0) {
            return fileName.substring(index + 1, fileName.length());
        }
        return "";
    }

    public static String getBaseFileName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public static String getBaseFileName(String fileName) {
        return JPathHelper.getBaseFileName(new File(fileName));
    }

    public static String getFolder(File file) {
        String str = "";
        File parent = file.getParentFile();
        if (parent != null) {
            str = parent.getAbsolutePath();
        }
        return str;
    }

    public static String getFolder(String fileName) {
        return JPathHelper.getFolder(new File(fileName));
    }

    public static String getSubFolder(File file) {
        String str = "";
        File parent = file.getParentFile();
        if (parent != null) {
            str = parent.getName();
        }
        return str;
    }

    public static String getSubFolder(String fileName) {
        return JPathHelper.getSubFolder(new File(fileName));
    }

    public static void addSeparator(StringBuilder stringBuilder) {
        if (stringBuilder.length() != 0 && stringBuilder.charAt(stringBuilder.length() - 1) != File.separatorChar) {
            stringBuilder.append(File.separatorChar);
        }
    }

    public static String addSeparator(String str) {
        String nstr = new String(str);
        if (str.length() != 0 && str.charAt(str.length() - 1) != File.separatorChar) {
            nstr = nstr + File.separator;
        }
        return nstr;
    }
}

