/*
 * Decompiled with CFR 0.152.
 */
package shared.files;

import java.io.File;
import java.io.FilenameFilter;
import shared.files.JPathHelper;

public class JExtFileNameFilter
implements FilenameFilter {
    private String[] m_extArray;
    private boolean m_bListFolders;

    public JExtFileNameFilter(String ext, boolean bListFolders) {
        this.m_extArray = new String[1];
        this.m_extArray[0] = ext;
        this.m_bListFolders = bListFolders;
    }

    public JExtFileNameFilter(String[] ext, boolean bListFolders) {
        this.m_extArray = ext;
        this.m_bListFolders = bListFolders;
    }

    public boolean accept(File dir, String name) {
        String str = dir != null ? dir.getPath() : "";
        File file = new File(str = JPathHelper.addSeparator(str) + name);
        if (file.isDirectory()) {
            if (this.m_bListFolders) {
                return true;
            }
        } else {
            String ext = JPathHelper.getFileExtension(name);
            for (String extName : this.m_extArray) {
                if (!extName.equalsIgnoreCase(ext)) continue;
                return true;
            }
        }
        return false;
    }
}

