/*
 * Decompiled with CFR 0.152.
 */
package shared.circbufinputstream;

import java.io.IOException;
import java.io.InputStream;

public class JCircBufInputStream
extends InputStream {
    private byte[] m_buf;
    private int m_readPos;
    private int m_writePos;
    private int m_markPos;

    public JCircBufInputStream(int size) {
        this.m_buf = new byte[size];
        this.m_readPos = 0;
        this.m_writePos = 0;
        this.m_markPos = -1;
    }

    public int available() throws IOException {
        if (this.m_buf == null) {
            throw new IOException("Buffer is closed!");
        }
        if (this.m_writePos >= this.m_readPos) {
            return this.m_writePos - this.m_readPos;
        }
        return this.m_buf.length - this.m_readPos + this.m_writePos;
    }

    public void close() {
        this.m_buf = null;
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] b = new byte[]{};
        this.read(b, 0, 1);
        return b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.m_buf == null) {
            throw new IOException("Buffer is closed!");
        }
        if (b == null) {
            throw new NullPointerException("Invalid output buffer");
        }
        if (off < -1 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("negative skip values are not supported");
        }
        int size = -1;
        if (this.m_readPos <= this.m_writePos) {
            size = Math.min(len, this.m_writePos - this.m_readPos);
            System.arraycopy(this.m_buf, this.m_readPos, b, off, size);
            this.m_readPos += size;
        } else {
            size = Math.min(this.m_buf.length - this.m_readPos + this.m_writePos, len);
            if (size <= this.m_buf.length - this.m_readPos) {
                System.arraycopy(this.m_buf, this.m_readPos, b, off, size);
                this.m_readPos += size;
            } else {
                System.arraycopy(this.m_buf, this.m_readPos, b, off, this.m_buf.length - this.m_readPos);
                System.arraycopy(this.m_buf, 0, b, off + this.m_buf.length - this.m_readPos, size - (this.m_buf.length - this.m_readPos));
                this.m_readPos = size - (this.m_buf.length - this.m_readPos);
            }
        }
        if (this.m_readPos == this.m_buf.length) {
            this.m_readPos = 0;
        }
        return size;
    }

    public void reset() {
        this.m_markPos = -1;
    }

    public long skip(long n) {
        if (n < 0L) {
            throw new IndexOutOfBoundsException("negative skip values are not supported");
        }
        long skip = n;
        if (this.m_readPos <= this.m_writePos) {
            if ((long)this.m_readPos + n <= (long)this.m_writePos) {
                this.m_readPos = (int)((long)this.m_readPos + n);
            } else {
                skip = this.m_writePos - this.m_readPos;
                this.m_readPos = this.m_writePos;
            }
        } else if (n <= (long)(this.m_buf.length - this.m_readPos + this.m_writePos)) {
            this.m_readPos = (int)n - (this.m_buf.length - this.m_readPos);
        } else {
            skip = this.m_buf.length - this.m_readPos + this.m_writePos;
            this.m_readPos = this.m_writePos;
        }
        return skip;
    }

    public void write(byte[] buf, int offset, int size) throws IOException {
        if (this.m_buf == null) {
            throw new IOException("Buffer is closed!");
        }
        if (buf == null) {
            throw new NullPointerException("Invalid input buffer");
        }
        if (offset < 0 || size < 0 || offset + size > buf.length) {
            throw new IndexOutOfBoundsException("Invalid arguments");
        }
        if (this.m_readPos <= this.m_writePos) {
            if ((size = Math.min(size, this.m_buf.length - this.m_writePos + this.m_readPos)) <= this.m_buf.length - this.m_writePos) {
                System.arraycopy(buf, offset, this.m_buf, this.m_writePos, size);
                this.m_writePos += size;
            } else {
                System.arraycopy(buf, offset, this.m_buf, this.m_writePos, this.m_buf.length - this.m_writePos);
                System.arraycopy(buf, offset + this.m_buf.length - this.m_writePos, this.m_buf, 0, size - (this.m_buf.length - this.m_writePos));
                this.m_writePos = size - (this.m_buf.length - this.m_writePos);
            }
        }
        if (this.m_writePos == this.m_buf.length) {
            this.m_writePos = 0;
        }
    }
}

