/*
 * Decompiled with CFR 0.152.
 */
package jpass.xml.converter;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class JAXBConverter<T> {
    private final Class<T> documentClass;
    private final Schema schema;

    public JAXBConverter(Class<T> documentClass, String schemaLocation) {
        this.documentClass = documentClass;
        this.schema = this.getSchema(schemaLocation);
    }

    public void marshal(T document, OutputStream outputStream, Boolean formattedOutput) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.documentClass});
        Marshaller m = jc.createMarshaller();
        m.setSchema(this.schema);
        m.setProperty("jaxb.formatted.output", (Object)formattedOutput);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.marshal(document, outputStream);
    }

    public T unmarshal(InputStream inputStream) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.documentClass});
        Unmarshaller u = jc.createUnmarshaller();
        u.setSchema(this.schema);
        return (T)u.unmarshal(inputStream);
    }

    private Schema getSchema(String schemaLocation) {
        Schema ret = null;
        if (schemaLocation != null) {
            try {
                StreamSource source = new StreamSource(this.getClass().getClassLoader().getResourceAsStream(schemaLocation));
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                ret = sf.newSchema(source);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }
}

