/*
 * Decompiled with CFR 0.152.
 */
package jpass.util;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;

public final class CryptUtils {
    private CryptUtils() {
    }

    public static byte[] getPKCS5Sha256Hash(char[] text) throws Exception {
        return CryptUtils.getSha256Hash(text, 1000);
    }

    private static byte[] getSha256Hash(char[] text, int iteration) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.reset();
        byte[] bytes = new String(text).getBytes("UTF-8");
        byte[] digest = md.digest(bytes);
        for (int i = 0; i < iteration; ++i) {
            md.reset();
            digest = md.digest(digest);
        }
        return digest;
    }

    public static Random newRandomNumberGenerator() {
        Random ret;
        try {
            ret = new SecureRandom();
        }
        catch (Exception e) {
            ret = new Random();
        }
        return ret;
    }
}

