/*
 * Decompiled with CFR 0.152.
 */
package jpass.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public final class Configuration {
    private static volatile Configuration INSTANCE;
    private Properties properties = new Properties();

    private Configuration() {
        try {
            File filePointer = new File("jpass.properties");
            if (filePointer.exists() && filePointer.isFile()) {
                FileInputStream is = new FileInputStream(filePointer);
                this.properties.load(is);
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <T> T getValue(String key, T defaultValue, Class<T> type) {
        T value = defaultValue;
        String prop = this.properties.getProperty(key);
        if (prop != null) {
            try {
                value = type.getConstructor(String.class).newInstance(prop);
            }
            catch (Exception e) {
                System.err.println(String.format("Could not parse value as [%s] for key [%s]", type.getName(), key));
            }
        }
        return value;
    }

    public Boolean is(String key, Boolean defaultValue) {
        return this.getValue(key, defaultValue, Boolean.class);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.getValue(key, defaultValue, Integer.class);
    }

    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new Configuration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }
}

