/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui.helper;

import jpass.ui.EntryDialog;
import jpass.ui.JPassFrame;
import jpass.ui.MessageDialog;
import jpass.util.ClipboardUtils;
import jpass.xml.bind.Entry;

public final class EntryHelper {
    private EntryHelper() {
    }

    public static void deleteEntry(JPassFrame parent) {
        if (parent.getEntryTitleList().getSelectedIndex() == -1) {
            MessageDialog.showWarningMessage(parent, "Please select an entry.");
            return;
        }
        int option = MessageDialog.showQuestionMessage(parent, "Do you really want to delete this entry?", 0);
        if (option == 0) {
            String title = (String)parent.getEntryTitleList().getSelectedValue();
            parent.getModel().getEntries().getEntry().remove(parent.getModel().getEntryByTitle(title));
            parent.getModel().setModified(true);
            parent.refreshFrameTitle();
            parent.refreshEntryTitleList(null);
        }
    }

    public static void duplicateEntry(JPassFrame parent) {
        if (parent.getEntryTitleList().getSelectedIndex() == -1) {
            MessageDialog.showWarningMessage(parent, "Please select an entry.");
            return;
        }
        String title = (String)parent.getEntryTitleList().getSelectedValue();
        Entry oldEntry = parent.getModel().getEntryByTitle(title);
        EntryDialog ed = new EntryDialog(parent, "Duplicate Entry", oldEntry, true);
        if (ed.getFormData() != null) {
            parent.getModel().getEntries().getEntry().add(ed.getFormData());
            parent.getModel().setModified(true);
            parent.refreshFrameTitle();
            parent.refreshEntryTitleList(ed.getFormData().getTitle());
        }
    }

    public static void editEntry(JPassFrame parent) {
        if (parent.getEntryTitleList().getSelectedIndex() == -1) {
            MessageDialog.showWarningMessage(parent, "Please select an entry.");
            return;
        }
        String title = (String)parent.getEntryTitleList().getSelectedValue();
        Entry oldEntry = parent.getModel().getEntryByTitle(title);
        EntryDialog ed = new EntryDialog(parent, "Edit Entry", oldEntry, false);
        if (ed.getFormData() != null) {
            parent.getModel().getEntries().getEntry().remove(oldEntry);
            parent.getModel().getEntries().getEntry().add(ed.getFormData());
            parent.getModel().setModified(true);
            parent.refreshFrameTitle();
            parent.refreshEntryTitleList(ed.getFormData().getTitle());
        }
    }

    public static void addEntry(JPassFrame parent) {
        EntryDialog ed = new EntryDialog(parent, "Add New Entry", null, true);
        if (ed.getFormData() != null) {
            parent.getModel().getEntries().getEntry().add(ed.getFormData());
            parent.getModel().setModified(true);
            parent.refreshFrameTitle();
            parent.refreshEntryTitleList(ed.getFormData().getTitle());
        }
    }

    public static Entry getSelectedEntry(JPassFrame parent) {
        if (parent.getEntryTitleList().getSelectedIndex() == -1) {
            MessageDialog.showWarningMessage(parent, "Please select an entry.");
            return null;
        }
        return parent.getModel().getEntryByTitle((String)parent.getEntryTitleList().getSelectedValue());
    }

    public static void copyEntryField(JPassFrame parent, String content) {
        try {
            ClipboardUtils.setClipboardContent(content);
        }
        catch (Exception e) {
            MessageDialog.showErrorMessage(parent, e.getMessage());
        }
    }
}

