/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import jpass.ui.MessageDialog;
import jpass.ui.TextComponentFactory;
import jpass.util.Configuration;
import jpass.util.CryptUtils;
import jpass.util.SpringUtilities;

public final class GeneratePasswordDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1807066563698740446L;
    private static final String SYMBOLS = "!\"#$%&'()*+,-./:;<=>?@[\\]^_{|}~";
    private static final String[][] passwordOptions = new String[][]{{"Upper case letters (A-Z)", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"}, {"Lower case letters (a-z)", "abcdefghijklmnopqrstuvwxyz"}, {"Numbers (0-9)", "0123456789"}};
    private JCheckBox[] checkBoxes;
    private JCheckBox customSymbolsCheck;
    private JTextField customSymbolsField;
    private JTextField passwordField;
    private JLabel lengthLabel;
    private JSpinner lengthSpinner;
    private JPanel lengthPanel;
    private JPanel charactersPanel;
    private JPanel passwordPanel;
    private JPanel buttonPanel;
    private JButton acceptButton;
    private JButton cancelButton;
    private JButton generateButton;
    private String generatedPassword;
    private Random random = CryptUtils.newRandomNumberGenerator();

    public GeneratePasswordDialog(JFrame parent) {
        super(parent);
        this.initDialog(parent, false);
    }

    public GeneratePasswordDialog(JDialog parent) {
        super(parent);
        this.initDialog(parent, true);
    }

    private void initDialog(Component parent, boolean showAcceptButton) {
        this.setModal(true);
        this.setTitle("Generate Password");
        this.setDefaultCloseOperation(2);
        this.generatedPassword = null;
        this.lengthPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.lengthLabel = new JLabel("Password length:");
        this.lengthPanel.add(this.lengthLabel);
        int passwordGenerationLength = Configuration.getInstance().getInteger("default.password.generation.length", 14);
        if (passwordGenerationLength > 64) {
            passwordGenerationLength = 64;
        }
        if (passwordGenerationLength < 1) {
            passwordGenerationLength = 1;
        }
        this.lengthSpinner = new JSpinner(new SpinnerNumberModel(passwordGenerationLength, 1, 64, 1));
        this.lengthPanel.add(this.lengthSpinner);
        this.charactersPanel = new JPanel();
        this.charactersPanel.setBorder(new TitledBorder("Settings"));
        this.charactersPanel.add(this.lengthPanel);
        this.checkBoxes = new JCheckBox[passwordOptions.length];
        for (int i = 0; i < passwordOptions.length; ++i) {
            this.checkBoxes[i] = new JCheckBox(passwordOptions[i][0], true);
            this.charactersPanel.add(this.checkBoxes[i]);
        }
        this.customSymbolsCheck = new JCheckBox("Custom symbols");
        this.customSymbolsCheck.setActionCommand("custom_symbols_check");
        this.customSymbolsCheck.addActionListener(this);
        this.charactersPanel.add(this.customSymbolsCheck);
        this.customSymbolsField = TextComponentFactory.newTextField(SYMBOLS);
        this.customSymbolsField.setEditable(false);
        this.charactersPanel.add(this.customSymbolsField);
        this.charactersPanel.setLayout(new SpringLayout());
        SpringUtilities.makeCompactGrid(this.charactersPanel, 6, 1, 5, 5, 5, 5);
        this.passwordPanel = new JPanel(new BorderLayout());
        this.passwordPanel.setBorder(new TitledBorder("Generated password"));
        this.passwordField = TextComponentFactory.newTextField();
        this.passwordPanel.add((Component)this.passwordField, "North");
        this.generateButton = new JButton("Generate", MessageDialog.getIcon("generate"));
        this.generateButton.setActionCommand("generate_button");
        this.generateButton.addActionListener(this);
        this.generateButton.setMnemonic(71);
        JPanel generateButtonPanel = new JPanel(new FlowLayout(2, 0, 0));
        generateButtonPanel.add(this.generateButton);
        this.passwordPanel.add((Component)generateButtonPanel, "South");
        this.buttonPanel = new JPanel(new FlowLayout(2));
        if (showAcceptButton) {
            this.acceptButton = new JButton("Accept", MessageDialog.getIcon("accept"));
            this.acceptButton.setActionCommand("accept_button");
            this.acceptButton.setMnemonic(65);
            this.acceptButton.addActionListener(this);
            this.buttonPanel.add(this.acceptButton);
            this.cancelButton = new JButton("Cancel", MessageDialog.getIcon("cancel"));
        } else {
            this.cancelButton = new JButton("Close", MessageDialog.getIcon("close"));
        }
        this.cancelButton.setActionCommand("cancel_button");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.charactersPanel, "North");
        this.getContentPane().add((Component)this.passwordPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setResizable(false);
        this.pack();
        this.setSize((int)((double)this.getWidth() * 1.5), this.getHeight());
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("custom_symbols_check".equals(command)) {
            this.customSymbolsField.setEditable(((JCheckBox)e.getSource()).isSelected());
        } else if ("generate_button".equals(command)) {
            String characterSet = "";
            for (int i = 0; i < passwordOptions.length; ++i) {
                if (!this.checkBoxes[i].isSelected()) continue;
                characterSet = characterSet + passwordOptions[i][1];
            }
            if (this.customSymbolsCheck.isSelected()) {
                characterSet = characterSet + this.customSymbolsField.getText();
            }
            if (characterSet.isEmpty()) {
                MessageDialog.showWarningMessage(this, "Cannot generate password.\nPlease select a character set.");
                return;
            }
            StringBuilder generated = new StringBuilder();
            int passwordLength = Integer.parseInt(String.valueOf(this.lengthSpinner.getValue()));
            for (int i = 0; i < passwordLength; ++i) {
                generated.append(characterSet.charAt(this.random.nextInt(characterSet.length())));
            }
            this.passwordField.setText(generated.toString());
        } else if ("accept_button".equals(command)) {
            this.generatedPassword = this.passwordField.getText();
            if (this.generatedPassword.isEmpty()) {
                MessageDialog.showWarningMessage(this, "Please generate a password.");
                return;
            }
            this.dispose();
        } else if ("cancel_button".equals(command)) {
            this.dispose();
        }
    }

    public String getGeneratedPassword() {
        return this.generatedPassword;
    }
}

