/*
 * Decompiled with CFR 0.152.
 */
package com.nm.resedit;

import com.nm.resedit.ResourceDir;
import com.nm.resedit.ResourceFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

class ResourceArchive {
    private static final String SUFFIX = ".properties";
    private static final String PREFIX = "resources";
    private ResourceDir root = new ResourceDir("");
    private String name;

    ResourceArchive(String string, String string2, boolean bl, InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        this.name = string;
        String string3 = PREFIX + (string2 == null ? "" : "_" + string2) + SUFFIX.toLowerCase();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.isDirectory() && zipEntry.getName().toLowerCase().endsWith(string3)) {
                this.root.put(new ResourceFile(zipEntry, zipInputStream, bl));
            }
            zipInputStream.closeEntry();
        }
        if (this.root.getChildCount() == 0) {
            throw new IOException("No entries found in archive for " + this.locale2string(string2) + " locale");
        }
    }

    private String locale2string(String string) {
        if (string == null) {
            return "'default'";
        }
        return "'" + string + "'";
    }

    void writeTo(OutputStream outputStream, boolean bl, String string) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        this.root.writeTo(zipOutputStream, bl, PREFIX + (string == null ? "" : "_" + string) + SUFFIX);
        zipOutputStream.finish();
    }

    ResourceDir getRoot() {
        return this.root;
    }

    String getName() {
        return this.name;
    }

    public void setTranslation(InputStream inputStream, String string, boolean bl) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        String string2 = PREFIX + (string == null ? "" : "_" + string) + SUFFIX.toLowerCase();
        boolean bl2 = false;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.isDirectory() && zipEntry.getName().endsWith(string2)) {
                this.root.setTranslation(zipEntry.getName(), (InputStream)zipInputStream, bl);
                bl2 = true;
            }
            zipInputStream.closeEntry();
        }
        if (!bl2) {
            throw new IOException("No entries found in archive for " + this.locale2string(string) + " locale");
        }
    }
}

