/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class ZoomTool
extends DragTool {
    private static final int BOX_TOLERANCE = 4;
    private static final double ZOOM_IN_FACTOR = 2.0;
    private Cursor cursor;

    public ZoomTool(Cursor cursor) {
        this.setColor(Color.black);
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    protected void gestureFinished() throws NoninvertibleTransformException {
        double d = Math.min(this.getViewSource().getX(), this.getViewDestination().getX());
        double d2 = Math.max(this.getViewSource().getX(), this.getViewDestination().getX());
        double d3 = Math.min(this.getViewSource().getY(), this.getViewDestination().getY());
        double d4 = Math.max(this.getViewSource().getY(), this.getViewDestination().getY());
        double d5 = d2 - d;
        double d6 = d4 - d3;
        if (d5 == 0.0 && d6 == 0.0) {
            return;
        }
        if (d5 < 4.0 && d6 < 4.0) {
            this.zoomAt(new Point2D.Double(MathUtil.avg(d, d2), MathUtil.avg(d3, d4)), 2.0);
            return;
        }
        Point2D.Double double_ = new Point2D.Double(d + d5 / 2.0, d3 + d6 / 2.0);
        this.getPanel().getViewport().zoom(double_, d5, d6);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            double d = SwingUtilities.isRightMouseButton(mouseEvent) ? 0.5 : 2.0;
            this.zoomAt(mouseEvent.getPoint(), d);
        }
        catch (Throwable throwable) {
            this.getPanel().getContext().handleThrowable(throwable);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                super.mousePressed(mouseEvent);
            }
        }
        catch (Throwable throwable) {
            this.getPanel().getContext().handleThrowable(throwable);
        }
    }

    private void zoomAt(Point2D point2D, double d) throws NoninvertibleTransformException {
        this.getPanel().getViewport().zoomToViewPoint(point2D, d);
    }

    public boolean isRightMouseButtonUsed() {
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
    }

    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
    }

    public void deactivate() {
        super.deactivate();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }
}

