/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class ThreadQueue {
    private volatile int runningThreads = 0;
    private Vector queuedRunnables = new Vector();
    private int maxRunningThreads;
    private ArrayList listeners = new ArrayList();
    private volatile boolean enabled = true;

    public ThreadQueue(int n) {
        this.maxRunningThreads = n;
    }

    public void clear() {
        this.queuedRunnables.clear();
    }

    private void processQueue() {
        while (!this.queuedRunnables.isEmpty() && this.runningThreads < this.maxRunningThreads && this.enabled) {
            this.setRunningThreads(this.getRunningThreads() + 1);
            new Thread((Runnable)this.queuedRunnables.remove(0)).start();
        }
    }

    private void setRunningThreads(int n) {
        this.runningThreads = n;
        if (n == 0) {
            this.fireAllRunningThreadsFinished();
        }
    }

    public void add(final Runnable runnable) {
        this.queuedRunnables.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    runnable.run();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    ThreadQueue.this.setRunningThreads(ThreadQueue.this.getRunningThreads() - 1);
                    ThreadQueue.this.processQueue();
                    throw throwable;
                }
                ThreadQueue.this.setRunningThreads(ThreadQueue.this.getRunningThreads() - 1);
                ThreadQueue.this.processQueue();
            }
        });
        this.processQueue();
    }

    public int getRunningThreads() {
        return this.runningThreads;
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    private void fireAllRunningThreadsFinished() {
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            listener.allRunningThreadsFinished();
        }
    }

    public void dispose() {
        this.enabled = false;
    }

    public static interface Listener {
        public void allRunningThreadsFinished();
    }
}

