/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ImageCachingFeatureCollectionRenderer
extends ImageCachingRenderer {
    private Collection styles = new ArrayList();
    private Map layerToFeaturesMap = new HashMap();

    public ImageCachingFeatureCollectionRenderer(Object object, LayerViewPanel layerViewPanel) {
        super(object, layerViewPanel);
    }

    protected void setLayerToFeaturesMap(Map map) {
        this.layerToFeaturesMap = map;
    }

    protected void setStyles(Collection collection) {
        this.styles = collection;
    }

    protected void renderHook(ThreadSafeImage threadSafeImage, Collection collection, Layer layer, final Style style) throws Exception {
        if (!layer.isVisible()) {
            return;
        }
        if (!style.isEnabled()) {
            return;
        }
        style.initialize(layer);
        Iterator iterator = new ArrayList(collection).iterator();
        while (iterator.hasNext()) {
            final Feature feature = (Feature)iterator.next();
            if (this.cancelled) break;
            if (feature.getGeometry().isEmpty()) continue;
            threadSafeImage.draw(new ThreadSafeImage.Drawer(){

                public void draw(Graphics2D graphics2D) throws Exception {
                    style.paint(feature, graphics2D, ImageCachingFeatureCollectionRenderer.this.panel.getViewport());
                }
            });
        }
    }

    protected void renderHook(ThreadSafeImage threadSafeImage) throws Exception {
        Iterator iterator = this.styles.iterator();
        while (iterator.hasNext()) {
            Style style = (Style)iterator.next();
            Iterator iterator2 = this.layerToFeaturesMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Layer layer = (Layer)iterator2.next();
                Collection collection = (Collection)this.layerToFeaturesMap.get(layer);
                this.renderHook(threadSafeImage, collection, layer, style);
            }
        }
    }
}

