/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LineStringSelection;
import com.vividsolutions.jump.workbench.ui.PartSelection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SelectionManager {
    private FeatureSelection featureSelection;
    private PartSelection partSelection;
    private LineStringSelection lineStringSelection;
    private LayerManagerProxy layerManagerProxy;
    private LayerViewPanel panel;
    private boolean panelUpdatesEnabled = true;
    private LayerListener layerListener = new LayerListener(){

        public void featuresChanged(FeatureEvent featureEvent) {
            if (featureEvent.getType() == FeatureEventType.DELETED) {
                SelectionManager.this.unselectItems(featureEvent.getLayer(), featureEvent.getFeatures());
            }
            if (featureEvent.getType() == FeatureEventType.GEOMETRY_MODIFIED) {
                SelectionManager.this.unselectFromFeaturesWithModifiedItemCounts(featureEvent.getLayer(), featureEvent.getFeatures(), featureEvent.getOldFeatureClones());
            }
        }

        public void layerChanged(LayerEvent layerEvent) {
            if (!(layerEvent.getLayerable() instanceof Layer)) {
                return;
            }
            if (layerEvent.getType() == LayerEventType.REMOVED || layerEvent.getType() == LayerEventType.VISIBILITY_CHANGED) {
                SelectionManager.this.unselectItems((Layer)layerEvent.getLayerable());
            }
        }

        public void categoryChanged(CategoryEvent categoryEvent) {
        }
    };
    private List selections;

    public Collection createFeaturesFromSelectedItems() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getLayersWithSelectedItems().iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            arrayList.addAll(this.createFeaturesFromSelectedItems(layer));
        }
        return arrayList;
    }

    public Collection createFeaturesFromSelectedItems(Layer layer) {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        Iterator iterator = this.getFeaturesWithSelectedItems(layer).iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            Iterator iterator2 = this.getSelectedItems(layer, feature).iterator();
            while (iterator2.hasNext()) {
                Geometry geometry = (Geometry)iterator2.next();
                Feature feature2 = (Feature)feature.clone();
                feature2.setGeometry(geometry);
                arrayList.add(feature2);
            }
        }
        return arrayList;
    }

    public SelectionManager(LayerViewPanel layerViewPanel, LayerManagerProxy layerManagerProxy) {
        this.panel = layerViewPanel;
        this.layerManagerProxy = layerManagerProxy;
        this.featureSelection = new FeatureSelection(this);
        this.lineStringSelection = new LineStringSelection(this);
        this.partSelection = new PartSelection(this);
        this.featureSelection.setParent(null);
        this.featureSelection.setChild(this.partSelection);
        this.partSelection.setParent(this.featureSelection);
        this.partSelection.setChild(this.lineStringSelection);
        this.lineStringSelection.setParent(this.partSelection);
        this.lineStringSelection.setChild(null);
        this.selections = Collections.unmodifiableList(Arrays.asList(this.featureSelection, this.partSelection, this.lineStringSelection));
        this.addLayerListenerTo(layerManagerProxy.getLayerManager());
    }

    private void addLayerListenerTo(LayerManager layerManager) {
        layerManager.addLayerListener(this.layerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean bl = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            Iterator iterator = this.selections.iterator();
            while (iterator.hasNext()) {
                AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
                abstractSelection.unselectItems();
            }
        }
        finally {
            this.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    public FeatureSelection getFeatureSelection() {
        return this.featureSelection;
    }

    public LineStringSelection getLineStringSelection() {
        return this.lineStringSelection;
    }

    public Collection getSelections() {
        return this.selections;
    }

    public Collection getSelectedItems() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
            arrayList.addAll(abstractSelection.getSelectedItems());
        }
        return arrayList;
    }

    public Collection getSelectedItems(Layer layer) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
            arrayList.addAll(abstractSelection.getSelectedItems(layer));
        }
        return arrayList;
    }

    public Collection getSelectedItems(Layer layer, Feature feature) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
            arrayList.addAll(abstractSelection.getSelectedItems(layer, feature));
        }
        return arrayList;
    }

    public Collection getSelectedItems(Layer layer, Feature feature, Geometry geometry) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
            arrayList.addAll(abstractSelection.getSelectedItems(layer, feature, geometry));
        }
        return arrayList;
    }

    public Collection getLayersWithSelectedItems() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
            hashSet.addAll(abstractSelection.getLayersWithSelectedItems());
        }
        return hashSet;
    }

    public PartSelection getPartSelection() {
        return this.partSelection;
    }

    public void updatePanel() {
        if (!this.panelUpdatesEnabled) {
            return;
        }
        this.panel.fireSelectionChanged();
        this.panel.getRenderingManager().render("SELECTION_BACKGROUND");
        Iterator iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
            this.panel.getRenderingManager().render(abstractSelection.getRendererContentID());
        }
    }

    public void setPanelUpdatesEnabled(boolean bl) {
        this.panelUpdatesEnabled = bl;
    }

    public Collection getFeaturesWithSelectedItems(Layer layer) {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
            hashSet.addAll(abstractSelection.getFeaturesWithSelectedItems(layer));
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer) {
        boolean bl = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            Iterator iterator = this.selections.iterator();
            while (iterator.hasNext()) {
                AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
                abstractSelection.unselectItems(layer);
            }
        }
        finally {
            this.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, Collection collection) {
        boolean bl = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            Iterator iterator = this.selections.iterator();
            while (iterator.hasNext()) {
                AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
                abstractSelection.unselectItems(layer, collection);
            }
        }
        finally {
            this.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectFromFeaturesWithModifiedItemCounts(Layer layer, Collection collection, Collection collection2) {
        boolean bl = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            Iterator iterator = this.selections.iterator();
            while (iterator.hasNext()) {
                AbstractSelection abstractSelection = (AbstractSelection)iterator.next();
                abstractSelection.unselectFromFeaturesWithModifiedItemCounts(layer, collection, collection2);
            }
        }
        finally {
            this.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    public Collection getFeaturesWithSelectedItems() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getLayersWithSelectedItems().iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            arrayList.addAll(this.getFeaturesWithSelectedItems(layer));
        }
        return arrayList;
    }

    public boolean arePanelUpdatesEnabled() {
        return this.panelUpdatesEnabled;
    }

    public void dispose() {
        this.layerManagerProxy.getLayerManager().removeLayerListener(this.layerListener);
    }
}

