/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;

public abstract class AbstractLayerable
implements Layerable {
    private LayerManager layerManager;
    private String name;
    private boolean visible = true;

    public AbstractLayerable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLayerable(String string, LayerManager layerManager) {
        Assert.isTrue(string != null);
        Assert.isTrue(layerManager != null);
        this.setLayerManager(layerManager);
        boolean bl = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            this.setName(layerManager.uniqueLayerName(string));
        }
        finally {
            layerManager.setFiringEvents(bl);
        }
    }

    public void setLayerManager(LayerManager layerManager) {
        this.layerManager = layerManager;
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public void fireLayerChanged(LayerEventType layerEventType) {
        if (this.getLayerManager() == null) {
            return;
        }
        this.getLayerManager().fireLayerChanged(this, layerEventType);
    }

    public void fireAppearanceChanged() {
        this.fireLayerChanged(LayerEventType.APPEARANCE_CHANGED);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    public void setVisible(boolean bl) {
        if (this.visible == bl) {
            return;
        }
        this.visible = bl;
        this.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return this.getName();
    }
}

