/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jts.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtil {
    public static String s(int n) {
        return n != 1 ? "s" : "";
    }

    public static String ies(int n) {
        return n != 1 ? "ies" : "y";
    }

    public static String classNameWithoutQualifiers(String string) {
        return string.substring(Math.max(string.lastIndexOf("."), string.lastIndexOf("$")) + 1);
    }

    public static String classNameWithoutPackageQualifiers(String string) {
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static String repeat(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String split(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (i % n == 0 && i > 0) {
                bl = true;
            }
            char c = string.charAt(i);
            if (bl && c == ' ') {
                stringBuffer.append("\n");
                bl = false;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String capitalize(String string) {
        if (string.length() == 0) {
            return string;
        }
        return (string.charAt(0) + "").toUpperCase() + string.substring(1);
    }

    public static String uncapitalize(String string) {
        if (string.length() == 0) {
            return string;
        }
        return (string.charAt(0) + "").toLowerCase() + string.substring(1);
    }

    public static List fromCommaDelimitedString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().toString().trim());
        }
        return arrayList;
    }

    public static List blankStringList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add("");
        }
        return arrayList;
    }

    public static String toFriendlyName(String string) {
        return StringUtil.toFriendlyName(string, null);
    }

    public static String friendlyName(Class clazz) {
        return StringUtil.toFriendlyName(clazz.getName());
    }

    public static String toFriendlyName(String string, String string2) {
        String string3 = string;
        if (string2 != null) {
            string3 = StringUtil.replaceAll(string3, string2, "");
        }
        string3 = StringUtil.classNameWithoutQualifiers(string3);
        string3 = StringUtil.insertSpaces(string3);
        return string3;
    }

    public static String insertSpaces(String string) {
        if (string.length() < 2) {
            return string;
        }
        String string2 = "";
        for (int i = 0; i < string.length() - 2; ++i) {
            string2 = string2 + string.charAt(i);
            if ((!Character.isLowerCase(string.charAt(i)) || !Character.isUpperCase(string.charAt(i + 1))) && (!Character.isUpperCase(string.charAt(i + 1)) || !Character.isLowerCase(string.charAt(i + 2)))) continue;
            string2 = string2 + " ";
        }
        string2 = string2 + string.charAt(string.length() - 2);
        string2 = string2 + string.charAt(string.length() - 1);
        return string2.trim();
    }

    public static String toCommaDelimitedString(Collection collection) {
        return StringUtil.toDelimitedString(collection, ", ");
    }

    public static String replaceAll(String string, String string2, String string3) {
        return StringUtil.replace(string, string2, string3, true);
    }

    public static String replace(String string, String string2, String string3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringUtil.replace(stringBuffer, string2, string3, bl);
        return stringBuffer.toString();
    }

    public static void replace(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (stringBuffer == null || string == null || string.length() == 0 || string2 == null) {
            throw new IllegalArgumentException("Null or zero-length String");
        }
        int n = 0;
        while (n + string.length() <= stringBuffer.length()) {
            if (stringBuffer.substring(n, n + string.length()).equals(string)) {
                stringBuffer.replace(n, n + string.length(), string2);
                if (!bl) break;
                n += string2.length();
                continue;
            }
            ++n;
        }
    }

    public static String stackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    public static String head(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n' || ++n2 != n) continue;
            return string.substring(0, i);
        }
        return string;
    }

    public static String limitLength(String string, int n) {
        Assert.isTrue(n >= 3);
        if (string == null) {
            return null;
        }
        if (string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    public static boolean isNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String toDelimitedString(Collection collection, String string) {
        if (collection.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append(string + (e == null ? "" : e.toString()));
        }
        return stringBuffer.substring(string.length());
    }
}

