/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CollectionMap
implements Map {
    private Map map;
    private Class collectionClass = ArrayList.class;

    public CollectionMap(Class clazz) {
        try {
            this.map = (Map)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            Assert.shouldNeverReachHere();
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.shouldNeverReachHere();
        }
    }

    public CollectionMap(Class clazz, Class clazz2) {
        this.collectionClass = clazz2;
        try {
            this.map = (Map)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            Assert.shouldNeverReachHere();
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.shouldNeverReachHere();
        }
    }

    public CollectionMap() {
        this(HashMap.class);
    }

    private Collection getItemsInternal(Object object) {
        Collection collection = (Collection)this.map.get(object);
        if (collection == null) {
            try {
                collection = (Collection)this.collectionClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                Assert.shouldNeverReachHere();
            }
            catch (IllegalAccessException illegalAccessException) {
                Assert.shouldNeverReachHere();
            }
            this.map.put(object, collection);
        }
        return collection;
    }

    public void addItem(Object object, Object object2) {
        this.getItemsInternal(object).add(object2);
    }

    public void removeItem(Object object, Object object2) {
        this.getItemsInternal(object).remove(object2);
    }

    public void clear() {
        this.map.clear();
    }

    public void addItems(Object object, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addItem(object, iterator.next());
        }
    }

    public void addItems(CollectionMap collectionMap) {
        Iterator iterator = collectionMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.addItems(e, collectionMap.getItems(e));
        }
    }

    public Collection values() {
        return this.map.values();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public Object get(Object object) {
        return this.getItems(object);
    }

    public Collection getItems(Object object) {
        return Collections.unmodifiableCollection(this.getItemsInternal(object));
    }

    public Object remove(Object object) {
        return this.map.remove(object);
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Object put(Object object, Object object2) {
        Assert.isTrue(object2 instanceof Collection);
        return this.map.put(object, object2);
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    public void removeItems(Object object, Collection collection) {
        this.getItemsInternal(object).removeAll(collection);
    }

    public Map getMap() {
        return this.map;
    }
}

