/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jump.util.MathUtil;

public class InteriorPointFinder {
    private GeometryFactory factory = new GeometryFactory();

    public Coordinate findPoint(Geometry geometry) {
        if (geometry.isEmpty()) {
            return new Coordinate(0.0, 0.0);
        }
        if (geometry.getDimension() == 0) {
            return geometry.getCoordinate();
        }
        if (geometry instanceof GeometryCollection) {
            return this.findPoint(((GeometryCollection)geometry).getGeometryN(0));
        }
        Geometry geometry2 = this.envelopeMiddle(geometry);
        if (geometry2 instanceof Point) {
            return geometry2.getCoordinate();
        }
        Geometry geometry3 = geometry2.intersection(geometry);
        Geometry geometry4 = this.widestGeometry(geometry3);
        return this.centre(geometry4.getEnvelopeInternal());
    }

    protected Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    private Geometry widestGeometry(GeometryCollection geometryCollection) {
        if (geometryCollection.isEmpty()) {
            return geometryCollection;
        }
        Geometry geometry = geometryCollection.getGeometryN(0);
        for (int i = 1; i < geometryCollection.getNumGeometries(); ++i) {
            if (!(geometryCollection.getGeometryN(i).getEnvelopeInternal().getWidth() > geometry.getEnvelopeInternal().getWidth())) continue;
            geometry = geometryCollection.getGeometryN(i);
        }
        return geometry;
    }

    protected Geometry envelopeMiddle(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        if (envelope.getWidth() == 0.0) {
            return this.factory.createPoint(this.centre(envelope));
        }
        return this.factory.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), MathUtil.avg(envelope.getMinY(), envelope.getMaxY())), new Coordinate(envelope.getMaxX(), MathUtil.avg(envelope.getMinY(), envelope.getMaxY()))});
    }

    public Coordinate centre(Envelope envelope) {
        return new Coordinate(MathUtil.avg(envelope.getMinX(), envelope.getMaxX()), MathUtil.avg(envelope.getMinY(), envelope.getMaxY()));
    }
}

