/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jts.geom.Coordinate;

public class Angle {
    public static final double PI_TIMES_2 = Math.PI * 2;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    public static int COUNTERCLOCKWISE = 0;
    public static int CLOCKWISE = 1;
    public static int NONE = 2;

    public static double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double angle(Coordinate coordinate, Coordinate coordinate2) {
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate2.y - coordinate.y;
        return Math.atan2(d2, d);
    }

    public static double toRadians(double d) {
        return d * Math.PI / 180.0;
    }

    public static double angleBetween(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = Angle.angle(coordinate, coordinate2);
        double d2 = Angle.angle(coordinate, coordinate3);
        return Angle.diff(d, d2);
    }

    public static double interiorAngle(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = Angle.angle(coordinate2, coordinate);
        double d2 = Angle.angle(coordinate2, coordinate3);
        return Math.abs(d2 - d);
    }

    public static int getTurn(double d, double d2) {
        double d3 = Math.sin(d2 - d);
        if (d3 > 0.0) {
            return COUNTERCLOCKWISE;
        }
        if (d3 < 0.0) {
            return CLOCKWISE;
        }
        return NONE;
    }

    public static double normalize(double d) {
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        while (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static double diff(double d, double d2) {
        double d3 = d < d2 ? d2 - d : d - d2;
        if (d3 > Math.PI) {
            d3 = Math.PI * 2 - d3;
        }
        return d3;
    }
}

